/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.block.BlockNetherrackPath;
import nex.block.BlockTilledSoulSand;
import nex.entity.item.EntityObsidianBoat;
import nex.entity.monster.EntityGhastling;
import nex.entity.monster.EntityNethermite;
import nex.entity.monster.EntitySpore;
import nex.handler.ConfigHandler;
import nex.init.NetherExBiomes;
import nex.init.NetherExBlocks;
import nex.init.NetherExEffects;
import nex.init.NetherExItems;
import nex.init.NetherExMaterials;
import nex.util.ArmorUtil;
import nex.util.BlockUtil;
import nex.util.EntityUtil;
import nex.village.PigtificateVillageCollection;
import nex.village.PigtificateVillageManager;

@Mod.EventBusSubscriber(modid="nex")
public class EventHandler {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            PigtificateVillageManager.init(world);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        PigtificateVillageCollection villages;
        if (event.phase == TickEvent.Phase.START && (villages = PigtificateVillageManager.getPigtificateVillages(event.world)) != null) {
            villages.tick();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMouse(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70644_a((Potion)NetherExEffects.FREEZE)) {
            KeyBinding.func_74506_a();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderBlockOverlay(RenderBlockOverlayEvent event) {
        RenderBlockOverlayEvent.OverlayType type = event.getOverlayType();
        EntityPlayer player = event.getPlayer();
        World world = player.func_130014_f_();
        if (type == RenderBlockOverlayEvent.OverlayType.FIRE && (player.func_184218_aH() && player.func_184187_bx() instanceof EntityObsidianBoat || ArmorUtil.isWearingFullArmorSet(player, NetherExMaterials.ARMOR_HIDE_SALAMANDER))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state;
        Block block;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        if ((stack.func_77973_b() == NetherExItems.TOOL_SHOVEL_BONE || ConfigHandler.block.netherrack.allowAllShovelsToFlatten && stack.func_77973_b() instanceof ItemHoe) && ((block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150424_aL || block == NetherExBlocks.BLOCK_NETHERRACK || block == NetherExBlocks.BLOCK_HYPHAE)) {
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemSpade)) continue;
                player.func_184609_a(hand);
            }
            int meta = block == Blocks.field_150424_aL ? 0 : (block == NetherExBlocks.BLOCK_HYPHAE ? 3 : NetherExBlocks.BLOCK_NETHERRACK.func_176201_c(state) + 1);
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, NetherExBlocks.BLOCK_NETHERRACK_PATH.func_176223_P().func_177226_a(BlockNetherrackPath.TYPE, (Comparable)((Object)BlockNetherrackPath.EnumType.fromMeta(meta))), 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        if ((stack.func_77973_b() == NetherExItems.TOOL_HOE_BONE || ConfigHandler.block.soulSand.allowAllHoesToTill && stack.func_77973_b() instanceof ItemHoe) && world.func_180495_p(pos).func_177230_c() == Blocks.field_150425_aM) {
            for (EnumHand hand : EnumHand.values()) {
                if (!(player.func_184586_b(hand).func_77973_b() instanceof ItemHoe)) continue;
                player.func_184609_a(hand);
            }
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, NetherExBlocks.BLOCK_SAND_SOUL_TILLED.func_176223_P(), 11);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public static void onBoneMealUse(BonemealEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getBlock();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == NetherExItems.ITEM_DUST_WITHER) {
            if (state.func_177230_c() == Blocks.field_150388_bm) {
                int age = (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a);
                if (age < 3) {
                    state = state.func_177226_a((IProperty)BlockNetherWart.field_176486_a, (Comparable)Integer.valueOf(age + 1));
                    world.func_175656_a(pos, state);
                    event.setResult(Event.Result.ALLOW);
                }
            } else if (state.func_177230_c() instanceof IGrowable) {
                IGrowable growable = (IGrowable)state.func_177230_c();
                if (growable.func_176473_a(world, pos, state, world.field_72995_K)) {
                    growable.func_176474_b(world, world.field_73012_v, pos, state);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        EnumFacing facing = event.getFace();
        BlockPos originalPos = event.getPos();
        BlockPos offsetPos = originalPos.func_177972_a(facing);
        IBlockState originalState = world.func_180495_p(originalPos);
        IBlockState offsetState = world.func_180495_p(offsetPos);
        EntityPlayer player = event.getEntityPlayer();
        if (offsetState.func_177230_c() == NetherExBlocks.BLOCK_FIRE_BLUE) {
            world.func_180498_a(player, 1009, offsetPos, 0);
            world.func_175698_g(offsetPos);
            event.setCanceled(true);
        }
        if (originalState.func_177230_c() == Blocks.field_150357_h && player.func_184614_ca().func_77973_b() == NetherExItems.TOOL_HAMMER_BONE) {
            BlockUtil.mine3x3(world, player.func_184607_cu(), originalPos, player);
        }
    }

    @SubscribeEvent
    public static void onCropPreGrow(BlockEvent.CropGrowEvent.Pre event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (ConfigHandler.block.soulSand.doesNetherwartUseNewGrowthSystem && state.func_177230_c() == Blocks.field_150388_bm) {
            if (world.func_180495_p(pos.func_177977_b()) == NetherExBlocks.BLOCK_SAND_SOUL_TILLED.func_176223_P().func_177226_a((IProperty)BlockTilledSoulSand.MOISTURE, (Comparable)Integer.valueOf(7))) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (!(event.getPlayer() instanceof FakePlayer)) {
            boolean canSpawn;
            EntityPlayer player = event.getPlayer();
            if (state.func_177230_c() == Blocks.field_189877_df && ConfigHandler.block.magma.turnIntoLava && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0) {
                world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 3);
                player.func_184614_ca().func_77972_a(1, (EntityLivingBase)player);
                event.setCanceled(true);
            }
            if (player.field_71093_bK == DimensionType.NETHER.func_186068_a() && (canSpawn = Arrays.asList(ConfigHandler.entity.nethermite.whitelist).contains(state.func_177230_c().getRegistryName().toString())) && world.field_73012_v.nextInt(ConfigHandler.entity.nethermite.chanceOfSpawning) == 0) {
                EntityNethermite nethermite = new EntityNethermite(world);
                nethermite.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                world.func_72838_d((Entity)nethermite);
            }
        }
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        EntityPlayer player = event.getHarvester();
        if (player != null && state.func_177230_c() == Blocks.field_150357_h && player.func_184614_ca().func_77973_b() == NetherExItems.TOOL_HAMMER_BONE) {
            event.getDrops().add(new ItemStack(Blocks.field_150357_h, 1, 0));
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        EntityPlayer player = event.getPlayer();
        if (state.func_177230_c() == Blocks.field_150357_h && (player.field_71093_bK != DimensionType.NETHER.func_186068_a() || pos.func_177956_o() < 120)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getState();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && (state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k)) {
            event.setResult(ConfigHandler.dimension.nether.isLavaInfinite ? Event.Result.ALLOW : Event.Result.DEFAULT);
        }
    }

    @SubscribeEvent
    public static void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        World world = event.getWorld();
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        EntityLivingBase entity = event.getEntityLiving();
        if (world.func_180494_b(pos) == NetherExBiomes.ARCTIC_ABYSS && EntityUtil.canFreeze(entity)) {
            entity.func_70690_d(new PotionEffect((Potion)NetherExEffects.FREEZE, 300, 0));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        BlockPos newPos;
        World world = event.getEntityLiving().func_130014_f_();
        BlockPos pos = new BlockPos((Entity)event.getEntityLiving());
        EntityLivingBase entity = event.getEntityLiving();
        boolean canEntityFreeze = EntityUtil.canFreeze(entity);
        if (world.func_180494_b(pos) == NetherExBiomes.ARCTIC_ABYSS && canEntityFreeze && !EntityUtil.isFrozen(entity) && world.field_73012_v.nextInt(ConfigHandler.biome.arcticAbyss.chanceOfFreezing) == 0) {
            entity.func_70690_d(new PotionEffect((Potion)NetherExEffects.FREEZE, 300, 0));
        }
        if (canEntityFreeze || entity instanceof EntityPlayer) {
            if (EntityUtil.isFrozen(entity)) {
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).func_94061_f(true);
                }
                entity.func_174810_b(true);
                if (entity instanceof EntityPlayer) {
                    entity.func_70107_b(entity.field_70169_q, entity.field_70163_u, entity.field_70166_s);
                }
                if (world.field_73012_v.nextInt(ConfigHandler.potionEffect.freeze.chanceOfThawing) == 0) {
                    entity.func_184589_d((Potion)NetherExEffects.FREEZE);
                }
            } else {
                if (entity instanceof EntityLiving && ((EntityLiving)entity).func_175446_cd()) {
                    ((EntityLiving)entity).func_94061_f(false);
                }
                entity.func_174810_b(false);
            }
        }
        if (EntityUtil.canSpreadSpores(entity) && EntityUtil.isSporeInfested(entity) && world.field_73012_v.nextInt(ConfigHandler.potionEffect.spore.chanceOfSporeSpawning) == 0 && world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos).func_72321_a(1.0, 1.0, 1.0)).size() < 3) {
            newPos = pos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(world.field_73012_v));
            if (!world.field_72995_K && world.func_175623_d(newPos) && world.func_180495_p(newPos.func_177977_b()).isSideSolid((IBlockAccess)world, newPos.func_177977_b(), EnumFacing.UP)) {
                EntitySpore spore = new EntitySpore(world, 0);
                spore.func_70107_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                world.func_72838_d((Entity)spore);
            }
        }
        if (EntityUtil.canSpawnGhastling(entity) && EntityUtil.isLostAfflicted(entity) && world.field_73012_v.nextInt(ConfigHandler.potionEffect.lost.chanceOfGhastlingSpawning) == 0) {
            newPos = pos.func_177982_a(0, 5, 0).func_177967_a(entity.func_174811_aO().func_176734_d(), 5);
            if (!world.field_72995_K && world.func_175623_d(newPos)) {
                EntityGhastling ghastling = new EntityGhastling(world);
                ghastling.func_70107_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                ghastling.func_70624_b(entity);
                world.func_72838_d((Entity)ghastling);
            }
        }
    }

    @SubscribeEvent
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase attacker = (EntityLivingBase)event.getEntity();
        EntityLivingBase attackee = event.getTarget();
        if (attackee instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attackee;
            if (attacker instanceof AbstractSkeleton && ArmorUtil.isWearingFullArmorSet(player, NetherExMaterials.ARMOR_BONE_WITHERED)) {
                ((AbstractSkeleton)attacker).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        DamageSource source = event.getSource();
        if (source.func_76347_k() && !entity.func_70045_F() && entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityObsidianBoat) {
            event.setCanceled(true);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (source.func_76347_k() && ArmorUtil.isWearingFullArmorSet(player, NetherExMaterials.ARMOR_HIDE_SALAMANDER)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        BlockPos pos = entity.func_180425_c();
        if (entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_70644_a(MobEffects.field_76428_l) && !player.func_70644_a(MobEffects.field_76444_x) && player.func_70644_a((Potion)NetherExEffects.FROSTBITE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Random rand = new Random();
        BlockPos deathPoint = event.getEntity().func_180425_c();
        if (event.getEntity() instanceof EntityGhast) {
            event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)deathPoint.func_177958_n(), (double)deathPoint.func_177956_o(), (double)deathPoint.func_177952_p(), new ItemStack((Item)NetherExItems.FOOD_MEAT_GHAST_RAW, rand.nextInt(3) + 1, 0)));
        } else if (event.getEntity() instanceof EntityWitherSkeleton) {
            ListIterator iter = event.getDrops().listIterator();
            while (iter.hasNext()) {
                EntityItem entityItem = (EntityItem)iter.next();
                ItemStack stack = entityItem.func_92059_d();
                if (stack.func_77973_b() != Items.field_151103_aS && stack.func_77973_b() != Items.field_151044_h) continue;
                iter.remove();
            }
            event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, (double)deathPoint.func_177958_n(), (double)deathPoint.func_177956_o(), (double)deathPoint.func_177952_p(), new ItemStack((Item)NetherExItems.ITEM_BONE_WITHER, rand.nextInt(3), 0)));
        }
    }
}

