/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemapHandler<T extends IForgeRegistryEntry<T>> {
    private static final Map<String, String> customNames = ImmutableMap.builder().build();
    private final List<Predicate<RegistryEvent.MissingMappings.Mapping<T>>> remappingFunctions = ImmutableList.of(this::remapRegistryName);
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|RemapHandler");

    public void remapAll(List<RegistryEvent.MissingMappings.Mapping<T>> missingMappings) {
        LOGGER.info("Fix Missing Mappings started.");
        for (RegistryEvent.MissingMappings.Mapping missingMapping : missingMappings) {
            LOGGER.info("Trying to remap %s", (Object)missingMapping.key);
            boolean remapped = this.remappingFunctions.stream().anyMatch(mappingPredicate -> mappingPredicate.test(missingMapping));
            if (remapped) continue;
            LOGGER.info("Couldn't remap %s", (Object)missingMapping.key);
        }
        LOGGER.info("Fix Missing Mappings completed.");
    }

    private boolean attemptRemap(RegistryEvent.MissingMappings.Mapping<T> missingMapping, ResourceLocation registryName) {
        IForgeRegistry registry = missingMapping.registry;
        IForgeRegistryEntry value = registry.getValue(registryName);
        if (registry.containsKey(registryName) && value != null) {
            LOGGER.info("Remapped %s %s to %s", (Object)registry.getRegistrySuperType().getSimpleName(), (Object)missingMapping.key, (Object)registryName);
            missingMapping.remap(value);
            return true;
        }
        return false;
    }

    private boolean remapRegistryName(RegistryEvent.MissingMappings.Mapping<T> missingMapping) {
        String missingPath = missingMapping.key.func_110623_a();
        if (!customNames.containsKey(missingPath)) {
            return false;
        }
        String newPath = customNames.get(missingPath);
        ResourceLocation newRegistryName = new ResourceLocation(missingMapping.key.func_110624_b(), newPath);
        return this.attemptRemap(missingMapping, newRegistryName);
    }

    @Mod.EventBusSubscriber(modid="nex")
    private static class EventHandler {
        private static final RemapHandler<Block> blockRemapper = new RemapHandler();
        private static final RemapHandler<Item> itemRemapper = new RemapHandler();

        private EventHandler() {
        }

        @SubscribeEvent
        public static void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
            blockRemapper.remapAll((List<RegistryEvent.MissingMappings.Mapping<Block>>)event.getMappings());
        }

        @SubscribeEvent
        public static void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
            itemRemapper.remapAll((List<RegistryEvent.MissingMappings.Mapping<Item>>)event.getMappings());
        }
    }
}

