/*
 * Decompiled with CFR 0.152.
 */
package nex.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import nex.NetherEx;

public class FileUtil {
    public static void extractFromJar(String sourcePath, String destinationPath) {
        URL sourceURL = NetherEx.class.getResource(sourcePath);
        String fromPath = sourcePath.substring(1);
        if (sourceURL != null && sourceURL.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)sourceURL.openConnection();
                JarFile zipFile = jarURLConnection.getJarFile();
                Enumeration<? extends ZipEntry> zipEntries = ((ZipFile)zipFile).entries();
                while (zipEntries.hasMoreElements()) {
                    int count;
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String zipName = zipEntry.getName();
                    if (!zipName.startsWith(fromPath)) continue;
                    String pathTail = zipName.substring(fromPath.length());
                    File file = new File(destinationPath + File.separator + pathTail);
                    if (file.exists()) continue;
                    if (zipEntry.isDirectory()) {
                        file.mkdir();
                        continue;
                    }
                    InputStream inputStream = ((ZipFile)zipFile).getInputStream(zipEntry);
                    BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[4096];
                    while ((count = inputStream.read(buffer)) > 0) {
                        ((OutputStream)outputStream).write(buffer, 0, count);
                    }
                    inputStream.close();
                    ((OutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

