/*
 * Decompiled with CFR 0.152.
 */
package nex.village;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.village.MerchantRecipe;
import nex.init.NetherExLootTables;
import nex.init.NetherExTextures;
import nex.util.RandomUtil;

public class Trade
extends MerchantRecipe {
    private final int outputMinStackSize;
    private final int outputMaxStackSize;
    private final int inputAMinStackSize;
    private final int inputAMaxStackSize;
    private final int inputBMinStackSize;
    private final int inputBMaxStackSize;
    private final int minTradesAvailable;
    private final int maxTradesAvailable;
    private final List<Offer.Enchantment> outputEnchantments;

    public Trade(ItemStack output, int outputMinStackSizeIn, int outputMaxStackSizeIn, ItemStack inputA, int inputAMinStackSizeIn, int inputAMaxStackSizeIn, ItemStack inputB, int inputBMinStackSizeIn, int inputBMaxStackSizeIn, int minTradesAvailableIn, int maxTradesAvailableIn, List<Offer.Enchantment> outputEnchantmentsIn) {
        super(inputA, inputB, output, 0, 1);
        this.outputMinStackSize = outputMinStackSizeIn;
        this.outputMaxStackSize = outputMaxStackSizeIn;
        this.inputAMinStackSize = inputAMinStackSizeIn;
        this.inputAMaxStackSize = inputAMaxStackSizeIn;
        this.inputBMinStackSize = inputBMinStackSizeIn;
        this.inputBMaxStackSize = inputBMaxStackSizeIn;
        this.minTradesAvailable = minTradesAvailableIn;
        this.maxTradesAvailable = maxTradesAvailableIn;
        this.outputEnchantments = outputEnchantmentsIn;
    }

    public MerchantRecipe getRandomTrade(Random rand) {
        ItemStack outputStack = this.func_77397_d().func_77946_l();
        ItemStack inputA = this.func_77394_a().func_77946_l();
        ItemStack inputB = this.func_77396_b().func_77946_l();
        outputStack.func_190920_e(RandomUtil.getNumberInRange(this.outputMinStackSize, this.outputMaxStackSize, rand));
        inputA.func_190920_e(RandomUtil.getNumberInRange(this.inputAMinStackSize, this.inputAMaxStackSize, rand));
        inputB.func_190920_e(RandomUtil.getNumberInRange(this.inputBMinStackSize, this.inputBMaxStackSize, rand));
        if (this.outputEnchantments.size() > 0) {
            for (Offer.Enchantment outputEnchantment : this.outputEnchantments) {
                Enchantment enchantment = Enchantment.func_180305_b((String)outputEnchantment.getEnchantmentId());
                if (enchantment == null) continue;
                if (outputStack.func_77973_b() instanceof ItemEnchantedBook) {
                    ItemEnchantedBook cfr_ignored_0 = (ItemEnchantedBook)outputStack.func_77973_b();
                    ItemEnchantedBook.func_92115_a((ItemStack)outputStack, (EnchantmentData)new EnchantmentData(enchantment, RandomUtil.getNumberInRange(enchantment.func_77319_d(), enchantment.func_77325_b(), rand)));
                    continue;
                }
                outputStack.func_77966_a(enchantment, RandomUtil.getNumberInRange(enchantment.func_77319_d(), enchantment.func_77325_b(), rand));
            }
        }
        return new MerchantRecipe(inputA, inputB, outputStack, 0, RandomUtil.getNumberInRange(this.minTradesAvailable, this.maxTradesAvailable, rand));
    }

    public static class Offer {
        private Output output;
        private Input inputA;
        private Input inputB;
        private int minTradesAvailable;
        private int maxTradesAvailable;
        private int level;

        public Output getOutput() {
            return this.output;
        }

        public Input getInputA() {
            return this.inputA;
        }

        public Input getInputB() {
            return this.inputB;
        }

        public int getMinTradesAvailable() {
            return this.minTradesAvailable;
        }

        public int getMaxTradesAvailable() {
            return this.maxTradesAvailable;
        }

        public int getLevel() {
            return this.level;
        }

        public class Display {
            private String name;
            private List<String> lore;

            public String getName() {
                return this.name;
            }

            public List<String> getLore() {
                return this.lore;
            }
        }

        public class Enchantment {
            private String enchantmentId;
            private int minLevel;
            private int maxLevel;

            public String getEnchantmentId() {
                return this.enchantmentId;
            }

            public int getMinLevel() {
                return this.minLevel;
            }

            public int getMaxLevel() {
                return this.maxLevel;
            }
        }

        public static class Input {
            private String itemId = "minecraft:air";
            private int meta = 0;
            private int minStackSize = 1;
            private int maxStackSize = 1;

            public String getId() {
                return this.itemId;
            }

            public int getMeta() {
                return this.meta;
            }

            public int getMinStackSize() {
                return this.minStackSize;
            }

            public int getMaxStackSize() {
                return this.maxStackSize;
            }
        }

        public class Output {
            private String itemId;
            private int meta;
            private int minStackSize;
            private int maxStackSize;
            private List<Enchantment> enchantments;
            private Display display;

            public String getId() {
                return this.itemId;
            }

            public int getMeta() {
                return this.meta;
            }

            public int getMinStackSize() {
                return this.minStackSize;
            }

            public int getMaxStackSize() {
                return this.maxStackSize;
            }

            public List<Enchantment> getEnchantments() {
                return this.enchantments;
            }

            public Display getDisplay() {
                return this.display;
            }
        }
    }

    public static class Career {
        private String name;
        private List<Offer> trades;

        public String getName() {
            return this.name;
        }

        public List<Offer> getTrades() {
            return this.trades;
        }

        public static enum EnumType {
            CHIEF(Profession.EnumType.LEADER, 16, NetherExTextures.ENTITY_PIGTIFICATE_CHIEF, NetherExLootTables.ENTITY_PIGTIFICATE_CHIEF),
            HUNTER(Profession.EnumType.FORAGER, 5, NetherExTextures.ENTITY_PIGTIFICATE_HUNTER, NetherExLootTables.ENTITY_PIGTIFICATE_HUNTER),
            GATHERER(Profession.EnumType.FORAGER, 5, NetherExTextures.ENTITY_PIGTIFICATE_GATHERER, NetherExLootTables.ENTITY_PIGTIFICATE_GATHERER),
            SCAVENGER(Profession.EnumType.FORAGER, 5, NetherExTextures.ENTITY_PIGTIFICATE_SCAVENGER, NetherExLootTables.ENTITY_PIGTIFICATE_SCAVENGER),
            ARMORSMITH(Profession.EnumType.BLACKSMITH, 8, NetherExTextures.ENTITY_PIGTIFICATE_ARMORSMITH, NetherExLootTables.ENTITY_PIGTIFICATE_ARMORSMITH),
            TOOLSMITH(Profession.EnumType.BLACKSMITH, 8, NetherExTextures.ENTITY_PIGTIFICATE_TOOLSMITH, NetherExLootTables.ENTITY_PIGTIFICATE_TOOLSMITH),
            ENCHANTER(Profession.EnumType.SORCERER, 8, NetherExTextures.ENTITY_PIGTIFICATE_ENCHANTER, NetherExLootTables.ENTITY_PIGTIFICATE_ENCHANTER),
            BREWER(Profession.EnumType.SORCERER, 8, NetherExTextures.ENTITY_PIGTIFICATE_BREWER, NetherExLootTables.ENTITY_PIGTIFICATE_BREWER);

            private Profession.EnumType profession;
            private int weight;
            private ResourceLocation texture;
            private ResourceLocation lootTable;

            private EnumType(Profession.EnumType professionIn, int weightIn, ResourceLocation textureIn, ResourceLocation lootTableIn) {
                this.profession = professionIn;
                this.weight = weightIn;
                this.texture = textureIn;
                this.lootTable = lootTableIn;
            }

            public static EnumType fromIndex(int index) {
                EnumType career = EnumType.values()[index];
                return career != null ? career : HUNTER;
            }

            public static EnumType fromCareer(Career career) {
                return EnumType.valueOf(career.getName().toUpperCase());
            }

            public int getWeight() {
                return this.weight;
            }

            public ResourceLocation getTexture() {
                return this.texture;
            }

            public ResourceLocation getLootTable() {
                return this.lootTable;
            }

            public Profession.EnumType getProfession() {
                return this.profession;
            }
        }

        public static class Weighted
        extends WeightedRandom.Item {
            private EnumType type;

            public Weighted(EnumType typeIn) {
                super(typeIn.getWeight());
                this.type = typeIn;
            }

            public EnumType getType() {
                return this.type;
            }
        }
    }

    public static class Profession {
        private String name;
        private List<Career> careers;

        public String getName() {
            return this.name;
        }

        public List<Career> getCareers() {
            return this.careers;
        }

        public static enum EnumType {
            LEADER,
            FORAGER,
            BLACKSMITH,
            SORCERER;


            public static EnumType getRandom(Random rand, boolean isLeader) {
                if (isLeader) {
                    return LEADER;
                }
                ArrayList types = Lists.newArrayList();
                Collections.addAll(types, EnumType.values());
                types.remove((Object)LEADER);
                return (EnumType)((Object)types.get(rand.nextInt(types.size())));
            }

            public static EnumType fromIndex(int index) {
                EnumType profession = EnumType.values()[index];
                return profession != null ? profession : FORAGER;
            }

            public static EnumType fromProfession(Profession profession) {
                return EnumType.valueOf(profession.getName().toUpperCase());
            }
        }
    }

    public static class TradeList {
        private String name;
        private List<Profession> professions;

        public String getName() {
            return this.name;
        }

        public List<Profession> getProfessions() {
            return this.professions;
        }
    }
}

