/*
 * Decompiled with CFR 0.152.
 */
package nex.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import nex.NetherEx;
import nex.entity.monster.EntitySpore;
import nex.entity.monster.EntitySporeCreeper;
import nex.handler.ConfigHandler;
import nex.init.NetherExEffects;
import nex.init.NetherExParticleTypes;
import nex.init.NetherExSoundEvents;

public class ExplosionSpore
extends Explosion {
    private final World world;
    private final Entity exploder;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final float explosionSize;
    private final boolean isFlaming;
    private final boolean isSmoking;
    private final Random explosionRNG;
    private final List<BlockPos> affectedBlockPositions;
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap;
    private final Vec3d position;

    public ExplosionSpore(World worldIn, Entity entity, double x, double y, double z, float size, boolean flaming, boolean smoking) {
        super(worldIn, entity, x, y, z, size, flaming, smoking);
        this.world = worldIn;
        this.exploder = entity;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.explosionSize = size;
        this.isFlaming = flaming;
        this.isSmoking = smoking;
        this.explosionRNG = new Random(worldIn.func_72905_C());
        this.affectedBlockPositions = Lists.newArrayList();
        this.playerKnockbackMap = Maps.newHashMap();
        this.position = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
    }

    public void func_77278_a() {
        if (!this.world.field_72995_K) {
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    for (int l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.explosionX;
                        double d6 = this.explosionY;
                        double d8 = this.explosionZ;
                        float f1 = 0.3f;
                        for (float f = this.explosionSize * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            IBlockState iblockstate = this.world.func_180495_p(blockpos);
                            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                float f2 = this.exploder != null ? this.exploder.func_180428_a((Explosion)this, this.world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(this.world, blockpos, (Entity)null, (Explosion)this);
                                f -= (f2 + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, this.world, blockpos, iblockstate, f))) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.affectedBlockPositions.addAll(set);
            float f3 = this.explosionSize * 2.0f;
            int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
            int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
            int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
            int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
            int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
            int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
            List list = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
            Vec3d vec3d = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
            for (Entity entity : list) {
                EntityPlayer entityplayer;
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.explosionX) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * d7 + (d9 = entity.field_70161_v - this.explosionZ) * d9))) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d14 = this.world.func_72842_a(vec3d, entity.func_174813_aQ());
                double d10 = (1.0 - d12) * d14;
                if (!(entity instanceof EntitySporeCreeper) && !(entity instanceof EntitySpore)) {
                    entity.func_70097_a(DamageSource.func_94539_a((Explosion)this), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
                }
                if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)NetherExEffects.SPORE, 2400, 0));
                }
                double d11 = d10;
                if (entity instanceof EntityLivingBase) {
                    d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
                }
                entity.field_70159_w += d5 * d11;
                entity.field_70181_x += d7 * d11;
                entity.field_70179_y += d9 * d11;
                if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
                this.playerKnockbackMap.put(entityplayer, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
            }
        }
    }

    public void func_77279_a(boolean spawnParticles) {
        this.world.func_184148_a(null, this.explosionX, this.explosionY, this.explosionZ, NetherExSoundEvents.ENTITY_EXPLODE_SPORE, SoundCategory.HOSTILE, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.explosionSize >= 2.0f && this.isSmoking) {
            NetherEx.proxy.spawnParticle(this.world, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, NetherExParticleTypes.SPORE_EXPLOSION_HUGE);
        } else {
            NetherEx.proxy.spawnParticle(this.world, this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0, NetherExParticleTypes.SPORE_EXPLOSION_LARGE);
        }
        if (!this.world.field_72995_K) {
            if (this.isSmoking) {
                for (BlockPos pos : this.affectedBlockPositions) {
                    IBlockState iblockstate = this.world.func_180495_p(pos);
                    Block block = iblockstate.func_177230_c();
                    if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                    if (block.func_149659_a((Explosion)this)) {
                        block.func_180653_a(this.world, pos, this.world.func_180495_p(pos), 1.0f / this.explosionSize, 0);
                    }
                    block.onBlockExploded(this.world, pos, (Explosion)this);
                }
            }
            if (this.isFlaming) {
                for (BlockPos pos : this.affectedBlockPositions) {
                    if (this.world.func_180495_p(pos).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(pos.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(ConfigHandler.entity.sporeCreeper.chanceOfSporeSpawning) != 0) continue;
                    EntitySpore spore = new EntitySpore(this.world, 0);
                    spore.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                    this.world.func_72838_d((Entity)spore);
                }
            }
        }
    }

    public Map<EntityPlayer, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    public EntityLivingBase func_94613_c() {
        return this.exploder == null ? null : (this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null);
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

