/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import nex.util.BlockUtil;
import nex.world.biome.NetherBiome;
import nex.world.gen.feature.Feature;

public class FeatureFluid
extends Feature {
    private final IBlockState blockToSpawn;
    private final IBlockState targetBlock;
    private final boolean hidden;

    public FeatureFluid(Biome biome, NetherBiome.BiomeFeature feature) {
        super(biome, feature);
        this.blockToSpawn = BlockUtil.getBlock(feature.getBlockToSpawn(), "minecraft:air");
        this.targetBlock = BlockUtil.getBlock(feature.getTargetBlock(), "minecraft:air");
        this.hidden = feature.isHidden();
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random rand) {
        if (world.func_180495_p(pos.func_177984_a()) != this.targetBlock) {
            return false;
        }
        if (!world.func_175623_d(pos) && world.func_180495_p(pos) != this.targetBlock) {
            return false;
        }
        int i = 0;
        if (world.func_180495_p(pos.func_177976_e()) == this.targetBlock) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177974_f()) == this.targetBlock) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177978_c()) == this.targetBlock) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177968_d()) == this.targetBlock) {
            ++i;
        }
        if (world.func_180495_p(pos.func_177977_b()) == this.targetBlock) {
            ++i;
        }
        int j = 0;
        if (world.func_175623_d(pos.func_177976_e())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177974_f())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177978_c())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177968_d())) {
            ++j;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            ++j;
        }
        if (!this.hidden && i == 4 && j == 1 || i == 5) {
            IBlockState state = this.blockToSpawn;
            world.func_180501_a(pos, state, 2);
            world.func_189507_a(pos, state, rand);
        }
        return true;
    }

    @Override
    public boolean canGenerate() {
        return this.blockToSpawn != Blocks.field_150350_a.func_176223_P() && this.targetBlock != Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public Feature.FeatureType getType() {
        return Feature.FeatureType.FLUID;
    }
}

