/*
 * Decompiled with CFR 0.152.
 */
package nex.world.gen.feature;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;
import nex.util.BlockUtil;
import nex.util.WeightedUtil;
import nex.util.WorldGenUtil;
import nex.world.biome.NetherBiome;
import nex.world.gen.feature.Feature;

public class FeatureStructure
extends Feature {
    private final List<StructureType> types = Lists.newArrayList();
    private final List<WeightedUtil.NamedItem> structures = Lists.newArrayList();
    private final List<Block> replacedBlocks = Lists.newArrayList();
    private final List<List<ResourceLocation>> lootTables = Lists.newArrayList();
    private final List<List<ResourceLocation>> spawnerMobs = Lists.newArrayList();
    private final List<Boolean> rotationList = Lists.newArrayList();
    private final List<Boolean> mirrorList = Lists.newArrayList();
    private final int minHeight;
    private final int maxHeight;

    public FeatureStructure(Biome biome, NetherBiome.BiomeFeature feature) {
        super(biome, feature);
        this.minHeight = feature.getMinHeight();
        this.maxHeight = feature.getMaxHeight();
        for (NetherBiome.BiomeStructure structure : feature.getStructureList()) {
            int index = feature.getStructureList().indexOf(structure);
            this.replacedBlocks.add(index, BlockUtil.getBlock(structure.getReplacedBlock(), ""));
            this.structures.add(index, new WeightedUtil.NamedItem(structure.getStructureId(), structure.getWeight()));
            this.types.add(index, StructureType.getFromString(structure.getStructureType()));
            this.lootTables.add(index, Lists.newArrayList());
            this.spawnerMobs.add(index, Lists.newArrayList());
            this.rotationList.add(index, structure.mirror());
            this.mirrorList.add(index, structure.rotate());
            if (structure.getLootTables() != null) {
                for (String lootTable : structure.getLootTables()) {
                    this.lootTables.get(index).add(new ResourceLocation(lootTable));
                }
            }
            if (structure.getSpawnerMobs() != null) {
                for (String spawnerMob : structure.getSpawnerMobs()) {
                    this.spawnerMobs.get(index).add(new ResourceLocation(spawnerMob));
                }
            }
            if (this.lootTables.get(index).size() == 0) {
                this.lootTables.get(index).add(LootTableList.field_186419_a);
            }
            if (this.spawnerMobs.get(index).size() != 0) continue;
            this.spawnerMobs.get(index).add(new ResourceLocation("minecraft:zombie_pigman"));
        }
    }

    @Override
    public boolean generate(World world, BlockPos pos, Random rand) {
        BlockPos spawnPos;
        rand = world.func_175726_f(pos).func_76617_a(world.func_72905_C());
        WeightedUtil.NamedItem structure = WeightedUtil.getRandomNamedItem(rand, this.structures);
        int index = this.structures.indexOf((Object)structure);
        StructureType type = this.types.get(index);
        Mirror[] mirrors = Mirror.values();
        Rotation[] rotations = Rotation.values();
        Mirror mirror = this.mirrorList.get(index) != false ? mirrors[rand.nextInt(mirrors.length)] : Mirror.NONE;
        Rotation rotation = this.rotationList.get(index) != false ? rotations[rand.nextInt(rotations.length)] : Rotation.NONE;
        MinecraftServer minecraftServer = world.func_73046_m();
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(minecraftServer, new ResourceLocation(structure.name));
        PlacementSettings placementSettings = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation).func_186225_a(this.replacedBlocks.get(index)).func_189950_a(rand);
        BlockPos structureSize = Template.func_186266_a((PlacementSettings)placementSettings.func_186217_a(), (BlockPos)template.func_186259_a());
        BlockPos newPos = new BlockPos(pos.func_177958_n() - structureSize.func_177958_n() / 2, this.maxHeight, pos.func_177952_p() - structureSize.func_177952_p() / 2);
        if (type == StructureType.GROUND) {
            spawnPos = WorldGenUtil.getSuitableGroundPos(world, newPos, structureSize, 0.875f);
        } else if (type == StructureType.AIR) {
            spawnPos = WorldGenUtil.getSuitableAirPos(world, newPos, structureSize);
        } else if (type == StructureType.CEILING) {
            spawnPos = WorldGenUtil.getSuitableCeilingPos(world, newPos, structureSize);
        } else if (type == StructureType.WALL) {
            spawnPos = WorldGenUtil.getSuitableWallPos(world, newPos, structureSize, 0.8f);
        } else {
            return false;
        }
        if (!spawnPos.equals((Object)BlockPos.field_177992_a) && spawnPos.func_177956_o() >= this.minHeight && spawnPos.func_177956_o() <= this.maxHeight) {
            WorldGenUtil.generateStructure(world, spawnPos, rand, template, placementSettings.func_186217_a(), this.lootTables.get(index), this.spawnerMobs.get(index));
            return true;
        }
        return false;
    }

    @Override
    public boolean canGenerate() {
        return this.structures.size() > 0;
    }

    @Override
    public Feature.FeatureType getType() {
        return Feature.FeatureType.STRUCTURE;
    }

    public static enum StructureType {
        GROUND,
        AIR,
        CEILING,
        WALL,
        UNKNOWN;


        public static StructureType getFromString(String string) {
            if (!Strings.isNullOrEmpty((String)string)) {
                for (StructureType type : StructureType.values()) {
                    if (!type.name().equalsIgnoreCase(string)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }
    }
}

