/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.entity.model.anim.ExpressionParser;
import net.optifine.entity.model.anim.IExpressionBool;
import net.optifine.entity.model.anim.ParseException;
import shadersmod.client.MacroExpressionResolver;

public class MacroState {
    private boolean active = true;
    private Deque<Boolean> deque = new ArrayDeque<Boolean>();
    private Map<String, String> mapMacroValues = new HashMap<String, String>();
    private static final Pattern PATTERN_DIRECTIVE = Pattern.compile("\\s*#\\s*(\\w+)\\s*(.*)");
    private static final Pattern PATTERN_DEFINED = Pattern.compile("defined\\s+(\\w+)");
    private static final Pattern PATTERN_DEFINED_FUNC = Pattern.compile("defined\\s*\\(\\s*(\\w+)\\s*\\)");
    private static final Pattern PATTERN_MACRO = Pattern.compile("(\\w+)");

    public boolean isLineActive(String line) {
        Matcher m2 = PATTERN_DIRECTIVE.matcher(line);
        if (!m2.matches()) {
            return this.active;
        }
        String name = m2.group(1);
        String param = m2.group(2);
        int posComment = param.indexOf("//");
        if (posComment >= 0) {
            param = param.substring(0, posComment);
        }
        boolean activePrev = this.active;
        this.processMacro(name, param);
        this.active = !this.deque.contains(Boolean.FALSE);
        return this.active || activePrev;
    }

    private void processMacro(String name, String param) {
        String rest;
        StringTokenizer tok = new StringTokenizer(param, " \t");
        String macro = tok.hasMoreTokens() ? tok.nextToken() : "";
        String string = rest = tok.hasMoreTokens() ? tok.nextToken("").trim() : "";
        if (name.equals("define")) {
            this.mapMacroValues.put(macro, rest);
            return;
        }
        if (name.equals("undef")) {
            this.mapMacroValues.remove(macro);
            return;
        }
        if (name.equals("ifdef")) {
            boolean act = this.mapMacroValues.containsKey(macro);
            this.deque.add(act);
            return;
        }
        if (name.equals("ifndef")) {
            boolean act = !this.mapMacroValues.containsKey(macro);
            this.deque.add(act);
            return;
        }
        if (name.equals("if")) {
            boolean act = this.eval(param);
            this.deque.add(act);
            return;
        }
        if (this.deque.isEmpty()) {
            return;
        }
        if (name.equals("else")) {
            boolean last = this.deque.removeLast();
            boolean act = !last;
            this.deque.add(act);
            return;
        }
        if (name.equals("elif")) {
            this.deque.removeLast();
            boolean act = this.eval(param);
            this.deque.add(act);
            return;
        }
        if (name.equals("endif")) {
            this.deque.removeLast();
            return;
        }
    }

    private boolean eval(String str) {
        Matcher md = PATTERN_DEFINED.matcher(str);
        str = md.replaceAll("defined_$1");
        Matcher mdf = PATTERN_DEFINED_FUNC.matcher(str);
        str = mdf.replaceAll("defined_$1");
        boolean replaced = false;
        int count = 0;
        block2: do {
            replaced = false;
            Matcher mmn = PATTERN_MACRO.matcher(str);
            while (mmn.find()) {
                char ch;
                String match = mmn.group();
                if (match.length() <= 0 || !Character.isLetter(ch = match.charAt(0)) && ch != '_' || !this.mapMacroValues.containsKey(match)) continue;
                String val = this.mapMacroValues.get(match);
                if (val == null) {
                    val = "1";
                }
                int start = mmn.start();
                int end = mmn.end();
                str = str.substring(0, start) + " " + val + " " + str.substring(end);
                replaced = true;
                ++count;
                continue block2;
            }
        } while (replaced && count < 100);
        if (count >= 100) {
            Config.warn("Too many iterations: " + count + ", when resolving: " + str);
            return true;
        }
        try {
            MacroExpressionResolver er = new MacroExpressionResolver(this.mapMacroValues);
            ExpressionParser ep = new ExpressionParser(er);
            IExpressionBool expr = ep.parseBool(str);
            boolean ret = expr.eval();
            return ret;
        }
        catch (ParseException e) {
            Config.warn("Invalid macro expression: " + str);
            Config.warn("Error: " + e.getMessage());
            return false;
        }
    }
}

