/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverFluid;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverItem;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;

public class AttachmentRegistry {
    public static final byte FACADE = 0;
    public static final byte SERVO_FLUID = 1;
    public static final byte SERVO_ITEM = 2;
    public static final byte FILTER_FLUID = 3;
    public static final byte FILTER_ITEM = 4;
    public static final byte RETRIEVER_FLUID = 5;
    public static final byte RETRIEVER_ITEM = 6;
    public static final byte RELAY = 7;

    public static Attachment createAttachment(TileGrid tile, byte side, int id) {
        if (id == 0) {
            return new Cover(tile, side);
        }
        if (id == 1) {
            return new ServoFluid(tile, side);
        }
        if (id == 2) {
            return new ServoItem(tile, side);
        }
        if (id == 3) {
            return new FilterFluid(tile, side);
        }
        if (id == 4) {
            return new FilterItem(tile, side);
        }
        if (id == 5) {
            return new RetrieverFluid(tile, side);
        }
        if (id == 6) {
            return new RetrieverItem(tile, side);
        }
        if (id == 7) {
            return new Relay(tile, side);
        }
        throw new RuntimeException("Illegal Attachment ID");
    }
}

