/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.relay;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.api.block.IConfigGui;
import cofh.api.core.IPortableData;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.DuctUnitStructural;
import cofh.thermaldynamics.duct.GridStructural;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.gui.client.GuiRelay;
import cofh.thermaldynamics.gui.container.ContainerRelay;
import cofh.thermaldynamics.init.TDBlocks;
import cofh.thermaldynamics.init.TDItems;
import cofh.thermaldynamics.init.TDTextures;
import cofh.thermaldynamics.render.RenderDuct;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Relay
extends Attachment
implements IConfigGui,
IPortableData {
    public final DuctUnitStructural structureUnit;
    public byte type = 0;
    public int powerLevel;
    public byte color;
    public byte invert = 0;
    public byte threshold = 0;

    public Relay(TileGrid tile, byte side) {
        super(tile, side);
        this.structureUnit = (DuctUnitStructural)tile.getDuct(DuctToken.STRUCTURAL);
    }

    public Relay(TileGrid tile, byte side, int type) {
        super(tile, side);
        this.type = (byte)type;
        this.structureUnit = (DuctUnitStructural)tile.getDuct(DuctToken.STRUCTURAL);
    }

    public static boolean isBlockDuct(Block block) {
        for (BlockDuct blockDuct : TDBlocks.blockDuct) {
            if (block != blockDuct) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "item.thermaldynamics.relay.name";
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public Cuboid6 getCuboid() {
        return TileGrid.subSelection[this.side].copy();
    }

    @Override
    @Nonnull
    public BlockDuct.ConnectionType getNeighborType() {
        return BlockDuct.ConnectionType.DUCT;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[1 + (this.type & 1)][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TDTextures.SIGNALLER)});
        return true;
    }

    @Override
    public ItemStack getPickBlock() {
        return new ItemStack((Item)TDItems.itemRelay);
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList<ItemStack> drops = new LinkedList<ItemStack>();
        drops.add(this.getPickBlock());
        return drops;
    }

    @Override
    public void onNeighborChange() {
        super.onNeighborChange();
        if (this.type == 0 || this.type == 2) {
            int powerLevel = this.getRawRedstoneLevel();
            powerLevel = this.adjustPowerLevel(powerLevel);
            this.setPowerLevel(powerLevel);
        }
    }

    public int adjustPowerLevel(int powerLevel) {
        if (this.shouldThreshold()) {
            int n = powerLevel = powerLevel >= this.threshold ? 15 : 0;
        }
        if (this.shouldInvert()) {
            powerLevel = 15 - powerLevel;
        }
        return powerLevel;
    }

    public boolean shouldThreshold() {
        return (this.invert & 2) != 0;
    }

    public boolean shouldInvert() {
        return (this.invert & 1) == 1;
    }

    public int getRawRedstoneLevel() {
        EnumFacing side = EnumFacing.field_82609_l[this.side];
        BlockPos offsetPos = this.baseTile.func_174877_v().func_177972_a(side);
        int level = 0;
        IBlockState state = this.baseTile.func_145831_w().func_180495_p(offsetPos);
        Block block = state.func_177230_c();
        if (this.type == 0) {
            if (Relay.isBlockDuct(block)) {
                TileGrid t = (TileGrid)this.baseTile.world().func_175625_s(offsetPos);
                Attachment attachment = t.getAttachment(this.side ^ 1);
                if (attachment != null && (!(attachment instanceof Relay) || t.getDuctType() != TDDucts.structure && t.getDuctType() != this.baseTile.getDuctType())) {
                    level = attachment.getRSOutput();
                }
            } else {
                level = Math.max(level, this.baseTile.world().func_175651_c(offsetPos, side));
                if (block == Blocks.field_150488_af) {
                    level = Math.max(level, (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O));
                }
            }
        }
        if (this.type == 2) {
            if (state.func_185912_n()) {
                level = state.func_185888_a(this.baseTile.world(), offsetPos);
            } else if (block.isNormalCube(state, (IBlockAccess)this.baseTile.world(), offsetPos)) {
                EntityItemFrame entityitemframe;
                BlockPos offset2 = offsetPos.func_177972_a(side);
                IBlockState otherState = this.baseTile.func_145831_w().func_180495_p(offset2);
                if (otherState.func_185912_n()) {
                    level = otherState.func_185888_a(this.baseTile.world(), offset2);
                } else if (otherState.func_185904_a() == Material.field_151579_a && (entityitemframe = this.findItemFrame(this.baseTile.world(), side, offset2)) != null) {
                    level = entityitemframe.func_174866_q();
                }
            }
        }
        return level;
    }

    @Nullable
    private EntityItemFrame findItemFrame(World worldIn, EnumFacing facing, BlockPos pos) {
        List list = worldIn.func_175647_a(EntityItemFrame.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), e -> e != null && e.func_174811_aO() == facing);
        return list.size() == 1 ? (EntityItemFrame)list.get(0) : null;
    }

    public boolean isInput() {
        return this.type == 0 || this.type == 2;
    }

    public boolean isOutput() {
        return this.type == 1;
    }

    public int getPowerLevel() {
        if (this.type == 1) {
            return this.adjustPowerLevel(this.powerLevel);
        }
        return this.powerLevel;
    }

    public void setPowerLevel(int powerLevel) {
        if (this.powerLevel != powerLevel) {
            this.powerLevel = powerLevel;
            GridStructural grid = (GridStructural)this.structureUnit.getGrid();
            if (grid != null) {
                grid.signalsUpToDate = false;
            }
            if (this.isOutput()) {
                BlockPos offsetPos = this.baseTile.func_174877_v().func_177972_a(EnumFacing.field_82609_l[this.side]);
                this.baseTile.world().func_190524_a(offsetPos, this.baseTile.func_145838_q(), this.baseTile.func_174877_v());
                for (int i = 0; i < 6; ++i) {
                    if (this.side == (i ^ 1)) continue;
                    offsetPos = this.baseTile.func_174877_v().func_177972_a(EnumFacing.field_82609_l[this.side]);
                    this.baseTile.world().func_190524_a(offsetPos, this.baseTile.func_145838_q(), this.baseTile.func_174877_v());
                }
            }
        }
    }

    @Override
    public int getRSOutput() {
        return this.isOutput() ? this.getPowerLevel() : 0;
    }

    @Override
    public void checkSignal() {
        GridStructural grid = (GridStructural)this.structureUnit.getGrid();
        if (grid == null || grid.rs == null) {
            return;
        }
        this.setPowerLevel(grid.rs.redstoneLevels[this.color]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.CoverTransformer getHollowMask() {
        return CoverHoleRender.hollowDuctTile;
    }

    @Override
    public boolean respondsToSignalum() {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("type", this.type);
        tag.func_74774_a("invert", this.invert);
        tag.func_74774_a("threshold", this.threshold);
        tag.func_74774_a("color", this.color);
        tag.func_74774_a("power", (byte)this.powerLevel);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.type = tag.func_74771_c("type");
        if (tag.func_150297_b("invert", 1)) {
            this.setInvert(tag.func_74771_c("invert"));
        }
        if (tag.func_150297_b("threshold", 1)) {
            this.setThreshold(tag.func_74771_c("threshold"));
        }
        if (tag.func_150297_b("color", 1)) {
            this.setColor(tag.func_74771_c("color"));
        }
        this.powerLevel = tag.func_74771_c("power");
    }

    @Override
    public void addDescriptionToPacket(PacketBase packet) {
        packet.addByte(this.type);
    }

    @Override
    public void getDescriptionFromPacket(PacketBase packet) {
        this.type = packet.getByte();
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isClientWorld((World)this.baseTile.world())) {
            return true;
        }
        PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)player);
        player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.func_174877_v().func_177958_n(), this.baseTile.func_174877_v().func_177956_o(), this.baseTile.func_174877_v().func_177952_p());
        return true;
    }

    @Override
    public boolean shouldRSConnect() {
        return true;
    }

    @Override
    public boolean canAddToTile(TileGrid tile) {
        return !tile.getDuctType().isLargeTube();
    }

    public void setInvert(byte invert) {
        this.invert = invert;
    }

    public void setThreshold(byte threshold) {
        this.threshold = threshold;
    }

    public void setColor(byte color) {
        this.color = color;
    }

    public boolean openConfigGui(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        return true;
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiRelay(this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerRelay(this);
    }

    public void sendUpdatePacket() {
        PacketHandler.sendToServer((PacketBase)this.getPacket());
    }

    public PacketTileInfo getPacket() {
        PacketTileInfo pkt = this.getNewPacket();
        pkt.addByte(this.type);
        pkt.addByte(this.threshold);
        pkt.addByte(this.invert);
        pkt.addByte(this.color);
        return pkt;
    }

    @Override
    public void handleInfoPacket(PacketBase payload, boolean isServer, EntityPlayer player) {
        super.handleInfoPacket(payload, isServer, player);
        byte prevType = this.type;
        byte prevColor = this.color;
        this.type = payload.getByte();
        this.threshold = payload.getByte();
        this.invert = payload.getByte();
        this.color = payload.getByte();
        if (isServer) {
            this.baseTile.world().func_175685_c(this.baseTile.func_174877_v(), this.baseTile.func_145838_q(), false);
            this.onNeighborChange();
            GridStructural grid = (GridStructural)this.structureUnit.getGrid();
            if ((this.type != prevType || this.color != prevColor) && grid != null) {
                grid.resetRelays();
            }
        }
        BlockHelper.callBlockUpdate((World)this.baseTile.func_145831_w(), (BlockPos)this.baseTile.func_174877_v());
    }

    @Override
    public void sendGuiNetworkData(Container container, List<IContainerListener> player, boolean newListener) {
        super.sendGuiNetworkData(container, player, newListener);
        if (newListener) {
            for (IContainerListener p : player) {
                if (!(p instanceof EntityPlayer)) continue;
                PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)((EntityPlayer)p));
            }
        }
    }

    public String getDataType() {
        return "RedstoneRelay";
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        this.readFromNBT(tag);
        this.baseTile.world().func_175685_c(this.baseTile.func_174877_v(), this.baseTile.func_145838_q(), false);
        this.onNeighborChange();
        GridStructural grid = (GridStructural)this.structureUnit.getGrid();
        if (grid != null) {
            grid.resetRelays();
        }
        this.onNeighborChange();
        BlockHelper.callBlockUpdate((World)this.baseTile.func_145831_w(), (BlockPos)this.baseTile.func_174877_v());
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        this.writeToNBT(tag);
    }
}

