/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs.adapters;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;
import openmods.codecs.Log;
import org.jflac.FLACDecoder;
import org.jflac.frame.Frame;
import org.jflac.util.ByteData;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;

public class CodecFLAC
implements ICodec {
    private boolean initialized;
    private boolean streamClosed;
    private ByteData buffer;
    private FLACDecoder decoder;
    private AudioFormat audioFormat;

    public void reverseByteOrder(boolean b) {
    }

    public boolean initialize(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.decoder = new FLACDecoder(conn.getInputStream());
            this.decoder.readStreamInfo();
            this.initialized = true;
            this.audioFormat = new AudioFormat(this.decoder.getStreamInfo().getSampleRate(), this.decoder.getStreamInfo().getBitsPerSample(), this.decoder.getStreamInfo().getChannels(), true, false);
            this.updateBuffer();
            return true;
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to initalize codec for url '%s'", url);
            return false;
        }
    }

    private boolean updateBuffer() throws Exception {
        Frame frame = this.decoder.readNextFrame();
        if (this.decoder.isEOF() || frame == null) {
            this.streamClosed = true;
            return false;
        }
        this.buffer = this.decoder.decodeFrame(frame, null);
        return true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public SoundBuffer read() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        int limit = SoundSystemConfig.getStreamingBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(limit);
        try {
            do {
                output.write(this.buffer.getData(), 0, this.buffer.getLen());
            } while (this.updateBuffer() && !this.streamClosed && output.size() < limit);
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    public SoundBuffer readAll() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            do {
                output.write(this.buffer.getData(), 0, this.buffer.getLen());
            } while (this.updateBuffer() && !this.streamClosed);
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    public boolean endOfStream() {
        return this.streamClosed;
    }

    public void cleanup() {
        this.streamClosed = true;
        this.initialized = false;
        this.decoder = null;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }
}

