/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.api.IProcess;
import p455w0rdslib.client.render.LayerContribDankNull;
import p455w0rdslib.client.render.LayerContributorWings;
import p455w0rdslib.handlers.ProcessHandler;
import p455w0rdslib.handlers.ProcessHandlerClient;
import p455w0rdslib.util.DateUtils;
import p455w0rdslib.util.MCPrivateUtils;

@SideOnly(value=Side.CLIENT)
public class ContributorUtils {
    private static List<String> PATRON_LIST = Lists.newArrayList();
    public static Map<AbstractClientPlayer, LayerContributorWings.Type> REGISTRY = new LinkedHashMap<AbstractClientPlayer, LayerContributorWings.Type>();
    public static List<AbstractClientPlayer> SPECIAL_PLAYERS = Lists.newArrayList();
    public static LayerContributorWings layerWings;
    public static LayerContribDankNull layerDankNull;
    private static DLThread thread;

    public static void queuePlayerCosmetics(final AbstractClientPlayer player) {
        thread = new DLThread();
        thread.setDaemon(true);
        thread.start();
        IProcess process = new IProcess(){

            @Override
            public void updateProcess() {
                if (thread.isFinished()) {
                    thread = null;
                    Minecraft.func_71410_x().func_152344_a(() -> ContributorUtils.addCosmetic(player));
                } else if (thread.isFailed()) {
                    thread = null;
                }
            }

            @Override
            public boolean isDead() {
                return thread == null;
            }
        };
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ProcessHandlerClient.addProcess(process);
        } else {
            ProcessHandler.addProcess(process);
        }
    }

    private static void addCosmetic(AbstractClientPlayer player) {
        if (ContributorUtils.doesPlayerHaveDankNull(player)) {
            ContributorUtils.addDankNull();
        }
        if (ContributorUtils.doesPlayerHaveWings(player)) {
            LayerContributorWings.Type type = ContributorUtils.getWingTypeForPlayer(player);
            ContributorUtils.addWings(type);
            ContributorUtils.registerContributor(player, type);
            LibGlobals.IS_CONTRIBUTOR = true;
        }
        if ((DateUtils.isXmas() || DateUtils.isXmasEve()) && !ContributorUtils.doesPlayerHaveWings(player)) {
            ContributorUtils.addWings(LayerContributorWings.Type.XMAS);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.XMAS);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
    }

    public static void registerContributor(AbstractClientPlayer player, LayerContributorWings.Type type) {
        if (player != null && type != null && !REGISTRY.containsKey(player)) {
            REGISTRY.put(player, type);
            ContributorUtils.registerSpecialContributor(player);
        }
    }

    public static void registerSpecialContributor(AbstractClientPlayer player) {
        if (player != null && ContributorUtils.isPlayerSpecial(player) && !SPECIAL_PLAYERS.contains(player)) {
            SPECIAL_PLAYERS.add(player);
        }
    }

    public static boolean isContributor(AbstractClientPlayer player) {
        return player != null && REGISTRY.containsKey(player);
    }

    public static LayerContributorWings.Type getWingType(AbstractClientPlayer player) {
        if (player != null && REGISTRY.containsKey(player)) {
            return REGISTRY.get(player);
        }
        return null;
    }

    public static LayerContributorWings.Type getWingType(String uuid) {
        for (EntityPlayer entityPlayer : REGISTRY.keySet()) {
            if (!uuid.contains(entityPlayer.func_110124_au().toString())) continue;
            return REGISTRY.get(entityPlayer);
        }
        return null;
    }

    private static void removeVanillaSpecialLayers(List<LayerRenderer<?>> r) {
        for (int i = 0; i < r.size(); ++i) {
            if (!(r.get(i) instanceof LayerElytra) && !(r.get(i) instanceof LayerCape)) continue;
            r.remove(i);
        }
    }

    public static void addWings(LayerContributorWings.Type type) {
        for (RenderLivingBase renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            List<LayerRenderer<?>> r = MCPrivateUtils.getLayerRenderers(renderPlayer);
            ContributorUtils.removeVanillaSpecialLayers(r);
            layerWings = new LayerContributorWings();
            renderPlayer.func_177094_a((LayerRenderer)layerWings);
        }
    }

    public static void addDankNull() {
        for (RenderLivingBase renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            List<LayerRenderer<?>> r = MCPrivateUtils.getLayerRenderers(renderPlayer);
            ContributorUtils.removeVanillaSpecialLayers(r);
            layerDankNull = new LayerContribDankNull();
            renderPlayer.func_177094_a((LayerRenderer)layerDankNull);
        }
    }

    public static boolean doesPlayerHaveWings(AbstractClientPlayer player) {
        if (PATRON_LIST != null) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                for (LayerContributorWings.Type type : LayerContributorWings.Type.values()) {
                    String uuid = player.func_110124_au().toString() + "" + type.getIdentifier();
                    if (!uuid.contains(PATRON_LIST.get(i)) && !ContributorUtils.isPlayerSpecial(uuid, PATRON_LIST.get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesPlayerHaveDankNull(AbstractClientPlayer player) {
        return false;
    }

    public static boolean isPlayerSpecial(AbstractClientPlayer player) {
        if (SPECIAL_PLAYERS.contains(player)) {
            return true;
        }
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            if (!PATRON_LIST.get(i).split("_")[1].contains("#")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerSuperSpecial(AbstractClientPlayer player) {
        if (ContributorUtils.isPlayerSpecial(player)) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).split("_")[1].contains("!")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerSpecial(String uuid, String comparison) {
        return comparison.contains(uuid) && comparison.contains("#");
    }

    public static boolean isPlayerSpecial(String uuid) {
        if (!PATRON_LIST.isEmpty()) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).split("_")[1].contains("#")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPlayerSuperSpecial(String uuid) {
        if (!PATRON_LIST.isEmpty() && ContributorUtils.isPlayerSpecial(uuid)) {
            for (int i = 0; i < PATRON_LIST.size(); ++i) {
                if (!PATRON_LIST.get(i).split("_")[1].contains("!")) continue;
                return true;
            }
        }
        return false;
    }

    public static LayerContributorWings.Type getWingTypeForPlayer(AbstractClientPlayer player) {
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            for (LayerContributorWings.Type type : LayerContributorWings.Type.values()) {
                String uuid = player.func_110124_au().toString() + "" + type.getIdentifier();
                if (!uuid.equals(PATRON_LIST.get(i)) && !ContributorUtils.isPlayerSpecial(uuid, PATRON_LIST.get(i))) continue;
                return type;
            }
        }
        return null;
    }

    public static class DLThread
    extends Thread {
        private boolean finished = false;
        private boolean failed = false;

        public DLThread() {
            super("TheRealp455w0rd Contributors DL Thread");
        }

        @Override
        public void run() {
            super.run();
            try {
                List entries = new ArrayList();
                HttpURLConnection con = (HttpURLConnection)new URL("https://gitlab.com/p455w0rd/patrons/raw/master/patrons.txt").openConnection();
                con.setConnectTimeout(1000);
                InputStream in2 = con.getInputStream();
                entries = IOUtils.readLines((InputStream)in2, (Charset)Charset.defaultCharset());
                if (!entries.isEmpty()) {
                    PATRON_LIST = entries;
                }
                in2.close();
                con.disconnect();
                this.finished = true;
                this.failed = PATRON_LIST.isEmpty();
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

