/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client.render;

import net.blay09.mods.cookingforblockheads.block.BlockFridge;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.client.model.ModelFridgeDoor;
import net.blay09.mods.cookingforblockheads.client.model.ModelFridgeLargeDoor;
import net.blay09.mods.cookingforblockheads.client.render.RenderUtils;
import net.blay09.mods.cookingforblockheads.tile.TileFridge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;

public class FridgeRenderer
extends TileEntitySpecialRenderer<TileFridge> {
    public static IBakedModel modelDoor;
    public static IBakedModel modelDoorLarge;
    public static IBakedModel modelDoorIceUnit;
    public static IBakedModel modelDoorIceUnitLarge;
    public static IBakedModel modelHandle;
    public static IBakedModel modelHandleLarge;
    private final ModelFridgeDoor modelFridgeDoor = new ModelFridgeDoor();
    private final ModelFridgeLargeDoor modelFridgeLargeDoor = new ModelFridgeLargeDoor();
    private final ResourceLocation textureFridgeDoor = new ResourceLocation("cookingforblockheads", "textures/entity/fridge_door.png");
    private final ResourceLocation textureFridgeLargeDoor = new ResourceLocation("cookingforblockheads", "textures/entity/fridge_large_door.png");

    public void render(TileFridge tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        if (state.func_177230_c() != ModBlocks.fridge) {
            return;
        }
        BlockFridge.FridgeType fridgeType = (BlockFridge.FridgeType)((Object)(state = state.func_177230_c().func_176221_a(state, (IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v())).func_177229_b(BlockFridge.TYPE));
        if (fridgeType == BlockFridge.FridgeType.INVISIBLE) {
            return;
        }
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        float blockAngle = RenderUtils.getFacingAngle(state);
        float doorAngle = tileEntity.getDoorAnimator().getRenderAngle(partialTicks);
        boolean isFlipped = (Boolean)state.func_177229_b((IProperty)BlockFridge.FLIPPED);
        boolean isLarge = fridgeType == BlockFridge.FridgeType.LARGE;
        boolean hasIceUnit = (Boolean)state.func_177229_b((IProperty)BlockFridge.ICE_UNIT);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GlStateManager.func_179114_b((float)blockAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        float originX = 0.9375f;
        float originZ = 0.0625f;
        if (isFlipped) {
            originX = 1.0f - originX;
            doorAngle *= -1.0f;
        }
        GlStateManager.func_179109_b((float)originX, (float)0.0f, (float)originZ);
        GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(doorAngle))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-originX), (float)0.0f, (float)(-originZ));
        this.func_147499_a(TextureMap.field_110575_b);
        IBakedModel model = isLarge ? (hasIceUnit ? modelDoorIceUnitLarge : modelDoorLarge) : (hasIceUnit ? modelDoorIceUnit : modelDoor);
        IBakedModel handleModel = isLarge ? modelHandleLarge : modelHandle;
        EnumDyeColor fridgeColor = tileEntity.getFridgeColor();
        int color = fridgeColor.func_193350_e();
        dispatcher.func_175019_b().func_178262_a(model, 1.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        if (isFlipped) {
            GlStateManager.func_179109_b((float)(isLarge ? 0.6875f : 0.625f), (float)0.0f, (float)0.0f);
        }
        dispatcher.func_175019_b().func_178262_a(handleModel, 1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
        if (doorAngle > 0.0f) {
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)RenderUtils.getFacingAngle(state), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
            float topY = fridgeType == BlockFridge.FridgeType.LARGE ? 3.25f : 0.35f;
            IItemHandler itemHandler = tileEntity.getCombinedItemHandler();
            for (int i = itemHandler.getSlots() - 1; i >= 0; --i) {
                float offsetZ;
                float offsetY;
                float offsetX;
                int rowIndex;
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                if (fridgeType == BlockFridge.FridgeType.LARGE) {
                    rowIndex = i % 18;
                    offsetX = 0.7f - (float)(rowIndex % 9) * 0.175f;
                    offsetY = topY - (float)(i / 18) * 1.25f;
                    offsetZ = 0.5f - (float)(rowIndex / 9) * 0.9f;
                } else {
                    rowIndex = i % 13;
                    offsetX = 0.7f;
                    float spacing = 0.175f;
                    if (rowIndex / 9 > 0) {
                        offsetX -= 0.2f;
                        spacing *= 2.0f;
                    }
                    offsetX -= (float)(rowIndex % 9) * spacing;
                    offsetY = topY - (float)(i / 13) * 1.25f;
                    offsetZ = 0.5f - (float)(rowIndex / 9) * 0.9f;
                }
                RenderUtils.renderItem(itemRenderer, itemStack, offsetX, offsetY, offsetZ, 45.0f, 0.0f, 1.0f, 0.0f);
            }
            GlStateManager.func_179121_F();
        }
    }
}

