/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.compat.CompatCapabilityLoader;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;

@Mod.EventBusSubscriber
public class JsonCompatLoader {
    private static final Gson gson = new Gson();
    private static final NonNullList<ItemStack> nonFoodRecipes = NonNullList.func_191196_a();
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final ItemStack[] SINGLE_BUFFER = new ItemStack[1];

    public static boolean loadCompat() {
        nonFoodRecipes.clear();
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get("cookingforblockheads");
        return JsonCompatLoader.findConfigFiles() && CraftingHelper.findFiles((ModContainer)mod, (String)"assets/cookingforblockheads/compat", root -> true, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String fileName = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonCompatLoader.parse(reader);
            }
            catch (JsonParseException e) {
                CookingForBlockheads.logger.error("Parsing error loading compat {}", (Object)fileName, (Object)e);
                return false;
            }
            catch (IOException e) {
                CookingForBlockheads.logger.error("Couldn't read compat {}", (Object)fileName, (Object)e);
                return false;
            }
            return true;
        }, (boolean)true, (boolean)true);
    }

    private static boolean findConfigFiles() {
        File compatDir = new File(CookingForBlockheads.configDir, "CookingForBlockheadsCompat");
        if (!compatDir.exists()) {
            if (!compatDir.mkdirs()) {
                CookingForBlockheads.logger.info("If you wish to setup additional CookingForBlockheads compatibility, create a folder called 'CookingForBlockheadsCompat' in your config directory and place JSON files inside.");
            }
            return true;
        }
        Path path = compatDir.toPath();
        try {
            Files.walk(path, new FileVisitOption[0]).filter(it -> it.toString().endsWith(".json")).forEach(it -> {
                try (BufferedReader reader = Files.newBufferedReader(it);){
                    JsonCompatLoader.parse(reader);
                }
                catch (IOException e) {
                    CookingForBlockheads.logger.error("Couldn't read compat {}", it, (Object)e);
                }
            });
        }
        catch (IOException e) {
            CookingForBlockheads.logger.error("Couldn't walk compat dir", (Throwable)e);
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onCookingRegistry(FoodRegistryInitEvent event) {
        for (ItemStack itemStack : nonFoodRecipes) {
            event.registerNonFoodRecipe(itemStack);
        }
    }

    public static void parse(String json) {
        JsonCompatLoader.parse((JsonObject)gson.fromJson(json, JsonObject.class));
    }

    public static void parse(Reader reader) {
        JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
        if (json != null) {
            JsonCompatLoader.parse(json);
        }
    }

    private static void parse(JsonObject root) {
        String modId = JsonUtils.func_151200_h((JsonObject)root, (String)"modid");
        if (!modId.equals("minecraft") && !Loader.isModLoaded((String)modId)) {
            return;
        }
        JsonObject foods = JsonUtils.func_151218_a((JsonObject)root, (String)"foods", (JsonObject)EMPTY_OBJECT);
        for (Object entry : foods.entrySet()) {
            String category = (String)entry.getKey();
            JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
            for (JsonElement element : array) {
                ItemStack[] results;
                for (ItemStack result : results = JsonCompatLoader.parseItemStacks(modId, element)) {
                    if (result.func_190926_b()) continue;
                    nonFoodRecipes.add((Object)result);
                }
            }
        }
        JsonArray tools = JsonUtils.func_151213_a((JsonObject)root, (String)"tools", (JsonArray)EMPTY_ARRAY);
        for (Object element : tools) {
            ItemStack[] results;
            for (ItemStack result : results = JsonCompatLoader.parseItemStacks(modId, (JsonElement)element)) {
                if (result.func_190926_b()) continue;
                CookingForBlockheadsAPI.addToolItem(result);
            }
        }
        JsonArray water = JsonUtils.func_151213_a((JsonObject)root, (String)"water", (JsonArray)EMPTY_ARRAY);
        for (Object element : water) {
            ItemStack[] results;
            for (ItemStack result : results = JsonCompatLoader.parseItemStacks(modId, (JsonElement)element)) {
                CookingForBlockheadsAPI.addWaterItem(result);
            }
        }
        JsonArray milk = JsonUtils.func_151213_a((JsonObject)root, (String)"milk", (JsonArray)EMPTY_ARRAY);
        for (Object element : milk) {
            ItemStack[] results;
            for (ItemStack result : results = JsonCompatLoader.parseItemStacks(modId, (JsonElement)element)) {
                CookingForBlockheadsAPI.addMilkItem(result);
            }
        }
        JsonArray ovenFuel = JsonUtils.func_151213_a((JsonObject)root, (String)"oven_fuel", (JsonArray)EMPTY_ARRAY);
        for (JsonElement element : ovenFuel) {
            if (!element.isJsonObject()) {
                throw new JsonSyntaxException("Expected array elements to be an object, got " + element);
            }
            JsonObject object = element.getAsJsonObject();
            if (!object.has("item")) {
                throw new JsonSyntaxException("Missing item, expected to find a string, array or object");
            }
            JsonElement item = object.get("item");
            ItemStack[] results = JsonCompatLoader.parseItemStacks(modId, item);
            int fuelTime = JsonUtils.func_151203_m((JsonObject)object, (String)"value");
            for (ItemStack result : results) {
                CookingForBlockheadsAPI.addOvenFuel(result, fuelTime);
            }
        }
        JsonObject ovenRecipes = JsonUtils.func_151218_a((JsonObject)root, (String)"oven_recipes", (JsonObject)EMPTY_OBJECT);
        for (Map.Entry entry : ovenRecipes.entrySet()) {
            ItemStack input = JsonCompatLoader.parseItemStackSimple(modId, (String)entry.getKey());
            ItemStack output = JsonCompatLoader.parseItemStack(modId, (JsonElement)entry.getValue());
            if (input.func_190926_b() || output.func_190926_b()) continue;
            CookingForBlockheadsAPI.addOvenRecipe(input, output);
        }
        JsonObject toaster = JsonUtils.func_151218_a((JsonObject)root, (String)"toaster", (JsonObject)EMPTY_OBJECT);
        for (Map.Entry entry : toaster.entrySet()) {
            ItemStack input = JsonCompatLoader.parseItemStackSimple(modId, (String)entry.getKey());
            ItemStack output = JsonCompatLoader.parseItemStack(modId, (JsonElement)entry.getValue());
            if (input.func_190926_b() || output.func_190926_b()) continue;
            CookingForBlockheadsAPI.addToasterHandler(input, itemStack -> output);
        }
        JsonObject tilesObject = JsonUtils.func_151218_a((JsonObject)root, (String)"tiles", (JsonObject)EMPTY_OBJECT);
        JsonArray tiles = JsonUtils.func_151213_a((JsonObject)tilesObject, (String)"kitchenItemProviders", (JsonArray)EMPTY_ARRAY);
        for (JsonElement element : tiles) {
            if (!element.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected array elements to be a primitive, got " + element);
            }
            CompatCapabilityLoader.addKitchenItemProviderClass(element.getAsString());
        }
        tiles = JsonUtils.func_151213_a((JsonObject)tilesObject, (String)"kitchenConnectors", (JsonArray)EMPTY_ARRAY);
        for (JsonElement element : tiles) {
            if (!element.isJsonPrimitive()) {
                throw new JsonSyntaxException("Expected array elements to be a primitive, got " + element);
            }
            CompatCapabilityLoader.addKitchenConnectorClass(element.getAsString());
        }
    }

    private static ItemStack[] parseItemStacks(String modId, JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonCompatLoader.SINGLE_BUFFER[0] = JsonCompatLoader.parseItemStackSimple(modId, element.getAsString());
            return SINGLE_BUFFER;
        }
        ArrayList itemStackList = Lists.newArrayList();
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement child : array) {
                Collections.addAll(itemStackList, JsonCompatLoader.parseItemStacks(modId, child));
            }
        } else if (element.isJsonObject()) {
            itemStackList.add(JsonCompatLoader.parseItemStack(modId, (JsonElement)element.getAsJsonObject()));
        }
        return itemStackList.toArray(new ItemStack[itemStackList.size()]);
    }

    private static ItemStack parseItemStack(String modId, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            String name = JsonUtils.func_151200_h((JsonObject)object, (String)"item");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modId, name));
            if (item == null || item == Items.field_190931_a) {
                return ItemStack.field_190927_a;
            }
            int count = JsonUtils.func_151208_a((JsonObject)object, (String)"count", (int)1);
            int data = JsonUtils.func_151208_a((JsonObject)object, (String)"data", (int)0);
            return new ItemStack(item, count, data);
        }
        if (element.isJsonPrimitive()) {
            return JsonCompatLoader.parseItemStackSimple(modId, element.getAsString());
        }
        throw new JsonSyntaxException("Excepted object or string, got " + element);
    }

    private static ItemStack parseItemStackSimple(String modId, String name) {
        Item item;
        int colon = name.indexOf(58);
        if (colon != -1) {
            modId = name.substring(0, colon);
            name = name.substring(colon + 1);
        }
        if ((item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(modId, name))) == null || item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item);
    }
}

