/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import mob_grinding_utils.blocks.BlockAbsorptionHopper;
import mob_grinding_utils.blocks.BlockDarkOakStone;
import mob_grinding_utils.blocks.BlockDragonMuffler;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.blocks.BlockTankSink;
import mob_grinding_utils.blocks.BlockWitherMuffler;
import mob_grinding_utils.blocks.BlockXPTap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    private static final List<Block> BLOCKS = new LinkedList<Block>();
    public static final List<ItemBlock> ITEM_BLOCKS = new ArrayList<ItemBlock>();
    public static final Block FAN = new BlockFan();
    public static final ItemBlock FAN_ITEM = new ItemBlock(FAN){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.fan_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.fan_2", new Object[0]).func_150254_d());
        }
    };
    public static final Block SAW = new BlockSaw();
    public static final ItemBlock SAW_ITEM = new ItemBlock(SAW){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.saw_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.saw_2", new Object[0]).func_150254_d());
        }
    };
    public static final Block ABSORPTION_HOPPER = new BlockAbsorptionHopper();
    public static final ItemBlock ABSORPTION_HOPPER_ITEM = new ItemBlock(ABSORPTION_HOPPER){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.hopper_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.hopper_2", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.hopper_3", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.hopper_4", new Object[0]).func_150254_d());
        }
    };
    public static final Block SPIKES = new BlockSpikes();
    public static final ItemBlock SPIKES_ITEM = new ItemBlock(SPIKES){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.spikes_1", new Object[0]).func_150254_d());
        }
    };
    public static final Block TANK = new BlockTank();
    public static final ItemBlock TANK_ITEM = new ItemBlock(TANK){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            FluidStack fluid;
            if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p())) != null) {
                list.add(TextFormatting.GREEN + "Contains: " + fluid.getFluid().getLocalizedName(fluid));
                list.add(TextFormatting.BLUE + "" + fluid.amount + "Mb/32000Mb");
            }
        }
    };
    public static final Block TANK_SINK = new BlockTankSink();
    public static final ItemBlock TANK_SINK_ITEM = new ItemBlock(TANK_SINK){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            FluidStack fluid;
            if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p())) != null) {
                list.add(TextFormatting.GREEN + "Contains: " + fluid.getFluid().getLocalizedName(fluid));
                list.add(TextFormatting.BLUE + "" + fluid.amount + "Mb/32000Mb");
            }
        }
    };
    public static final Block XP_TAP = new BlockXPTap();
    public static final ItemBlock XP_TAP_ITEM = new ItemBlock(XP_TAP){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.xptap_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.xptap_2", new Object[0]).func_150254_d());
        }
    };
    public static final Block WITHER_MUFFLER = new BlockWitherMuffler();
    public static final ItemBlock WITHER_MUFFLER_ITEM = new ItemBlock(WITHER_MUFFLER){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.withermuffler_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.withermuffler_2", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.withermuffler_3", new Object[0]).func_150254_d());
        }
    };
    public static final Block DRAGON_MUFFLER = new BlockDragonMuffler();
    public static final ItemBlock DRAGON_MUFFLER_ITEM = new ItemBlock(DRAGON_MUFFLER){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.dragonmuffler_1", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.dragonmuffler_2", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.dragonmuffler_3", new Object[0]).func_150254_d());
        }
    };
    public static final Block DARK_OAK_STONE = new BlockDarkOakStone();
    public static final ItemBlock DARK_OAK_STONE_ITEM = new ItemBlock(DARK_OAK_STONE){

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.darkoakstone", new Object[0]).func_150254_d());
        }
    };

    public static void init() {
        try {
            for (Field field : ModBlocks.class.getDeclaredFields()) {
                String name;
                Object obj = field.get(null);
                if (obj instanceof Block) {
                    Block block = (Block)obj;
                    name = field.getName().toLowerCase(Locale.ENGLISH);
                    ModBlocks.registerBlock(name, block);
                }
                if (!(obj instanceof ItemBlock)) continue;
                ItemBlock blockItem = (ItemBlock)obj;
                name = field.getName().toLowerCase(Locale.ENGLISH);
                ModBlocks.registerItemBlock(name, blockItem);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        ((Block)block.setRegistryName("mob_grinding_utils", name)).func_149663_c("mob_grinding_utils." + name);
    }

    public static void registerItemBlock(String name, ItemBlock item) {
        String[] newName = name.split("_item");
        ITEM_BLOCKS.add(item);
        ((Item)item.setRegistryName("mob_grinding_utils", newName[0])).func_77655_b("mob_grinding_utils." + newName[0]);
    }

    @Mod.EventBusSubscriber(modid="mob_grinding_utils")
    public static class RegistrationHandlerBlocks {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.init();
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                registry.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : ITEM_BLOCKS) {
                registry.register((IForgeRegistryEntry)item);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            for (ItemBlock item : ITEM_BLOCKS) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().toString(), "inventory"));
            }
        }
    }
}

