/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAbsorptionHopper
extends BlockContainer {
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> NORTH = PropertyEnum.func_177709_a((String)"north", TileEntityAbsorptionHopper.EnumStatus.class);
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> SOUTH = PropertyEnum.func_177709_a((String)"south", TileEntityAbsorptionHopper.EnumStatus.class);
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> WEST = PropertyEnum.func_177709_a((String)"west", TileEntityAbsorptionHopper.EnumStatus.class);
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> EAST = PropertyEnum.func_177709_a((String)"east", TileEntityAbsorptionHopper.EnumStatus.class);
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> UP = PropertyEnum.func_177709_a((String)"up", TileEntityAbsorptionHopper.EnumStatus.class);
    public static final PropertyEnum<TileEntityAbsorptionHopper.EnumStatus> DOWN = PropertyEnum.func_177709_a((String)"down", TileEntityAbsorptionHopper.EnumStatus.class);
    protected static final AxisAlignedBB HOPPER_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);

    public BlockAbsorptionHopper() {
        super(Material.field_151573_f);
        this.func_149711_c(10.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(MobGrindingUtils.TAB);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAbsorptionHopper();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return HOPPER_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean whatIsThis) {
        BlockAbsorptionHopper.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HOPPER_AABB);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (world.field_72995_K) {
            return true;
        }
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityAbsorptionHopper) {
            TileEntityAbsorptionHopper vacuum = (TileEntityAbsorptionHopper)tile;
            if (!player.func_70093_af()) {
                world.func_184138_a(pos, state, state, 3);
                player.openGui((Object)MobGrindingUtils.INSTANCE, MobGrindingUtils.PROXY.GUI_ID_ABSORPTION_HOPPER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                vacuum.toggleMode(side);
            }
            world.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityAbsorptionHopper) {
            TileEntityAbsorptionHopper tile = (TileEntityAbsorptionHopper)tileEntity;
            TileEntityAbsorptionHopper.EnumStatus north = tile.getSideStatus(EnumFacing.NORTH);
            TileEntityAbsorptionHopper.EnumStatus south = tile.getSideStatus(EnumFacing.SOUTH);
            TileEntityAbsorptionHopper.EnumStatus west = tile.getSideStatus(EnumFacing.WEST);
            TileEntityAbsorptionHopper.EnumStatus east = tile.getSideStatus(EnumFacing.EAST);
            TileEntityAbsorptionHopper.EnumStatus up = tile.getSideStatus(EnumFacing.UP);
            TileEntityAbsorptionHopper.EnumStatus down = tile.getSideStatus(EnumFacing.DOWN);
            return state.func_177226_a(NORTH, (Comparable)((Object)north)).func_177226_a(SOUTH, (Comparable)((Object)south)).func_177226_a(WEST, (Comparable)((Object)west)).func_177226_a(EAST, (Comparable)((Object)east)).func_177226_a(UP, (Comparable)((Object)up)).func_177226_a(DOWN, (Comparable)((Object)down));
        }
        return state.func_177226_a(NORTH, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE)).func_177226_a(SOUTH, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE)).func_177226_a(WEST, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE)).func_177226_a(EAST, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE)).func_177226_a(UP, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE)).func_177226_a(DOWN, (Comparable)((Object)TileEntityAbsorptionHopper.EnumStatus.STATUS_NONE));
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityAbsorptionHopper tile;
        if (!world.field_72995_K && (tile = (TileEntityAbsorptionHopper)world.func_175625_s(pos)) != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            world.func_175713_t(pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(MobGrindingUtils.FLUID_XP.getStill());
        event.getMap().func_174942_a(MobGrindingUtils.FLUID_XP.getFlowing());
    }
}

