/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.lang.reflect.Method;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSpikes
extends BlockDirectional {
    public static final AxisAlignedBB SPIKES_AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);
    public static final Method xpPoints = BlockSpikes.getExperiencePoints();

    public BlockSpikes() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(MobGrindingUtils.TAB);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return SPIKES_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (!worldIn.field_72995_K && entity instanceof EntityLivingBase) {
            entity.func_70097_a(MobGrindingUtils.SPIKE_DAMAGE, 5.0f);
        }
    }

    @SubscribeEvent
    public void dropXP(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (entity != null && !world.field_72995_K && !event.isRecentlyHit() && event.getSource() == MobGrindingUtils.SPIKE_DAMAGE) {
            int xp = 0;
            try {
                xp = (Integer)xpPoints.invoke((Object)entity, FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (xp > 0) {
                int cap = EntityXPOrb.func_70527_a((int)xp);
                xp -= cap;
                entity.func_130014_f_().func_72838_d((Entity)new EntityXPOrb(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, cap));
            }
        }
    }

    public static Method getExperiencePoints() {
        Method method = null;
        try {
            method = EntityLiving.class.getDeclaredMethod("getExperiencePoints", EntityPlayer.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = EntityLiving.class.getDeclaredMethod("func_70693_a", EntityPlayer.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }
}

