/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.recipe.RecipeChickenFeed;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRecipes {
    public static final List<IRecipe> RECIPES = new ArrayList<IRecipe>();
    public static final IRecipe CHICKEN_FEED = new RecipeChickenFeed();
    public static final IRecipe ABSORPTION_HOPPER = new ShapedOreRecipe(ModRecipes.getResource("recipe_absorption_hopper"), new ItemStack((Item)ModBlocks.ABSORPTION_HOPPER_ITEM), new Object[]{" E ", " O ", "OHO", Character.valueOf('E'), new ItemStack(Items.field_151061_bv), Character.valueOf('O'), "obsidian", Character.valueOf('H'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150438_bZ))});
    public static final IRecipe ABSORPTION_UPGRADE = new ShapedOreRecipe(ModRecipes.getResource("recipe_absorption_upgrade"), new ItemStack(ModItems.ABSORPTION_UPGRADE), new Object[]{" E ", "ERE", "OEO", Character.valueOf('E'), "enderpearl", Character.valueOf('O'), "obsidian", Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SPIKES = new ShapedOreRecipe(ModRecipes.getResource("recipe_spikes"), new ItemStack((Item)ModBlocks.SPIKES_ITEM), new Object[]{"   ", " S ", "SIS", Character.valueOf('S'), new ItemStack(Items.field_151040_l), Character.valueOf('I'), "blockIron"});
    public static final IRecipe TANK = new ShapedOreRecipe(ModRecipes.getResource("recipe_tank"), new ItemStack((Item)ModBlocks.TANK_ITEM), new Object[]{"IGI", "GGG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "blockGlass"});
    public static final IRecipe TANK_SINK = new ShapedOreRecipe(ModRecipes.getResource("recipe_tank_sink"), new ItemStack((Item)ModBlocks.TANK_SINK_ITEM), new Object[]{" I ", "EHE", " T ", Character.valueOf('I'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('H'), new ItemStack(Item.func_150898_a((Block)Blocks.field_150438_bZ)), Character.valueOf('T'), new ItemStack((Item)ModBlocks.TANK_ITEM), Character.valueOf('E'), new ItemStack(Items.field_151061_bv)});
    public static final IRecipe XP_TAP = new ShapedOreRecipe(ModRecipes.getResource("recipe_xp_tap"), new ItemStack((Item)ModBlocks.XP_TAP_ITEM), new Object[]{"O  ", "II ", "I  ", Character.valueOf('O'), "obsidian", Character.valueOf('I'), "ingotIron"});
    public static final IRecipe FAN = new ShapedOreRecipe(ModRecipes.getResource("recipe_fan"), new ItemStack((Item)ModBlocks.FAN_ITEM), new Object[]{"SIS", "IRI", "SIS", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U), Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "blockRedstone"});
    public static final IRecipe FAN_UPGRADE_1 = new ShapedOreRecipe(ModRecipes.getResource("recipe_fan_uprade_1"), new ItemStack(ModItems.FAN_UPGRADE, 1, 0), new Object[]{"I I", "FFF", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), "feather"});
    public static final IRecipe FAN_UPGRADE_2 = new ShapedOreRecipe(ModRecipes.getResource("recipe_fan_uprade_2"), new ItemStack(ModItems.FAN_UPGRADE, 1, 1), new Object[]{"IFI", " F ", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), "feather"});
    public static final IRecipe FAN_UPGRADE_3 = new ShapedOreRecipe(ModRecipes.getResource("recipe_fan_uprade_3"), new ItemStack(ModItems.FAN_UPGRADE, 1, 2), new Object[]{"FIF", "IRI", "FIF", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), "feather", Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe MOB_SWAB = new ShapedOreRecipe(ModRecipes.getResource("recipe_mob_swab"), new ItemStack(ModItems.MOB_SWAB), new Object[]{"  W", " S ", "W  ", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('S'), "stickWood"});
    public static final IRecipe WITHER_MUFFLER = new ShapedOreRecipe(ModRecipes.getResource("recipe_wither_muffler"), new ItemStack((Item)ModBlocks.WITHER_MUFFLER_ITEM), new Object[]{"WWW", "WSW", "WWW", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('S'), new ItemStack(Items.field_151144_bL, 1, 1)});
    public static final IRecipe DRAGON_MUFFLER = new ShapedOreRecipe(ModRecipes.getResource("recipe_dragon_muffler"), new ItemStack((Item)ModBlocks.DRAGON_MUFFLER_ITEM), new Object[]{"WWW", "WEW", "WWW", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L), Character.valueOf('E'), new ItemStack(Blocks.field_150380_bt)});
    public static final IRecipe SAW = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw"), new ItemStack((Item)ModBlocks.SAW_ITEM), new Object[]{"SDS", "VRV", "DID", Character.valueOf('S'), new ItemStack(Items.field_151040_l), Character.valueOf('D'), "gemDiamond", Character.valueOf('V'), new ItemStack((Item)ModBlocks.SPIKES_ITEM), Character.valueOf('R'), "blockRedstone", Character.valueOf('I'), "blockIron"});
    public static final IRecipe SAW_UPGRADE_1 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_1"), new ItemStack(ModItems.SAW_UPGRADE, 1, 0), new Object[]{"GSG", "SRS", "GSG", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), new ItemStack(Items.field_151040_l), Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SAW_UPGRADE_2 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_2"), new ItemStack(ModItems.SAW_UPGRADE, 1, 1), new Object[]{"GLG", "LRL", "GLG", Character.valueOf('G'), "nuggetGold", Character.valueOf('L'), "dyeBlue", Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SAW_UPGRADE_3 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_3"), new ItemStack(ModItems.SAW_UPGRADE, 1, 2), new Object[]{"GFG", "FRF", "GFG", Character.valueOf('G'), "nuggetGold", Character.valueOf('F'), new ItemStack(Items.field_151033_d), Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SAW_UPGRADE_4 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_4"), new ItemStack(ModItems.SAW_UPGRADE, 1, 3), new Object[]{"GFG", "FRF", "GFG", Character.valueOf('G'), "nuggetGold", Character.valueOf('F'), new ItemStack(Items.field_151078_bh), Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SAW_UPGRADE_5 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_5"), new ItemStack(ModItems.SAW_UPGRADE, 1, 4), new Object[]{"GSG", "SRS", "GSG", Character.valueOf('G'), "nuggetGold", Character.valueOf('S'), new ItemStack(Items.field_151070_bp), Character.valueOf('R'), "dustRedstone"});
    public static final IRecipe SAW_UPGRADE_6 = new ShapedOreRecipe(ModRecipes.getResource("recipe_saw_upgrade_6"), new ItemStack(ModItems.SAW_UPGRADE, 1, 5), new Object[]{"GHG", "IRI", "GHG", Character.valueOf('G'), "nuggetGold", Character.valueOf('H'), new ItemStack((Item)Items.field_151169_ag), Character.valueOf('I'), new ItemStack((Item)Items.field_151028_Y), Character.valueOf('R'), "dustRedstone"});

    private static ResourceLocation getResource(String inName) {
        return new ResourceLocation("mob_grinding_utils", inName);
    }

    public static void init() {
        try {
            for (Field field : ModRecipes.class.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof IRecipe)) continue;
                IRecipe recipe = (IRecipe)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                ModRecipes.registerRecipe(name, recipe);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerRecipe(String inName, IRecipe recipe) {
        RECIPES.add(recipe);
        recipe.setRegistryName(ModRecipes.getResource(inName));
    }

    @Mod.EventBusSubscriber(modid="mob_grinding_utils")
    public static class RegistrationHandlerRecipes {
        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            ModRecipes.init();
            IForgeRegistry registry = event.getRegistry();
            for (IRecipe recipes : RECIPES) {
                registry.register((IForgeRegistryEntry)recipes);
            }
        }
    }
}

