/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Iterator;
import java.util.List;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.network.TapParticleMessage;
import mob_grinding_utils.tile.FluidTankTile;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntitySinkTank
extends TileEntityTank
implements ITickable {
    public TileEntitySinkTank() {
        this.tank = new FluidTankTile(null, 32000);
        this.tank.setTileEntity(this);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && (this.tank.getFluid() == null || this.tank.getFluid().containsFluid(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 0)))) {
            this.captureDroppedXP();
        }
    }

    public boolean captureDroppedXP() {
        Iterator<EntityPlayer> iterator = this.getCaptureXP(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5).iterator();
        if (iterator.hasNext()) {
            EntityPlayer player = iterator.next();
            int xpAmount = TileEntitySinkTank.getPlayerXP(player);
            if (xpAmount <= 0) {
                return false;
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
                this.tank.fill(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 20), true);
                TileEntitySinkTank.addPlayerXP(player, -1);
                this.func_145831_w().func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 0.1f, 0.5f * ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.8f));
                MobGrindingUtils.NETWORK_WRAPPER.sendToAll((IMessage)new TapParticleMessage(this.func_174877_v().func_177984_a()));
            }
            return true;
        }
        return false;
    }

    public List<EntityPlayer> getCaptureXP(World world, double x, double y, double z) {
        return world.func_175647_a(EntityPlayer.class, new AxisAlignedBB(x - 0.45, y - 0.5, z - 0.45, x + 0.45, y + 1.03, z + 0.45), EntitySelectors.field_94557_a);
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = TileEntitySinkTank.getPlayerXP(player) + amount;
        player.field_71068_ca = TileEntitySinkTank.getLevelForExperience(experience);
        int expForLevel = TileEntitySinkTank.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)TileEntitySinkTank.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (TileEntitySinkTank.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }
}

