/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.patches;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import pl.asie.charset.patches.CharsetPatchwork;
import pl.asie.charset.patches.logic.LaserRedstoneLogic;
import pl.asie.charset.patches.logic.LockHookLogic;

public class CharsetPatchTransformer
implements IClassTransformer {
    private static Map<String, String> superclassMap = new HashMap<String, String>();
    private static Multimap<String, String> interfaceMap = HashMultimap.create();

    public static void addClass(String currC) {
        if (!superclassMap.containsKey(currC)) {
            String filename = FMLDeobfuscatingRemapper.INSTANCE.unmap(currC);
            filename = filename.replace('.', '/') + ".class";
            InputStream stream = CharsetPatchTransformer.class.getClassLoader().getResourceAsStream(filename);
            if (stream != null) {
                try {
                    ClassReader reader = new ClassReader(stream);
                    String newC = reader.getSuperName();
                    if (newC != null) {
                        newC = newC.replace('/', '.');
                    }
                    superclassMap.put(currC, newC);
                    for (String s : reader.getInterfaces()) {
                        interfaceMap.put((Object)currC, (Object)s.replace('/', '.'));
                    }
                }
                catch (IOException e) {
                    superclassMap.put(currC, null);
                }
            } else {
                superclassMap.put(currC, null);
            }
        }
    }

    public static boolean isImplements(String c, String sc) {
        String currC = c;
        while (currC != null && currC.length() > 0) {
            if (currC.equals(sc)) {
                return true;
            }
            CharsetPatchTransformer.addClass(currC);
            for (String s : interfaceMap.get((Object)currC)) {
                if (!CharsetPatchTransformer.isImplements(s, sc)) continue;
                return true;
            }
            currC = superclassMap.get(currC);
        }
        return false;
    }

    public static boolean isExtends(String c, String sc) {
        String currC = c;
        while (currC != null && currC.length() > 0) {
            if (currC.equals(sc)) {
                return true;
            }
            CharsetPatchTransformer.addClass(currC);
            currC = superclassMap.get(currC);
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Object target;
        boolean applyLockHook;
        if (basicClass == null) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        boolean requiresClassNode = applyLockHook = CharsetPatchwork.LOCKS_BLOCK_CAPABILITIES && CharsetPatchTransformer.isExtends(transformedName, "net.minecraft.tileentity.TileEntity");
        ClassNode node = new ClassNode();
        ClassWriter writer = new ClassWriter(0);
        Object object = target = requiresClassNode ? node : writer;
        if (CharsetPatchwork.LASER_REDSTONE) {
            target = new LaserRedstoneLogic.MyClassVisitor(327680, (ClassVisitor)target);
        }
        if (target == writer) {
            return basicClass;
        }
        reader.accept((ClassVisitor)target, 0);
        if (applyLockHook) {
            LockHookLogic.patch(node, "tile", "net.minecraft.tileentity.TileEntity".equals(transformedName));
        }
        if (requiresClassNode) {
            node.accept((ClassVisitor)writer);
        }
        return writer.toByteArray();
    }
}

