/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.patches.logic;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.charset.patches.CharsetPatchTransformer;

public final class LockHookLogic {
    private static final Map<String, byte[]> byteCache = new HashMap<String, byte[]>();
    private static ClassNode node;
    private static Map<String, MethodNode> nodeMethods;

    private LockHookLogic() {
    }

    private static ClassNode load(String c) {
        node = new ClassNode();
        if (!byteCache.containsKey(c)) {
            InputStream stream = LockHookLogic.class.getClassLoader().getResourceAsStream(c);
            try {
                byteCache.put(c, ByteStreams.toByteArray((InputStream)stream));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ClassReader reader = new ClassReader(byteCache.get(c));
        reader.accept((ClassVisitor)node, 2);
        return node;
    }

    private static void initialize() {
        node = LockHookLogic.load("pl/asie/charset/patches/LockHooks.class");
        nodeMethods = new HashMap<String, MethodNode>();
        for (MethodNode methodNode : LockHookLogic.node.methods) {
            nodeMethods.put(methodNode.name + methodNode.desc, methodNode);
        }
    }

    public static MethodNode inject(@Nullable MethodNode method, MethodNode srcMethod, ClassNode target, String srcClassName, String baseClassName) {
        String suffix = "_postCharset";
        System.out.println("Injecting " + srcMethod.name + " hook into " + target.name);
        if (method != null) {
            method.name = method.name + suffix;
            for (AbstractInsnNode node : method.instructions) {
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                if (!methodInsnNode.name.equals(srcMethod.name) || !methodInsnNode.desc.equals(srcMethod.desc) || !CharsetPatchTransformer.isExtends(methodInsnNode.owner.replace('/', '.'), baseClassName.replace('/', '.'))) continue;
                methodInsnNode.name = methodInsnNode.name + suffix;
            }
        }
        MethodNode newMethod = new MethodNode(srcMethod.access, srcMethod.name, srcMethod.desc, srcMethod.signature, new String[0]);
        newMethod.maxLocals = srcMethod.maxLocals;
        newMethod.maxStack = srcMethod.maxStack;
        newMethod.visibleAnnotations = srcMethod.visibleAnnotations;
        newMethod.visibleParameterAnnotations = srcMethod.visibleParameterAnnotations;
        newMethod.visibleTypeAnnotations = srcMethod.visibleTypeAnnotations;
        newMethod.visibleLocalVariableAnnotations = srcMethod.visibleLocalVariableAnnotations;
        newMethod.invisibleAnnotations = srcMethod.visibleAnnotations;
        newMethod.invisibleParameterAnnotations = srcMethod.visibleParameterAnnotations;
        newMethod.invisibleTypeAnnotations = srcMethod.visibleTypeAnnotations;
        newMethod.invisibleLocalVariableAnnotations = srcMethod.visibleLocalVariableAnnotations;
        for (AbstractInsnNode node : srcMethod.instructions) {
            if (node instanceof FieldInsnNode) {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)node;
                if ("pl/asie/charset/patches/LockHooks".equals(fieldInsnNode.owner)) {
                    node = new FieldInsnNode(fieldInsnNode.getOpcode(), baseClassName, fieldInsnNode.name, fieldInsnNode.desc);
                }
            } else if (node instanceof MethodInsnNode) {
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                if (srcClassName.equals(methodInsnNode.owner)) {
                    int opc = methodInsnNode.getOpcode();
                    node = new MethodInsnNode(opc == 182 && methodInsnNode.name.endsWith("_postCharset") ? 183 : opc, target.name, methodInsnNode.name, methodInsnNode.desc, methodInsnNode.itf);
                }
            } else if (node instanceof FrameNode) {
                Object o;
                int i;
                Object[] newLocal;
                FrameNode frameNode1 = (FrameNode)node;
                Object[] newStack = newLocal = new Object[0];
                if (frameNode1.local != null) {
                    newLocal = new Object[frameNode1.local.size()];
                    for (i = 0; i < newLocal.length; ++i) {
                        o = frameNode1.local.get(i);
                        if (o != null && o.equals(srcClassName)) {
                            o = target.name;
                        }
                        newLocal[i] = o;
                    }
                }
                if (frameNode1.stack != null) {
                    newStack = new Object[frameNode1.stack.size()];
                    for (i = 0; i < newStack.length; ++i) {
                        o = frameNode1.stack.get(i);
                        if (o != null && o.equals(srcClassName)) {
                            o = target.name;
                        }
                        newStack[i] = o;
                    }
                }
                node = new FrameNode(frameNode1.type, newLocal.length, newLocal, newStack.length, newStack);
            }
            newMethod.instructions.add(node);
        }
        return newMethod;
    }

    public static void patch(ClassNode target, String type, boolean isBase) {
        LockHookLogic.initialize();
        String baseClassName = "net/minecraft/tileentity/TileEntity";
        if (CharsetPatchTransformer.isImplements(target.name.replace('/', '.'), "net.minecraft.inventory.IInventory") && !CharsetPatchTransformer.isImplements(target.name.replace('/', '.'), "net.minecraft.inventory.ISidedInventory")) {
            ClassNode invNode = LockHookLogic.load("pl/asie/charset/patches/DummySidedInventory.class");
            for (MethodNode method : invNode.methods) {
                if (method.name.contains("<") || method.name.contains("$")) continue;
                target.methods.add(LockHookLogic.inject(null, method, target, "pl/asie/charset/patches/DummySidedInventory", baseClassName));
            }
            target.interfaces.add("net/minecraft/inventory/ISidedInventory");
            System.out.println("Adding dummy ISidedInventory to " + target.name);
        }
        ArrayList<MethodNode> newMethods = new ArrayList<MethodNode>();
        for (MethodNode method : target.methods) {
            MethodNode srcMethod = nodeMethods.get(method.name + method.desc);
            if (srcMethod == null || method.name.contains("<") || method.name.contains("$")) continue;
            boolean hasHook = false;
            if (srcMethod.visibleAnnotations != null) {
                for (AnnotationNode node : srcMethod.visibleAnnotations) {
                    if (!"Lpl/asie/charset/patches/Hook;".equals(node.desc)) continue;
                    hasHook = true;
                    break;
                }
            }
            if (!hasHook) continue;
            newMethods.add(LockHookLogic.inject(method, srcMethod, target, "pl/asie/charset/patches/LockHooks", baseClassName));
        }
        target.methods.addAll(newMethods);
    }
}

