/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.apparatus;

import cofh.api.tileentity.IInventoryConnection;
import cofh.core.block.TileTEBase;
import cofh.core.util.RegistrySocial;
import cofh.core.util.helpers.SecurityHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.apparatus.BlockApparatus;
import cofh.thermalexpansion.block.apparatus.TileApparatusBase;
import cofh.thermalexpansion.gui.client.apparatus.GuiCollector;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCollector
extends TileApparatusBase
implements IInventoryConnection,
ITickable {
    private static final int TYPE = BlockApparatus.Type.COLLECTOR.getMetadata();
    public static final float[] DEFAULT_DROP_CHANCES = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private boolean ignoreTeam = true;
    private boolean ignoreFriends = true;
    private boolean ignoreOwner = true;
    protected boolean augmentEntityCollection;

    public static void initialize() {
        TileCollector.SIDE_CONFIGS[TileCollector.TYPE] = new TileTEBase.SideConfig();
        TileCollector.SIDE_CONFIGS[TileCollector.TYPE].numConfig = 2;
        TileCollector.SIDE_CONFIGS[TileCollector.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileCollector.SIDE_CONFIGS[TileCollector.TYPE].sideTypes = new int[]{0, 4};
        TileCollector.SIDE_CONFIGS[TileCollector.TYPE].defaultSides = new byte[]{0, 0, 0, 0, 0, 0};
        TileCollector.SLOT_CONFIGS[TileCollector.TYPE] = new TileTEBase.SlotConfig();
        TileCollector.SLOT_CONFIGS[TileCollector.TYPE].allowInsertionSlot = new boolean[0];
        TileCollector.SLOT_CONFIGS[TileCollector.TYPE].allowExtractionSlot = new boolean[0];
        GameRegistry.registerTileEntity(TileCollector.class, (String)"thermalexpansion:apparatus_collector");
    }

    public static void config() {
        String category = "Apparatus.Collector";
        BlockApparatus.enable[TileCollector.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileCollector() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.radius = 1;
        this.depth = 1;
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected void activate() {
        this.collectItemsInArea();
    }

    private void collectItemsInArea() {
        AxisAlignedBB area;
        switch (this.facing) {
            case 0: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -1 - this.depth, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 0, 1 + this.radius));
                break;
            }
            case 1: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, 1, -this.radius), this.field_174879_c.func_177982_a(1 + this.radius, 2 + this.depth, 1 + this.radius));
                break;
            }
            case 2: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -this.radius, -1 - this.depth), this.field_174879_c.func_177982_a(1 + this.radius, 1 + this.radius, 0));
                break;
            }
            case 3: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.radius, -this.radius, 1), this.field_174879_c.func_177982_a(1 + this.radius, 1 + this.radius, 2 + this.depth));
                break;
            }
            case 4: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(-1 - this.depth, -this.radius, -this.radius), this.field_174879_c.func_177982_a(0, 1 + this.radius, 1 + this.radius));
                break;
            }
            default: {
                area = new AxisAlignedBB(this.field_174879_c.func_177982_a(1, -this.radius, -this.radius), this.field_174879_c.func_177982_a(2 + this.depth, 1 + this.radius, 1 + this.radius));
            }
        }
        List entityItems = this.field_145850_b.func_72872_a(EntityItem.class, area);
        for (EntityItem entityItem : entityItems) {
            if (entityItem.field_70128_L || entityItem.func_92059_d().func_190916_E() <= 0) continue;
            this.stuffedItems.add(entityItem.func_92059_d());
            entityItem.field_70170_p.func_72900_e((Entity)entityItem);
        }
        if (this.augmentEntityCollection) {
            List entityLiving = this.field_145850_b.func_72872_a(EntityLivingBase.class, area);
            for (EntityLivingBase entity : entityLiving) {
                float[] dropChances = DEFAULT_DROP_CHANCES;
                if (entity instanceof EntityLiving) {
                    EntityLiving living = (EntityLiving)entity;
                    dropChances = new float[]{living.field_82174_bp[0], living.field_82174_bp[1], living.field_184655_bs[0], living.field_184655_bs[1], living.field_184655_bs[2], living.field_184655_bs[3]};
                } else if (this.isSecured() && entity instanceof EntityPlayer && this.doNotCollectItemsFrom((EntityPlayer)entity)) continue;
                for (int i = 0; i < 6; ++i) {
                    EntityEquipmentSlot slot = EntityEquipmentSlot.values()[i];
                    ItemStack equipmentInSlot = entity.func_184582_a(slot);
                    if (equipmentInSlot.func_190926_b() || !(dropChances[i] >= 1.0f)) continue;
                    this.stuffedItems.add(equipmentInSlot);
                    entity.func_184201_a(slot, ItemStack.field_190927_a);
                }
            }
        }
    }

    private boolean doNotCollectItemsFrom(EntityPlayer player) {
        UUID otherID;
        String name = player.func_70005_c_();
        UUID ownerID = this.owner.getId();
        if (ownerID.equals(otherID = SecurityHelper.getID((EntityPlayer)player))) {
            return this.ignoreOwner;
        }
        return this.ignoreFriends && RegistrySocial.playerHasAccess((String)name, (GameProfile)this.owner);
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCollector(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        return super.func_189515_b(nbt);
    }

    @Override
    public IInventoryConnection.ConnectionType canConnectInventory(EnumFacing from) {
        if (from != null && from.ordinal() != this.facing && this.sideCache[from.ordinal()] == 1) {
            return IInventoryConnection.ConnectionType.FORCE;
        }
        return IInventoryConnection.ConnectionType.DEFAULT;
    }
}

