/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.block.TileTEBase;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiWaterGen;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.init.TETextures;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileWaterGen
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.WATER_GEN.getMetadata();
    private static final int TIME_CONSTANT = 40;
    private static int genRate = 4000;
    private static int genRatePassive = 80;
    private static boolean infiniteSource = false;
    private static boolean passiveGen = false;
    private int adjacentSources = -1;
    private int outputTracker;
    private boolean inNether;
    private FluidTankCore tank = new FluidTankCore(8000);
    private int offset = MathHelper.RANDOM.nextInt(40);

    public static void initialize() {
        TileWaterGen.SIDE_CONFIGS[TileWaterGen.TYPE] = new TileTEBase.SideConfig();
        TileWaterGen.SIDE_CONFIGS[TileWaterGen.TYPE].numConfig = 2;
        TileWaterGen.SIDE_CONFIGS[TileWaterGen.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileWaterGen.SIDE_CONFIGS[TileWaterGen.TYPE].sideTypes = new int[]{0, 4};
        TileWaterGen.SIDE_CONFIGS[TileWaterGen.TYPE].defaultSides = new byte[]{0, 1, 0, 0, 0, 0};
        TileWaterGen.SLOT_CONFIGS[TileWaterGen.TYPE] = new TileTEBase.SlotConfig();
        TileWaterGen.SLOT_CONFIGS[TileWaterGen.TYPE].allowInsertionSlot = new boolean[0];
        TileWaterGen.SLOT_CONFIGS[TileWaterGen.TYPE].allowExtractionSlot = new boolean[0];
        GameRegistry.registerTileEntity(TileWaterGen.class, (String)"thermalexpansion:device_water_gen");
        TileWaterGen.config();
    }

    public static void config() {
        String category = "Device.WaterGen";
        BlockDevice.enable[TileWaterGen.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "If TRUE, the Aqueous Accumulator will act as an Infinite Source and will also function in the Nether.";
        infiniteSource = ThermalExpansion.CONFIG.get(category, "Infinite", infiniteSource, comment);
        comment = "If TRUE, the Aqueous Accumulator will produce water very slowly even without adjacent source blocks.";
        passiveGen = ThermalExpansion.CONFIG.get(category, "PassiveGeneration", passiveGen, comment);
    }

    public TileWaterGen() {
        this.tank.setLock(FluidRegistry.WATER);
        if (infiniteSource) {
            this.tank.modifyFluidStored(this.tank.getCapacity());
        }
        this.hasAutoOutput = true;
        this.enableAutoOutput = true;
    }

    public int getType() {
        return TYPE;
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateValidity();
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (!infiniteSource) {
                if (this.adjacentSources >= 2) {
                    this.tank.modifyFluidStored(genRate * (this.adjacentSources - 1));
                } else if (this.field_145850_b.func_72896_J() && this.field_145850_b.func_175678_i(this.func_174877_v())) {
                    this.tank.modifyFluidStored(genRate);
                } else if (passiveGen) {
                    this.tank.modifyFluidStored(genRatePassive);
                }
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable() && !this.inNether) {
            this.isActive = true;
        }
        if (this.adjacentSources < 0) {
            this.updateValidity();
        }
        this.transferOutput();
        this.updateIfChanged(curActive);
    }

    protected void updateValidity() {
        this.inNether = BiomeDictionary.hasType((Biome)this.field_145850_b.func_180494_b(this.field_174879_c), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && !infiniteSource;
        this.adjacentSources = 0;
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()))) {
            ++this.adjacentSources;
        }
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()))) {
            ++this.adjacentSources;
        }
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()))) {
            ++this.adjacentSources;
        }
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f()))) {
            ++this.adjacentSources;
        }
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()))) {
            ++this.adjacentSources;
        }
        if (TileWaterGen.isWater(this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d()))) {
            ++this.adjacentSources;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut() || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), this.tank.getFluidAmount());
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, !infiniteSource);
            this.outputTracker = side;
            break;
        }
    }

    protected static boolean isWater(IBlockState state) {
        return (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % 40L == 0L;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiWaterGen(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTEBase(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inNether = nbt.func_74767_n("Hell");
        this.adjacentSources = nbt.func_74762_e("Sources");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        if (infiniteSource) {
            this.tank.modifyFluidStored(this.tank.getCapacity());
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Hell", this.inNether);
        nbt.func_74768_a("Sources", this.adjacentSources);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((Fluid)FluidRegistry.WATER) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return new FluidStack(FluidRegistry.WATER, 1);
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? FluidRegistry.WATER.getColor() << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.deviceWaterGen : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileWaterGen.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileWaterGen.this.allowExtraction(((TileWaterGen)TileWaterGen.this).sideConfig.sideTypes[TileWaterGen.this.sideCache[from.ordinal()]])) {
                        return infiniteSource ? resource : TileWaterGen.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileWaterGen.this.allowExtraction(((TileWaterGen)TileWaterGen.this).sideConfig.sideTypes[TileWaterGen.this.sideCache[from.ordinal()]])) {
                        return infiniteSource ? new FluidStack(TileWaterGen.this.tank.getFluid(), maxDrain) : TileWaterGen.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

