/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.block.TileTEBase;
import cofh.core.fluid.FluidTankCore;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCrafter;
import cofh.thermalexpansion.gui.container.machine.ContainerCrafter;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCrafter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CRAFTER.getMetadata();
    public static int basePower = 20;
    public static final int DEFAULT_ENERGY = 400;
    public static final int SLOT_OUTPUT = 18;
    public static final int SLOT_CRAFTING_START = 20;
    private int inputTracker;
    private int outputTracker;
    private InventoryCraftingFalse craftMatrix = new InventoryCraftingFalse(3, 3);
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private CrafterRecipe craftRecipe;
    private boolean hasRecipeChanges;
    private FluidTankCore tank = new FluidTankCore(10000);
    protected boolean augmentInput;
    protected boolean augmentTank;
    protected boolean flagTank;
    protected boolean usingTank;

    public static void initialize() {
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SideConfig();
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].numConfig = 5;
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {18}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCrafter.ALT_SIDE_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SideConfig();
        TileCrafter.ALT_SIDE_CONFIGS[TileCrafter.TYPE].numConfig = 2;
        TileCrafter.ALT_SIDE_CONFIGS[TileCrafter.TYPE].slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17}, {18}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18}};
        TileCrafter.ALT_SIDE_CONFIGS[TileCrafter.TYPE].sideTypes = new int[]{0, 7};
        TileCrafter.ALT_SIDE_CONFIGS[TileCrafter.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SlotConfig();
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowInsertionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false};
        TileCrafter.VALID_AUGMENTS[TileCrafter.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineCrafterInput");
        VALID_AUGMENTS[TYPE].add("machineCrafterTank");
        TileCrafter.LIGHT_VALUES[TileCrafter.TYPE] = 7;
        GameRegistry.registerTileEntity(TileCrafter.class, (String)"thermalexpansion:machine_crafter");
        TileCrafter.config();
    }

    public static void config() {
        String category = "Machine.Crafter";
        BlockMachine.enable[TileCrafter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Sequential Fabricator. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileCrafter.ENERGY_CONFIGS[TileCrafter.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileCrafter() {
        this.inventory = new ItemStack[30];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length - 9 - 1);
    }

    public int getType() {
        return TYPE;
    }

    public int getChargeSlot() {
        return this.inventory.length - 1 - 9 - 1;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.craftResult.func_193055_i() == null || this.hasRecipeChanges) {
            return false;
        }
        if (!this.checkIngredients()) {
            return false;
        }
        ItemStack output = this.craftResult.func_70301_a(0);
        return this.inventory[18].func_190926_b() || this.inventory[18].func_77969_a(output) && this.inventory[18].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = 400;
    }

    @Override
    protected void processFinish() {
        IRecipe recipe = this.craftResult.func_193055_i();
        if (recipe == null || !this.checkIngredients()) {
            this.processOff();
            return;
        }
        this.craftRecipe.evaluate();
        ItemStack output = recipe.func_77572_b((InventoryCrafting)this.craftMatrix);
        NonNullList remainingItems = recipe.func_179532_b((InventoryCrafting)this.craftMatrix);
        block0: for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack remaining = (ItemStack)remainingItems.get(i);
            if (remaining.func_190926_b() || this.craftRecipe.isFalseBucket(i)) continue;
            for (int j = 0; j < 18; ++j) {
                if (this.inventory[j].func_190926_b()) {
                    this.inventory[j] = remaining;
                    continue block0;
                }
                if (remaining.func_77976_d() <= 1 || !ItemHelper.itemsIdentical((ItemStack)this.inventory[j], (ItemStack)remaining) || this.inventory[j].func_190916_E() >= this.inventory[j].func_77976_d()) continue;
                this.inventory[j].func_190917_f(1);
                continue block0;
            }
        }
        if (this.inventory[18].func_190926_b()) {
            this.inventory[18] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[18].func_190917_f(output.func_190916_E());
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 0; j < 9; ++j) {
                if (!this.inventory[j + 20].func_190926_b() && !this.extractItem(j, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) {
                    this.extractItem(j + 9, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side]);
                }
                this.inputTracker = side;
            }
            return;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[18].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(18, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    public void setRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.craftMatrix.func_70299_a(i, this.inventory[i + 20]);
        }
        IRecipe newRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.craftMatrix, (World)this.field_145850_b);
        ItemStack stack = ItemStack.field_190927_a;
        if (newRecipe != null) {
            stack = newRecipe.func_77572_b((InventoryCrafting)this.craftMatrix);
            this.craftRecipe = CrafterRecipe.getRecipe(newRecipe, this);
            if (this.craftRecipe == null) {
                newRecipe = null;
                stack = ItemStack.field_190927_a;
                this.usingTank = false;
            }
        } else {
            this.craftRecipe = null;
            this.usingTank = false;
        }
        if (this.craftRecipe == null && this.isActive) {
            this.processOff();
        }
        this.inventory[29] = stack;
        this.craftResult.func_193056_a(newRecipe);
        this.craftResult.func_70299_a(0, this.inventory[29]);
        this.clearRecipeChanges();
    }

    private boolean checkIngredients() {
        return this.craftRecipe != null && this.craftRecipe.checkIngredients();
    }

    private ItemStack getTankAsBucket() {
        if (this.augmentTank && this.tank.getFluidAmount() >= 1000) {
            return FluidUtil.getFilledBucket((FluidStack)this.tank.getFluid());
        }
        return ItemStack.field_190927_a;
    }

    public int getInvSlotCount() {
        return this.inventory.length - 9 - 1;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentTank() {
        return this.augmentTank && this.flagTank;
    }

    public boolean fluidArrow() {
        return this.augmentTank() && this.usingTank;
    }

    public void markRecipeChanges() {
        this.hasRecipeChanges = true;
        if (this.isActive) {
            this.processOff();
        }
    }

    public void clearRecipeChanges() {
        this.hasRecipeChanges = false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        this.setRecipe();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        for (int i = 20; i < 29; ++i) {
            payload.addItemStack(this.inventory[i]);
        }
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        for (int i = 20; i < 29; ++i) {
            this.inventory[i] = payload.getItemStack();
        }
        this.setRecipe();
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentInput);
        payload.addBool(this.augmentTank);
        payload.addBool(this.usingTank);
        payload.addFluidStack(this.getTankFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentInput = payload.getBool();
        this.flagTank = this.augmentTank = payload.getBool();
        this.usingTank = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentInput = false;
        this.augmentTank = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentTank) {
            this.tank.drain(this.tank.getCapacity(), true);
            if (this.usingTank) {
                this.processOff();
            }
            this.usingTank = false;
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentInput && "machineCrafterInput".equals(id)) {
            this.augmentInput = true;
            return true;
        }
        if (!this.augmentTank && "machineCrafterTank".equals(id)) {
            this.augmentTank = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int func_70302_i_() {
        return this.inventory.length - 9 - 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.augmentInput) {
            return true;
        }
        return slot >= 18 || this.craftRecipe == null || this.craftRecipe.validStack(stack, slot % 9);
    }

    public boolean hasTransferIn() {
        return this.augmentInput && this.hasAutoInput;
    }

    public boolean getTransferIn() {
        return this.hasTransferIn() && this.enableAutoInput && !this.hasRecipeChanges;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentTank && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentTank && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCrafter.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileCrafter.this.allowInsertion(((TileCrafter)TileCrafter.this).sideConfig.sideTypes[TileCrafter.this.sideCache[from.ordinal()]])) {
                        return TileCrafter.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileCrafter.this.isActive) {
                        return null;
                    }
                    if (from == null || TileCrafter.this.allowExtraction(((TileCrafter)TileCrafter.this).sideConfig.sideTypes[TileCrafter.this.sideCache[from.ordinal()]])) {
                        return TileCrafter.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileCrafter.this.isActive) {
                        return null;
                    }
                    if (from == null || TileCrafter.this.allowExtraction(((TileCrafter)TileCrafter.this).sideConfig.sideTypes[TileCrafter.this.sideCache[from.ordinal()]])) {
                        return TileCrafter.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }

    public static class CrafterRecipe {
        private TileCrafter myTile;
        private boolean valid = true;
        private int[] craftSlots = new int[9];
        private Ingredient[] craftIngredients;
        private boolean isItemStackRecipe = false;
        private ItemStack[] craftStacks = new ItemStack[9];

        public static CrafterRecipe getRecipe(IRecipe recipe, TileCrafter tile) {
            CrafterRecipe wrapper = new CrafterRecipe(recipe, tile);
            return wrapper.valid ? wrapper : null;
        }

        public static boolean validRecipe(IRecipe recipe) {
            return recipe.func_192400_c().size() > 0 || recipe instanceof RecipeTippedArrow;
        }

        private CrafterRecipe(IRecipe recipe, TileCrafter tile) {
            this.myTile = tile;
            NonNullList ingredients = recipe.func_192400_c();
            this.craftIngredients = new Ingredient[9];
            if (recipe instanceof IShapedRecipe) {
                int j = 0;
                for (int i = 0; i < 9; ++i) {
                    if (this.myTile.inventory[20 + i].func_190926_b()) {
                        this.craftIngredients[i] = Ingredient.field_193370_a;
                        if (ingredients.size() <= j || !((Ingredient)ingredients.get(j)).equals(Ingredient.field_193370_a)) continue;
                        ++j;
                        continue;
                    }
                    this.craftIngredients[i] = (Ingredient)ingredients.get(j);
                    ++j;
                }
            } else if (ingredients.size() > 0) {
                int i;
                ItemStack[] sortedRecipe = new ItemStack[9];
                for (i = 0; i < ingredients.size(); ++i) {
                    for (int j = 20; j < 29; ++j) {
                        if (!((Ingredient)ingredients.get(i)).apply(this.myTile.inventory[j])) continue;
                        this.craftIngredients[i] = (Ingredient)ingredients.get(i);
                        sortedRecipe[i] = this.myTile.inventory[j].func_77946_l();
                    }
                }
                for (i = ingredients.size(); i < 9; ++i) {
                    this.craftIngredients[i] = Ingredient.field_193370_a;
                    sortedRecipe[i] = ItemStack.field_190927_a;
                }
                System.arraycopy(sortedRecipe, 0, this.myTile.inventory, 20, 9);
            } else if (recipe instanceof RecipeTippedArrow) {
                this.isItemStackRecipe = true;
                for (int i = 0; i < 9; ++i) {
                    this.craftStacks[i] = this.myTile.inventory[20 + i].func_190926_b() ? ItemStack.field_190927_a : ItemHelper.cloneStack((ItemStack)this.myTile.inventory[20 + i], (int)1);
                }
            } else {
                this.craftIngredients = null;
                this.craftStacks = null;
                this.valid = false;
            }
        }

        private void evaluate() {
            this.myTile.craftMatrix = new InventoryCraftingFalse(3, 3);
            for (int i = 0; i < 9; ++i) {
                if (this.craftSlots[i] > 0) {
                    this.myTile.craftMatrix.func_70299_a(i, ItemHelper.cloneStack((ItemStack)this.myTile.inventory[this.craftSlots[i] - 1], (int)1));
                    this.myTile.inventory[this.craftSlots[i] - 1].func_190918_g(1);
                    if (this.myTile.inventory[this.craftSlots[i] - 1].func_190916_E() > 0) continue;
                    this.myTile.inventory[this.craftSlots[i] - 1] = ItemStack.field_190927_a;
                    continue;
                }
                if (this.craftSlots[i] < 0) {
                    this.myTile.craftMatrix.func_70299_a(i, ItemHelper.cloneStack((ItemStack)this.myTile.getTankAsBucket(), (int)1));
                    this.myTile.tank.drain(1000, true);
                    continue;
                }
                this.myTile.craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
            }
        }

        private boolean checkIngredients() {
            this.craftSlots = new int[9];
            int[] craftCount = new int[18];
            this.myTile.usingTank = false;
            ItemStack tankStack = this.myTile.getTankAsBucket();
            int tankCount = 0;
            if (this.isItemStackRecipe) {
                block0: for (int i = 0; i < 9; ++i) {
                    if (this.craftStacks[i].equals(ItemStack.field_190927_a)) continue;
                    for (int j = 0; j < 18; ++j) {
                        if (!ItemHelper.itemsIdentical((ItemStack)this.craftStacks[i], (ItemStack)this.myTile.inventory[j]) || this.myTile.inventory[j].func_190916_E() - craftCount[j] <= 0) continue;
                        int n = j;
                        craftCount[n] = craftCount[n] + 1;
                        this.craftSlots[i] = j + 1;
                        continue block0;
                    }
                    return false;
                }
            } else {
                block2: for (int i = 0; i < 9; ++i) {
                    if (this.craftIngredients[i].equals(Ingredient.field_193370_a)) continue;
                    if (!tankStack.func_190926_b() && this.craftIngredients[i].apply(tankStack) && this.myTile.tank.getFluidAmount() - tankCount > 0) {
                        tankCount += 1000;
                        this.craftSlots[i] = -1;
                        this.myTile.usingTank = true;
                        continue;
                    }
                    for (int j = 0; j < 18; ++j) {
                        if (!this.craftIngredients[i].apply(this.myTile.inventory[j]) || this.myTile.inventory[j].func_190916_E() - craftCount[j] <= 0) continue;
                        int n = j;
                        craftCount[n] = craftCount[n] + 1;
                        this.craftSlots[i] = j + 1;
                        continue block2;
                    }
                    return false;
                }
            }
            return true;
        }

        private boolean isFalseBucket(int slot) {
            return this.craftSlots[slot] == -1;
        }

        private boolean validStack(ItemStack stack, int slot) {
            if (this.isItemStackRecipe) {
                return ItemHelper.itemsIdentical((ItemStack)stack, (ItemStack)this.craftStacks[slot]);
            }
            return this.craftIngredients[slot].apply(stack);
        }
    }
}

