/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.block.TileTEBase;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCrucible;
import cofh.thermalexpansion.gui.container.machine.ContainerCrucible;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrucible
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CRUCIBLE.getMetadata();
    public static int basePower = 50;
    public static final int LAVA_MULTIPLIER = 10;
    public static final int LAVA_ENERGY_MOD = 0;
    private CrucibleManager.CrucibleRecipe curRecipe;
    private int inputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(10000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 0);
    protected boolean augmentLava;

    public static void initialize() {
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE] = new TileTEBase.SideConfig();
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].numConfig = 5;
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileCrucible.SIDE_CONFIGS[TileCrucible.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCrucible.ALT_SIDE_CONFIGS[TileCrucible.TYPE] = new TileTEBase.SideConfig();
        TileCrucible.ALT_SIDE_CONFIGS[TileCrucible.TYPE].numConfig = 2;
        TileCrucible.ALT_SIDE_CONFIGS[TileCrucible.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileCrucible.ALT_SIDE_CONFIGS[TileCrucible.TYPE].sideTypes = new int[]{0, 7};
        TileCrucible.ALT_SIDE_CONFIGS[TileCrucible.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE] = new TileTEBase.SlotConfig();
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE].allowInsertionSlot = new boolean[]{true, false};
        TileCrucible.SLOT_CONFIGS[TileCrucible.TYPE].allowExtractionSlot = new boolean[]{false, false};
        TileCrucible.VALID_AUGMENTS[TileCrucible.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineCrucibleLava");
        TileCrucible.LIGHT_VALUES[TileCrucible.TYPE] = 14;
        GameRegistry.registerTileEntity(TileCrucible.class, (String)"thermalexpansion:machine_crucible");
        TileCrucible.config();
    }

    public static void config() {
        String category = "Machine.Crucible";
        BlockMachine.enable[TileCrucible.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Magma Crucible. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileCrucible.ENERGY_CONFIGS[TileCrucible.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileCrucible() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? this.renderFluid.getFluid().getLuminosity(this.renderFluid) : 0;
    }

    @Override
    protected int calcEnergy() {
        if (this.augmentLava) {
            return Math.min(super.calcEnergy() * 10, this.energyStorage.getEnergyStored());
        }
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0 || this.tank.getSpace() <= 0) {
            return false;
        }
        if (this.augmentLava && !CrucibleManager.isLava(this.inventory[0])) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        FluidStack output = this.curRecipe.getOutput();
        return this.tank.fill(output, false) == output.amount;
    }

    @Override
    protected boolean hasValidInput() {
        if (this.augmentLava && !CrucibleManager.isLava(this.inventory[0])) {
            return false;
        }
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = CrucibleManager.getRecipe(this.inventory[0]);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
        FluidStack prevStack = this.renderFluid.copy();
        this.renderFluid = this.curRecipe.getOutput().copy();
        this.renderFluid.amount = 0;
        if (!FluidHelper.isFluidEqual((FluidStack)prevStack, (FluidStack)this.renderFluid)) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        this.tank.fill(this.curRecipe.getOutput(), true);
        this.inventory[0].func_190918_g(1);
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        this.transferOutputFluid();
    }

    private void transferOutputFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.timeCheckEighth()) {
            this.transferOutput();
        }
        super.func_73660_a();
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrucible(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrucible(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentLava() {
        return this.augmentLava;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        this.getRecipe();
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid().copy();
        } else if (this.curRecipe != null) {
            this.renderFluid = this.curRecipe.getOutput().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getFluidPacket() {
        PacketBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    protected void handleFluidPacket(PacketBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentLava = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentLava) {
            this.energyStorage.setMaxTransfer(this.energyConfig.maxPower * 4 * 10);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentLava && "machineCrucibleLava".equals(id)) {
            this.augmentLava = true;
            this.hasModeAugment = true;
            this.energyMod += 0;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.augmentLava ? this.energyConfig.maxPower * 10 : this.energyConfig.maxPower;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || (this.augmentLava ? CrucibleManager.isLava(stack) : CrucibleManager.recipeExists(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? this.renderFluid.getFluid().getColor(this.renderFluid) << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.machineCrucible : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCrucible.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileCrucible.this.allowExtraction(((TileCrucible)TileCrucible.this).sideConfig.sideTypes[TileCrucible.this.sideCache[from.ordinal()]])) {
                        return TileCrucible.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileCrucible.this.allowExtraction(((TileCrucible)TileCrucible.this).sideConfig.sideTypes[TileCrucible.this.sideCache[from.ordinal()]])) {
                        return TileCrucible.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

