/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.block.TileTEBase;
import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ICustomInventory;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiPrecipitator;
import cofh.thermalexpansion.gui.container.machine.ContainerPrecipitator;
import cofh.thermalexpansion.util.managers.machine.PrecipitatorManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TilePrecipitator
extends TileMachineBase
implements ICustomInventory {
    private static final int TYPE = BlockMachine.Type.PRECIPITATOR.getMetadata();
    public static int basePower = 20;
    private ItemStack[] outputItem = new ItemStack[2];
    private int outputTracker;
    private int index = 0;
    private byte direction = 0;
    private FluidTankCore tank = new FluidTankCore(8000);

    public static void initialize() {
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.SideConfig();
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].numConfig = 5;
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}, {0}};
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TilePrecipitator.ALT_SIDE_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.SideConfig();
        TilePrecipitator.ALT_SIDE_CONFIGS[TilePrecipitator.TYPE].numConfig = 2;
        TilePrecipitator.ALT_SIDE_CONFIGS[TilePrecipitator.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}, {0}};
        TilePrecipitator.ALT_SIDE_CONFIGS[TilePrecipitator.TYPE].sideTypes = new int[]{0, 7};
        TilePrecipitator.ALT_SIDE_CONFIGS[TilePrecipitator.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.SlotConfig();
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TilePrecipitator.VALID_AUGMENTS[TilePrecipitator.TYPE] = new HashSet();
        GameRegistry.registerTileEntity(TilePrecipitator.class, (String)"thermalexpansion:machine_precipitator");
        TilePrecipitator.config();
    }

    public static void config() {
        String category = "Machine.Precipitator";
        BlockMachine.enable[TilePrecipitator.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Glacial Precipitator. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TilePrecipitator.ENERGY_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TilePrecipitator() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.outputItem[0] = PrecipitatorManager.getOutput(this.index);
        this.outputItem[1] = this.outputItem[0].func_77946_l();
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        PrecipitatorManager.PrecipitatorRecipe recipe = PrecipitatorManager.getRecipe(this.outputItem[0]);
        if (recipe == null) {
            return false;
        }
        if (!FluidHelper.isFluidEqual((FluidStack)this.tank.getFluid(), (FluidStack)recipe.getInput())) {
            return false;
        }
        if (this.tank.getFluidAmount() < recipe.getInput().amount || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.inventory[0].func_190926_b()) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(this.outputItem[0])) {
            return false;
        }
        return this.inventory[0].func_190916_E() + this.outputItem[0].func_190916_E() <= this.outputItem[0].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = PrecipitatorManager.getRecipe(this.outputItem[0]).getEnergy() * this.energyMod / 100;
        this.outputItem[1] = this.outputItem[0].func_77946_l();
    }

    @Override
    protected void processFinish() {
        PrecipitatorManager.PrecipitatorRecipe recipe = PrecipitatorManager.getRecipe(this.outputItem[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = recipe.getOutput();
        if (this.inventory[0].func_190926_b()) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[0].func_190917_f(output.func_190916_E());
        }
        this.tank.drain(recipe.getInput().amount, true);
        this.outputItem[1] = this.outputItem[0].func_77946_l();
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        if (tag.func_150297_b("OutputItem", 10)) {
            this.index = PrecipitatorManager.getIndex(new ItemStack(tag.func_74775_l("OutputItem")));
            this.outputItem[0] = PrecipitatorManager.getOutput(this.index);
            if (!this.isActive) {
                this.outputItem[1] = this.outputItem[0].func_77946_l();
            }
        }
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74782_a("OutputItem", (NBTBase)this.outputItem[0].func_77955_b(new NBTTagCompound()));
        return true;
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    private void setOutput() {
        if (this.index >= PrecipitatorManager.getOutputListSize()) {
            this.index = 0;
        } else if (this.index < 0) {
            this.index = PrecipitatorManager.getOutputListSize() - 1;
        }
        this.outputItem[0] = PrecipitatorManager.getOutput(this.index);
        if (!this.isActive) {
            this.outputItem[1] = this.outputItem[0].func_77946_l();
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiPrecipitator(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerPrecipitator(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(byte direction) {
        this.direction = direction;
        this.sendModePacket();
        this.direction = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        if (nbt.func_150297_b("OutputItem", 10)) {
            this.index = PrecipitatorManager.getIndex(new ItemStack(nbt.func_74775_l("OutputItem")));
        }
        this.outputItem[0] = PrecipitatorManager.getOutput(this.index);
        this.outputItem[1] = this.outputItem[0].func_77946_l();
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74782_a("OutputItem", (NBTBase)this.outputItem[0].func_77955_b(new NBTTagCompound()));
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addByte(this.direction);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.direction = payload.getByte();
        this.index += this.direction;
        this.setOutput();
        this.direction = 0;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    public ItemStack[] getInventorySlots(int inventoryIndex) {
        return this.outputItem;
    }

    public int getSlotStackLimit(int slotIndex) {
        return 64;
    }

    public void onSlotUpdate(int slotIndex) {
        this.markChunkDirty();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TilePrecipitator.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TilePrecipitator.this.allowInsertion(((TilePrecipitator)TilePrecipitator.this).sideConfig.sideTypes[TilePrecipitator.this.sideCache[from.ordinal()]])) {
                        return TilePrecipitator.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TilePrecipitator.this.isActive) {
                        return null;
                    }
                    if (from == null || TilePrecipitator.this.allowExtraction(((TilePrecipitator)TilePrecipitator.this).sideConfig.sideTypes[TilePrecipitator.this.sideCache[from.ordinal()]])) {
                        return TilePrecipitator.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TilePrecipitator.this.isActive) {
                        return null;
                    }
                    if (from == null || TilePrecipitator.this.allowExtraction(((TilePrecipitator)TilePrecipitator.this).sideConfig.sideTypes[TilePrecipitator.this.sideCache[from.ordinal()]])) {
                        return TilePrecipitator.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

