/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.block.TileTEBase;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.gui.container.machine.ContainerTransposer;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTransposer
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.TRANSPOSER.getMetadata();
    public static int basePower = 20;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(10000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    private boolean hasFluidHandler = false;
    public boolean extractMode;
    public boolean extractFlag;

    public static void initialize() {
        TileTransposer.SIDE_CONFIGS[TileTransposer.TYPE] = new TileTEBase.SideConfig();
        TileTransposer.SIDE_CONFIGS[TileTransposer.TYPE].numConfig = 7;
        TileTransposer.SIDE_CONFIGS[TileTransposer.TYPE].slotGroups = new int[][]{new int[0], {0}, {2}, new int[0], {2}, {0, 2}, {0, 2}};
        TileTransposer.SIDE_CONFIGS[TileTransposer.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileTransposer.SIDE_CONFIGS[TileTransposer.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileTransposer.ALT_SIDE_CONFIGS[TileTransposer.TYPE] = new TileTEBase.SideConfig();
        TileTransposer.ALT_SIDE_CONFIGS[TileTransposer.TYPE].numConfig = 2;
        TileTransposer.ALT_SIDE_CONFIGS[TileTransposer.TYPE].slotGroups = new int[][]{new int[0], {0}, {2}, new int[0], {2}, {0, 2}, {0, 2}};
        TileTransposer.ALT_SIDE_CONFIGS[TileTransposer.TYPE].sideTypes = new int[]{0, 7};
        TileTransposer.ALT_SIDE_CONFIGS[TileTransposer.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileTransposer.SLOT_CONFIGS[TileTransposer.TYPE] = new TileTEBase.SlotConfig();
        TileTransposer.SLOT_CONFIGS[TileTransposer.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileTransposer.SLOT_CONFIGS[TileTransposer.TYPE].allowExtractionSlot = new boolean[]{false, false, true, false};
        TileTransposer.VALID_AUGMENTS[TileTransposer.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        GameRegistry.registerTileEntity(TileTransposer.class, (String)"thermalexpansion:machine_transposer");
        TileTransposer.config();
    }

    public static void config() {
        String category = "Machine.Transposer";
        BlockMachine.enable[TileTransposer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Fluid Transposer. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 200, comment);
        TileTransposer.ENERGY_CONFIGS[TileTransposer.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileTransposer() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    private void updateHandler() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.processRem <= 0) {
                if (this.processFinishHandler()) {
                    this.transferHandler();
                    this.transferOutput();
                    this.transferInput();
                }
                this.energyStorage.modifyEnergyStored(-this.processRem);
                if (!this.redstoneControlOrDisable() || !this.canStartHandler()) {
                    this.processOff();
                } else {
                    this.processStartHandler();
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferOutput();
                this.transferInput();
            }
            if (this.timeCheckEighth() && this.canStartHandler()) {
                this.processStartHandler();
                this.processTick();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    private boolean canStartHandler() {
        TransposerManager.ContainerOverride override;
        if (!FluidHelper.isFluidHandler((ItemStack)this.inventory[1])) {
            this.hasFluidHandler = false;
            return false;
        }
        if (this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (!(this.inventory[2].func_190926_b() || (override = TransposerManager.getContainerOverride(this.inventory[1])) != null && this.inventory[2].func_77969_a(override.getOutput()))) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)this.inventory[1].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        if (!this.extractMode) {
            return this.tank.getFluid() != null && this.tank.getFluidAmount() > 0 && handler.fill(new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 1000)), false) > 0;
        }
        return this.tank.fill(handler.drain(Math.min(this.tank.getSpace(), 1000), false), false) > 0;
    }

    private void processStartHandler() {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.inventory[1].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        IFluidTankProperties[] tankProperties = handler.getTankProperties();
        FluidStack handlerStack = tankProperties[0].getContents();
        FluidStack prevStack = this.renderFluid.copy();
        if (!this.extractMode) {
            this.renderFluid = this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
        } else {
            FluidStack fluidStack = this.tank.getFluid() == null ? (handlerStack == null ? null : handlerStack.copy()) : (this.renderFluid = this.tank.getFluid().copy());
        }
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.WATER, 0);
        } else {
            this.renderFluid.amount = 0;
        }
        this.processRem = this.processMax = 400 * this.energyMod / 100;
        if (!FluidHelper.isFluidEqual((FluidStack)prevStack, (FluidStack)this.renderFluid)) {
            this.sendFluidPacket();
        }
    }

    private boolean processFinishHandler() {
        if (!this.extractMode) {
            return this.fillHandler();
        }
        return this.emptyHandler();
    }

    private boolean fillHandler() {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.inventory[1].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        int filled = this.tank.getFluid() == null ? 0 : handler.fill(new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 1000)), true);
        IFluidTankProperties[] tankProperties = handler.getTankProperties();
        if (tankProperties == null || tankProperties.length < 1) {
            return true;
        }
        if (filled > 0) {
            this.tank.drain(filled, true);
            this.inventory[1] = handler.getContainer();
            return tankProperties[0].getContents() != null && tankProperties[0].getContents().amount >= tankProperties[0].getCapacity();
        }
        return true;
    }

    private boolean emptyHandler() {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.inventory[1].getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        ItemStack testStack = ItemHelper.cloneStack((ItemStack)this.inventory[1]);
        FluidStack drainStack = handler.drain(Math.min(this.tank.getSpace(), 1000), true);
        int drained = drainStack == null ? 0 : drainStack.amount;
        IFluidTankProperties[] tankProperties = handler.getTankProperties();
        if (tankProperties == null || tankProperties.length < 1) {
            return true;
        }
        if (drained > 0) {
            this.tank.fill(drainStack, true);
            if (tankProperties[0].getContents() == null) {
                int chance;
                TransposerManager.ContainerOverride override = TransposerManager.getContainerOverride(testStack);
                this.inventory[1] = override != null ? ((chance = override.getChance()) >= 100 || this.field_145850_b.field_73012_v.nextInt(this.secondaryChance) < chance ? ItemHelper.cloneStack((ItemStack)override.getOutput()) : handler.getContainer()) : handler.getContainer();
                if (this.inventory[1].func_190916_E() <= 0) {
                    this.inventory[1] = ItemStack.field_190927_a;
                }
                return true;
            }
            this.inventory[1] = handler.getContainer();
            return false;
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        if (this.hasFluidHandler) {
            this.updateHandler();
        } else {
            super.func_73660_a();
        }
    }

    @Override
    public int getLightValue() {
        return this.isActive ? this.renderFluid.getFluid().getLuminosity(this.renderFluid) : 0;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || !this.inventory[1].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (!(this.hasFluidHandler || !FluidHelper.isFluidHandler((ItemStack)this.inventory[0]) || !this.extractMode && TransposerManager.fillRecipeExists(this.inventory[0], this.tank.getFluid()) || this.extractMode && TransposerManager.extractRecipeExists(this.inventory[0]))) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.hasFluidHandler = true;
            return false;
        }
        if (!this.extractMode) {
            if (this.tank.getFluidAmount() <= 0) {
                return false;
            }
            TransposerManager.TransposerRecipe recipe = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            if (recipe == null || this.tank.getFluidAmount() < recipe.getFluid().amount) {
                return false;
            }
            if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
                return false;
            }
            if (this.inventory[2].func_190926_b()) {
                return true;
            }
            ItemStack output = recipe.getOutput();
            return this.inventory[2].func_77969_a(output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
        }
        TransposerManager.TransposerRecipe recipe = TransposerManager.getExtractRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < recipe.getInput().func_190916_E()) {
            return false;
        }
        if (this.tank.fill(recipe.getFluid(), false) != recipe.getFluid().amount) {
            return false;
        }
        if (this.inventory[2].func_190926_b()) {
            return true;
        }
        ItemStack output = recipe.getOutput();
        return output.func_190926_b() || this.inventory[2].func_77969_a(output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.hasFluidHandler) {
            return true;
        }
        TransposerManager.TransposerRecipe recipe = this.extractMode ? TransposerManager.getExtractRecipe(this.inventory[1]) : TransposerManager.getFillRecipe(this.inventory[1], this.tank.getFluid());
        return recipe != null && recipe.getInput().func_190916_E() <= this.inventory[1].func_190916_E();
    }

    @Override
    protected void processStart() {
        TransposerManager.TransposerRecipe recipe;
        FluidStack prevStack = this.renderFluid.copy();
        if (!this.extractMode) {
            recipe = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            this.processMax = recipe.getEnergy() * this.energyMod / 100;
            this.renderFluid = this.tank.getFluid().copy();
        } else {
            recipe = TransposerManager.getExtractRecipe(this.inventory[0]);
            this.processMax = recipe.getEnergy() * this.energyMod / 100;
            this.renderFluid = recipe.getFluid().copy();
        }
        this.renderFluid.amount = 0;
        this.processRem = this.processMax;
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)recipe.getInput().func_190916_E());
        this.inventory[0].func_190918_g(recipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
        if (!FluidHelper.isFluidEqual((FluidStack)prevStack, (FluidStack)this.renderFluid)) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (!this.extractMode) {
            TransposerManager.TransposerRecipe recipe = TransposerManager.getFillRecipe(this.inventory[1], this.tank.getFluid());
            if (recipe == null) {
                this.processOff();
                return;
            }
            ItemStack output = recipe.getOutput();
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)output);
            } else {
                this.inventory[2].func_190917_f(output.func_190916_E());
            }
            this.inventory[1] = ItemStack.field_190927_a;
            this.tank.drain(recipe.getFluid().amount, true);
        } else {
            TransposerManager.TransposerRecipe recipe = TransposerManager.getExtractRecipe(this.inventory[1]);
            if (recipe == null) {
                this.processOff();
                return;
            }
            ItemStack output = recipe.getOutput();
            int recipeChance = recipe.getChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(this.secondaryChance) < recipeChance) {
                if (this.inventory[2].func_190926_b()) {
                    this.inventory[2] = ItemHelper.cloneStack((ItemStack)output);
                } else {
                    this.inventory[2].func_190917_f(output.func_190916_E());
                }
            }
            this.inventory[1] = ItemStack.field_190927_a;
            this.tank.fill(recipe.getFluid(), true);
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.extractMode) {
            this.transferOutputFluid();
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    private void transferHandler() {
        if (this.hasFluidHandler) {
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = ItemHelper.cloneStack((ItemStack)this.inventory[1], (int)1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.hasFluidHandler = false;
            } else if (ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)this.inventory[2]) && this.inventory[1].func_77976_d() > 1 && this.inventory[2].func_190916_E() + 1 <= this.inventory[2].func_77976_d()) {
                this.inventory[2].func_190917_f(1);
                this.inventory[1] = ItemStack.field_190927_a;
                this.hasFluidHandler = false;
            }
        }
        if (!this.hasFluidHandler && FluidHelper.isFluidHandler((ItemStack)this.inventory[0])) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190916_E() <= 0) {
                this.inventory[0] = ItemStack.field_190927_a;
            }
            this.hasFluidHandler = true;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTransposer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTransposer(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(boolean mode) {
        this.extractMode = mode;
        this.sendModePacket();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut1");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut2");
        if (!this.inventory[1].func_190926_b() && this.inventory[1].hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            this.hasFluidHandler = true;
        }
        this.extractFlag = this.extractMode = nbt.func_74771_c("Mode") == 1;
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid().copy();
        } else if (TransposerManager.getExtractRecipe(this.inventory[1]) != null) {
            this.renderFluid = TransposerManager.getExtractRecipe(this.inventory[1]).getFluid().copy();
            this.renderFluid.amount = 0;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut1", this.outputTracker);
        nbt.func_74768_a("TrackOut2", this.outputTrackerFluid);
        nbt.func_74774_a("Mode", this.extractMode ? (byte)1 : 0);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.extractMode);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.extractFlag = this.extractMode = payload.getBool();
        if (this.isActive) {
            this.processOff();
        }
        this.callNeighborTileChange();
    }

    public PacketBase getFluidPacket() {
        PacketBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.extractMode);
        payload.addBool(this.extractFlag);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    protected void handleFluidPacket(PacketBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.extractMode = payload.getBool();
        this.extractFlag = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1 && this.isActive && (this.inventory[slot].func_190926_b() || !this.hasValidInput())) {
            this.processOff();
            this.hasFluidHandler = false;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot == 1) {
            if (!(!this.isActive || this.inventory[slot].func_190926_b() || !stack.func_190926_b() && stack.func_77969_a(this.inventory[slot]) && this.hasValidInput())) {
                this.processOff();
            }
            this.hasFluidHandler = false;
        }
        this.inventory[slot] = stack;
        this.markChunkDirty();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || FluidHelper.isFluidHandler((ItemStack)stack) || TransposerManager.isItemValid(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? this.renderFluid.getFluid().getColor(this.renderFluid) << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.machineTransposer : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileTransposer.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (TileTransposer.this.extractMode) {
                        return 0;
                    }
                    if (from == null || TileTransposer.this.allowInsertion(((TileTransposer)TileTransposer.this).sideConfig.sideTypes[TileTransposer.this.sideCache[from.ordinal()]])) {
                        return TileTransposer.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (!TileTransposer.this.extractMode && TileTransposer.this.isActive) {
                        return null;
                    }
                    if (from == null || TileTransposer.this.allowExtraction(((TileTransposer)TileTransposer.this).sideConfig.sideTypes[TileTransposer.this.sideCache[from.ordinal()]])) {
                        return TileTransposer.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (!TileTransposer.this.extractMode && TileTransposer.this.isActive) {
                        return null;
                    }
                    if (from == null || TileTransposer.this.allowExtraction(((TileTransposer)TileTransposer.this).sideConfig.sideTypes[TileTransposer.this.sideCache[from.ordinal()]])) {
                        return TileTransposer.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

