/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container.storage;

import cofh.api.item.IInventoryContainerItem;
import cofh.core.gui.slot.ISlotValidator;
import cofh.core.gui.slot.SlotValidated;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.block.storage.TileStrongbox;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import gnu.trove.map.hash.THashMap;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Optional;

@ChestContainer
public class ContainerStrongbox
extends ContainerTEBase
implements ISlotValidator {
    int storageIndex;
    int rowSize;
    TileStrongbox myTile;

    public ContainerStrongbox(InventoryPlayer inventory, TileEntity tile) {
        super(tile);
        this.myTile = (TileStrongbox)tile;
        this.myTile.func_174889_b(inventory.field_70458_d);
        this.storageIndex = this.myTile.getStorageIndex();
        this.rowSize = MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        int rows = MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        int slots = this.rowSize * rows;
        int yOffset = 17;
        this.bindPlayerInventory(inventory);
        if (this.storageIndex == 0) {
            this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.myTile, 0, 80, 26));
            this.rowSize = 1;
        } else {
            for (int i = 0; i < slots; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.myTile, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
            }
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    @Override
    protected int getPlayerInventoryVerticalOffset() {
        return 30 + 18 * MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
    }

    protected int getPlayerInventoryHorizontalOffset() {
        return 8 + 9 * (this.rowSize - 9);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.myTile.func_174886_c(player);
    }

    public TileStrongbox getTile() {
        return this.myTile;
    }

    public boolean isItemValid(ItemStack stack) {
        return !stack.func_190926_b() && (!(stack.func_77973_b() instanceof IInventoryContainerItem) || ((IInventoryContainerItem)stack.func_77973_b()).getSizeInventory(stack) <= 0);
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        THashMap slotRefs = new THashMap();
        slotRefs.put(ContainerSection.INVENTORY, this.field_75151_b.subList(0, 36));
        slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(0, 27));
        slotRefs.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(27, 36));
        slotRefs.put(ContainerSection.CHEST, this.field_75151_b.subList(36, this.field_75151_b.size()));
        return slotRefs;
    }

    @ChestContainer.RowSizeCallback
    @Optional.Method(modid="inventorytweaks")
    public int getRowSize() {
        return this.rowSize;
    }
}

