/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.core.init.CoreProps;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.ConfigHandler;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.entity.projectile.EntityMorb;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.util.BehaviorMorbDispense;
import cofh.thermalfoundation.init.TFProps;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMorb
extends ItemMulti
implements IInitializer,
IModelRegister {
    public static final ConfigHandler CONFIG_MORBS = new ConfigHandler("5.4.2");
    public static final int TINT_INDEX_1 = 1;
    public static final int TINT_INDEX_2 = 2;
    public static ArrayList<ItemStack> morbList = new ArrayList();
    public static Set<String> validMobs = new THashSet();
    public static String[] blacklist = new String[0];
    public static boolean enable = true;
    public static final String GENERIC = "Generic";
    public static final int REUSE_CHANCE = 25;
    public static ItemStack morbStandard;
    public static ItemStack morbReusable;

    public static ItemStack setTag(ItemStack container, String entityId, boolean genericTag) {
        if (entityId != null && !entityId.isEmpty()) {
            container.func_77982_d(new NBTTagCompound());
            container.func_77978_p().func_74778_a("id", entityId);
            if (genericTag) {
                container.func_77978_p().func_74757_a(GENERIC, true);
            }
        }
        return container;
    }

    public ItemMorb() {
        super("thermalexpansion");
        this.func_77655_b("morb");
        this.func_77637_a(ThermalExpansion.tabMorbs);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.localize((String)"info.thermalexpansion.morb.a.0"));
        if (ItemHelper.getItemDamage((ItemStack)stack) > 0) {
            tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.morb.a.1"));
        }
        if (stack.func_77978_p() == null) {
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.morb.b.0"));
        } else {
            if (stack.func_77978_p().func_74764_b(GENERIC)) {
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.morb.b.2"));
            }
            tooltip.add(StringHelper.localize((String)"info.thermalexpansion.morb.b.1"));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (TEProps.creativeTabHideMorbs) {
            return;
        }
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 1));
            items.addAll(morbList);
        }
    }

    public String func_77653_i(ItemStack stack) {
        String entityId;
        EntityEntry entry;
        String entityName = "info.cofh.empty";
        String openParen = " (";
        String closeParen = "\u00a7r)";
        if (stack.func_77978_p() != null && (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityId = stack.func_77978_p().func_74779_i("id")))) != null) {
            entityName = "entity." + entry.getName() + ".name";
        }
        return super.func_77653_i(stack) + openParen + StringHelper.localize((String)entityName) + closeParen;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() > 1) {
            stack.func_77964_b(1);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack.func_77942_o()) {
            nbt = stack.func_77978_p();
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (ServerHelper.isServerWorld((World)world)) {
            EntityMorb morb = new EntityMorb(world, (EntityLivingBase)player, (byte)ItemHelper.getItemDamage((ItemStack)stack), nbt);
            morb.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)morb);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void addMorb(ItemStack morb, String entityId) {
        ItemMorb.setTag(morb, entityId, true);
        morbList.add(morb);
        validMobs.add(entityId);
    }

    public static void dropMorb(int type, NBTTagCompound nbt, World world, BlockPos pos) {
        ItemStack stack;
        ItemStack itemStack = stack = type == 0 ? morbStandard.func_77946_l() : morbReusable.func_77946_l();
        if (nbt != null && validMobs.contains(nbt.func_74779_i("id"))) {
            if (nbt.func_74764_b(GENERIC)) {
                stack = ItemMorb.setTag(stack, nbt.func_74779_i("id"), true);
            } else {
                nbt.func_82580_o("Pos");
                nbt.func_82580_o("Motion");
                nbt.func_82580_o("Rotation");
                nbt.func_82580_o("FallDistance");
                nbt.func_82580_o("Fire");
                nbt.func_82580_o("Air");
                nbt.func_82580_o("OnGround");
                nbt.func_82580_o("Dimension");
                nbt.func_82580_o("PortalCooldown");
                nbt.func_82580_o("UUIDMost");
                nbt.func_82580_o("UUIDLeast");
                nbt.func_82580_o("Leashed");
                nbt.func_82580_o("Leash");
                stack.func_77982_d(nbt);
            }
        }
        CoreUtils.dropItemStackIntoWorldWithVelocity((ItemStack)stack, (World)world, (BlockPos)pos);
    }

    public static ItemStack getMorb(int type, NBTTagCompound nbt) {
        ItemStack stack;
        ItemStack itemStack = stack = type == 0 ? morbStandard.func_77946_l() : morbReusable.func_77946_l();
        if (nbt != null && validMobs.contains(nbt.func_74779_i("id"))) {
            if (nbt.func_74764_b(GENERIC)) {
                stack = ItemMorb.setTag(stack, nbt.func_74779_i("id"), true);
            } else {
                nbt.func_82580_o("Pos");
                nbt.func_82580_o("Motion");
                nbt.func_82580_o("Rotation");
                nbt.func_82580_o("FallDistance");
                nbt.func_82580_o("Fire");
                nbt.func_82580_o("Air");
                nbt.func_82580_o("OnGround");
                nbt.func_82580_o("Dimension");
                nbt.func_82580_o("PortalCooldown");
                nbt.func_82580_o("UUIDMost");
                nbt.func_82580_o("UUIDLeast");
                nbt.func_82580_o("Leashed");
                nbt.func_82580_o("Leash");
                stack.func_77982_d(nbt);
            }
        }
        return stack;
    }

    public static void parseMorbs() {
        List<String> list = Arrays.asList(blacklist);
        for (ResourceLocation name : EntityList.func_180124_b()) {
            Class clazz = EntityList.getClass((ResourceLocation)name);
            if (clazz == null || !EntityLiving.class.isAssignableFrom(clazz) || list.contains(name.toString()) || !EntityList.field_75627_a.containsKey(name)) continue;
            ItemMorb.addMorb(ItemHelper.cloneStack((ItemStack)morbStandard), name.toString());
        }
        if (TFProps.useUnifiedTabs) {
            TFProps.miscList.addAll(morbList);
        }
        CONFIG_MORBS.cleanUp(false, true);
    }

    public static ItemStack getGenericMorb(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && validMobs.contains(nbt.func_74779_i("id"))) {
            return ItemMorb.setTag(stack, nbt.func_74779_i("id"), false);
        }
        return ItemStack.field_190927_a;
    }

    public int colorMultiplier(ItemStack stack, int tintIndex) {
        EntityList.EntityEggInfo info = null;
        if (stack.func_77942_o()) {
            ResourceLocation id = new ResourceLocation(stack.func_77978_p().func_74779_i("id"));
            info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(id);
        }
        if (info != null) {
            switch (tintIndex) {
                case 1: {
                    return info.field_75611_b;
                }
                case 2: {
                    return info.field_75612_c;
                }
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), String.format("full=%s,type=%s", stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("id") ? 1 : 0, ((ItemMulti.ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)ItemHelper.getItemDamage((ItemStack)stack)))).name)));
        for (Map.Entry entry : this.itemMap.entrySet()) {
            for (int i = 0; i < 2; ++i) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), String.format("full=%s,type=%s", i, ((ItemMulti.ItemEntry)entry.getValue()).name))});
            }
        }
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("morb"));
        ThermalExpansion.proxy.addIModelRegister(this);
        ItemMorb.config();
        morbStandard = this.addItem(0, "standard");
        morbReusable = this.addItem(1, "reusable", EnumRarity.UNCOMMON);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new BehaviorMorbDispense());
        return true;
    }

    public boolean initialize() {
        if (!enable) {
            return false;
        }
        ItemStack morbStack = ItemHelper.cloneStack((ItemStack)morbStandard, (int)8);
        RecipeHelper.addShapelessRecipe((ItemStack)morbStack, (Object[])new Object[]{Blocks.field_150425_aM, "crystalSlag", "slimeball", "enderpearl"});
        RecipeHelper.addShapelessRecipe((ItemStack)morbReusable, (Object[])new Object[]{morbStandard, "nuggetSignalum", "nuggetSignalum", "nuggetSignalum"});
        RecipeHelper.addShapelessRecipe((ItemStack)morbStack, (Object[])new Object[]{Blocks.field_150425_aM, "crystalSlag", ItemMaterial.globRosin, "enderpearl"});
        return true;
    }

    private static void config() {
        CONFIG_MORBS.setConfiguration(new Configuration(new File(CoreProps.configDir, "cofh/thermalexpansion/morbs.cfg"), true));
        String category = "General";
        String comment = "If TRUE, the recipes for Morbs are enabled. Setting this to FALSE means that you actively dislike fun things and/or Pokemon tributes.";
        enable = CONFIG_MORBS.getConfiguration().getBoolean("EnableRecipe", category, enable, comment);
        category = "Blacklist";
        comment = "List of entities that are not allowed to be placed in Morbs. Mobs without spawn eggs are automatically disallowed.";
        blacklist = CONFIG_MORBS.getConfiguration().getStringList("Blacklist", category, blacklist, comment);
    }
}

