/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.transposer;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class TransposerRecipeCategoryExtract
extends TransposerRecipeCategory {
    public static void initialize(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(TransposerRecipeCategoryExtract.getRecipes(guiHelper, registry.getIngredientRegistry()), "thermalexpansion.transposer_extract");
        registry.addRecipeCatalyst((Object)BlockMachine.machineTransposer, new String[]{"thermalexpansion.transposer_extract"});
    }

    public static List<TransposerRecipeWrapper> getRecipes(IGuiHelper guiHelper, IIngredientRegistry ingredientRegistry) {
        ArrayList<TransposerRecipeWrapper> recipes = new ArrayList<TransposerRecipeWrapper>();
        for (TransposerManager.TransposerRecipe recipe : TransposerManager.getExtractRecipeList()) {
            recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_extract"));
        }
        List ingredients = ingredientRegistry.getIngredients(ItemStack.class);
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                TransposerRecipeCategoryExtract.addExtractRecipe(ingredient, fluid, recipes, guiHelper);
            }
        }
        return recipes;
    }

    private static void addExtractRecipe(ItemStack baseStack, Fluid fluid, List<TransposerRecipeWrapper> recipes, IGuiHelper guiHelper) {
        ItemStack filledStack = baseStack.func_77946_l();
        IFluidHandlerItem handler = (IFluidHandlerItem)filledStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        int fill = handler.fill(new FluidStack(fluid, 1000), true);
        if (fill > 0) {
            filledStack = handler.getContainer().func_77946_l();
            FluidStack drainedFluid = handler.drain(1000, true);
            if (drainedFluid != null) {
                ItemStack drainedStack;
                TransposerManager.TransposerRecipe recipe = new TransposerManager.TransposerRecipe(filledStack, drainedStack, drainedFluid, 400, (drainedStack = handler.getContainer()).func_190916_E() <= 0 ? 0 : 100);
                recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_extract"));
            }
        }
    }

    public TransposerRecipeCategoryExtract(IGuiHelper guiHelper) {
        super(guiHelper);
        this.localizedName = this.localizedName + " - " + StringHelper.localize((String)"gui.thermalexpansion.jei.transposer.modeEmpty");
        this.icon = guiHelper.createDrawable(GuiTransposer.TEXTURE, 192, 48, 16, 16);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.transposer_extract";
    }

    public void setRecipe(IRecipeLayout recipeLayout, TransposerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        List fluids = ingredients.getOutputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 30, 10);
        guiItemStacks.init(1, false, 30, 41);
        guiFluidStacks.init(0, false, 103, 1, 16, 60, 10000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, outputs.isEmpty() ? null : (List)outputs.get(0));
        guiFluidStacks.set(0, (List)fluids.get(0));
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 1 && recipeWrapper.chance < 100) {
                tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
            }
        });
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (FluidHelper.isPotionFluid((FluidStack)ingredient)) {
                FluidHelper.addPotionTooltip((FluidStack)ingredient, (List)tooltip);
            }
        });
    }
}

