/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.render.BakeryCell;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class BakeryFrame
implements IItemBakery {
    public static final BakeryFrame INSTANCE = new BakeryFrame();

    public List<BakedQuad> bakeItemQuads(EnumFacing dir, ItemStack stack) {
        if (dir == null) {
            BakingVertexBuffer buffer = BakingVertexBuffer.create();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.bind((BufferBuilder)buffer);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                int i = face.ordinal();
                BakeryCell.modelFrame.render(ccrs, i * 4, i * 4 + 4, new IVertexOperation[]{new IconTransformation(this.getFrameTexture(face, stack))});
                TextureAtlasSprite inner = this.getInnerTexture(face, stack);
                if (inner == null) continue;
                BakeryCell.modelFrame.render(ccrs, i * 4 + 24, i * 4 + 28, new IVertexOperation[]{new IconTransformation(inner)});
            }
            TextureAtlasSprite center = this.getCenterTexture(stack);
            if (center != null) {
                BakeryCell.modelCenter.render(ccrs, new IVertexOperation[]{new IconTransformation(center)});
            }
            buffer.func_178977_d();
            return buffer.bake();
        }
        return ImmutableList.of();
    }

    public ModelProperties.PerspectiveProperties getModelProperties(ItemStack stack) {
        return ModelProperties.PerspectiveProperties.DEFAULT_BLOCK;
    }

    private TextureAtlasSprite getFrameTexture(EnumFacing face, ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                if (face == EnumFacing.UP) {
                    return TETextures.MACHINE_FRAME_TOP;
                }
                if (face == EnumFacing.DOWN) {
                    return TETextures.MACHINE_FRAME_BOTTOM;
                }
                return TETextures.MACHINE_FRAME_SIDE;
            }
            case 64: {
                if (face == EnumFacing.UP) {
                    return TETextures.DEVICE_FRAME_TOP;
                }
                if (face == EnumFacing.DOWN) {
                    return TETextures.DEVICE_FRAME_BOTTOM;
                }
                return TETextures.DEVICE_FRAME_SIDE;
            }
            case 128: {
                return TETextures.CELL_SIDE_0;
            }
            case 129: {
                return TETextures.CELL_SIDE_1;
            }
            case 130: 
            case 146: {
                return TETextures.CELL_SIDE_2;
            }
            case 131: 
            case 147: {
                return TETextures.CELL_SIDE_3;
            }
            case 132: 
            case 148: {
                return TETextures.CELL_SIDE_4;
            }
            case 160: {
                return TETextures.ILLUMINATOR_FRAME;
            }
        }
        return TETextures.MACHINE_OVERLAY_0;
    }

    private TextureAtlasSprite getInnerTexture(EnumFacing face, ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return TETextures.MACHINE_FRAME_INNER;
            }
            case 64: {
                return TETextures.DEVICE_FRAME_INNER;
            }
            case 128: {
                return TETextures.CELL_INNER_0;
            }
            case 129: {
                return TETextures.CELL_INNER_1;
            }
            case 130: 
            case 146: {
                return TETextures.CELL_INNER_2;
            }
            case 131: 
            case 147: {
                return TETextures.CELL_INNER_3;
            }
            case 132: 
            case 148: {
                return TETextures.CELL_INNER_4;
            }
        }
        return null;
    }

    private TextureAtlasSprite getCenterTexture(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 146: 
            case 147: 
            case 148: {
                return TETextures.CELL_CENTER_1;
            }
        }
        return null;
    }
}

