/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.dynamo;

import com.google.common.collect.ImmutableSet;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Collection;
import java.util.Set;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MagmaticManager {
    private static TObjectIntHashMap<String> fuelMap = new TObjectIntHashMap();
    public static int DEFAULT_ENERGY = 100000;

    public static Set<String> getFuels() {
        return ImmutableSet.copyOf((Collection)fuelMap.keySet());
    }

    public static boolean isValidFuel(FluidStack fluid) {
        return fluid != null && fuelMap.containsKey((Object)fluid.getFluid().getName());
    }

    public static int getFuelEnergy(FluidStack fluid) {
        return fluid == null ? 0 : fuelMap.get((Object)fluid.getFluid().getName());
    }

    public static int getFuelEnergy100mB(FluidStack fluid) {
        return fluid == null ? 0 : fuelMap.get((Object)fluid.getFluid().getName()) / 10;
    }

    public static void refresh() {
    }

    public static boolean addFuel(String fluidName, int energy) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName) || energy < 10000 || energy > 200000000) {
            return false;
        }
        fuelMap.put((Object)fluidName, energy);
        return true;
    }

    public static boolean removeFuel(String fluidName) {
        if (!FluidRegistry.isFluidRegistered((String)fluidName)) {
            return false;
        }
        fuelMap.remove((Object)fluidName);
        return true;
    }
}

