/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.init.CorePotions;
import cofh.core.inventory.ComparableItemStackValidatedNBT;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraftforge.fluids.FluidStack;

public class BrewerManager {
    private static Map<List<Integer>, BrewerRecipe> recipeMap = new THashMap();
    private static Set<ComparableItemStackValidatedNBT> validationSet = new THashSet();
    private static Set<String> validationFluids = new THashSet();
    private static OreValidator oreValidator = new OreValidator();
    public static final int DEFAULT_ENERGY = 2400;
    public static final int DEFAULT_AMOUNT = 750;

    public static BrewerRecipe getRecipe(ItemStack input, FluidStack fluid) {
        return input.func_190926_b() || fluid == null ? null : recipeMap.get(Arrays.asList(BrewerManager.convertInput(input).hashCode(), FluidHelper.getFluidHash((FluidStack)fluid)));
    }

    public static boolean recipeExists(ItemStack input, FluidStack fluid) {
        return BrewerManager.getRecipe(input, fluid) != null;
    }

    public static BrewerRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new BrewerRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(BrewerManager.convertInput(input));
    }

    public static boolean isFluidValid(FluidStack fluid) {
        return fluid != null && validationFluids.contains(fluid.getFluid().getName());
    }

    public static void initialize() {
        ItemStack goldenCarrot = new ItemStack(Items.field_151150_bK);
        ItemStack rabbitFoot = new ItemStack(Items.field_179556_br);
        ItemStack magmaCream = new ItemStack(Items.field_151064_bs);
        ItemStack sugar = new ItemStack(Items.field_151102_aT);
        ItemStack melon = new ItemStack(Items.field_151060_bw);
        ItemStack spiderEye = new ItemStack(Items.field_151070_bp);
        ItemStack ghastTear = new ItemStack(Items.field_151073_bk);
        ItemStack blazePowder = new ItemStack(Items.field_151065_br);
        ItemStack redstone = new ItemStack(Items.field_151137_ax);
        ItemStack glowstone = new ItemStack(Items.field_151114_aO);
        ItemStack fermentedSpiderEye = new ItemStack(Items.field_151071_bq);
        ItemStack emerald = new ItemStack(Items.field_151166_bC);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, new ItemStack(Items.field_151075_bm), PotionTypes.field_185233_e);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, rabbitFoot, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, magmaCream, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, sugar, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, melon, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, spiderEye, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, ghastTear, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, blazePowder, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, redstone, PotionTypes.field_185231_c);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, glowstone, PotionTypes.field_185232_d);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185230_b, fermentedSpiderEye, PotionTypes.field_185226_I);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, goldenCarrot, PotionTypes.field_185234_f);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, rabbitFoot, PotionTypes.field_185238_j);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, magmaCream, PotionTypes.field_185241_m);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, sugar, PotionTypes.field_185243_o);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, new ItemStack(Items.field_151115_aP, 1, 3), PotionTypes.field_185248_t);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, melon, PotionTypes.field_185250_v);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, spiderEye, PotionTypes.field_185254_z);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, ghastTear, PotionTypes.field_185220_C);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, blazePowder, PotionTypes.field_185223_F);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185234_f, fermentedSpiderEye, PotionTypes.field_185236_h);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185238_j, fermentedSpiderEye, PotionTypes.field_185246_r);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185243_o, fermentedSpiderEye, PotionTypes.field_185246_r);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185250_v, fermentedSpiderEye, PotionTypes.field_185252_x);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185254_z, fermentedSpiderEye, PotionTypes.field_185252_x);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185234_f, redstone, PotionTypes.field_185235_g);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185236_h, redstone, PotionTypes.field_185237_i);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185238_j, redstone, PotionTypes.field_185239_k);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185241_m, redstone, PotionTypes.field_185242_n);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185243_o, redstone, PotionTypes.field_185244_p);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185246_r, redstone, PotionTypes.field_185247_s);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185248_t, redstone, PotionTypes.field_185249_u);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185254_z, redstone, PotionTypes.field_185218_A);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185220_C, redstone, PotionTypes.field_185221_D);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185223_F, redstone, PotionTypes.field_185224_G);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185226_I, redstone, PotionTypes.field_185227_J);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185238_j, glowstone, PotionTypes.field_185240_l);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185243_o, glowstone, PotionTypes.field_185245_q);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185250_v, glowstone, PotionTypes.field_185251_w);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185252_x, glowstone, PotionTypes.field_185253_y);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185254_z, glowstone, PotionTypes.field_185219_B);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185220_C, glowstone, PotionTypes.field_185222_E);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185223_F, glowstone, PotionTypes.field_185225_H);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185235_g, fermentedSpiderEye, PotionTypes.field_185237_i);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185239_k, fermentedSpiderEye, PotionTypes.field_185247_s);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185244_p, fermentedSpiderEye, PotionTypes.field_185247_s);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185218_A, fermentedSpiderEye, PotionTypes.field_185252_x);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185251_w, fermentedSpiderEye, PotionTypes.field_185253_y);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185219_B, fermentedSpiderEye, PotionTypes.field_185253_y);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, ItemMaterial.dustBasalz, CorePotions.haste);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, ItemMaterial.dustObsidian, CorePotions.resistance);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, ItemMaterial.dustBlitz, CorePotions.levitation);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, ItemMaterial.dustBlizz, CorePotions.absorption);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185233_e, emerald, CorePotions.luck);
        BrewerManager.addDefaultPotionRecipes(CorePotions.luck, fermentedSpiderEye, CorePotions.unluck);
        BrewerManager.addDefaultPotionRecipes(PotionTypes.field_185220_C, fermentedSpiderEye, CorePotions.wither);
        BrewerManager.addDefaultPotionRecipes(CorePotions.haste, redstone, CorePotions.hasteLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.resistance, redstone, CorePotions.resistanceLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.levitation, redstone, CorePotions.levitationLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.absorption, redstone, CorePotions.absorptionLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.luck, redstone, CorePotions.luckLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.unluck, redstone, CorePotions.unluckLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.wither, redstone, CorePotions.witherLong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.haste, glowstone, CorePotions.hasteStrong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.resistance, glowstone, CorePotions.resistanceStrong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.absorption, glowstone, CorePotions.absorptionStrong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.luck, glowstone, CorePotions.luckStrong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.unluck, glowstone, CorePotions.unluckStrong);
        BrewerManager.addDefaultPotionRecipes(CorePotions.wither, glowstone, CorePotions.witherStrong);
        int max = 4;
        BrewerManager.addSwapPotionRecipes("leaping", max);
        BrewerManager.addSwapPotionRecipes("swiftness", max);
        BrewerManager.addSwapPotionRecipes("healing", max);
        BrewerManager.addSwapPotionRecipes("harming", max);
        BrewerManager.addSwapPotionRecipes("poison", max);
        BrewerManager.addSwapPotionRecipes("regeneration", max);
        BrewerManager.addSwapPotionRecipes("strength", max);
        BrewerManager.addSwapPotionRecipes("haste", 4);
        BrewerManager.addSwapPotionRecipes("resistance", 4);
        BrewerManager.addSwapPotionRecipes("absorption", max);
        BrewerManager.addSwapPotionRecipes("luck", max);
        BrewerManager.addSwapPotionRecipes("unluck", max);
        BrewerManager.addSwapPotionRecipes("wither", max);
        max = 3;
        BrewerManager.addSwapPotionRecipes("leaping", max, "+");
        BrewerManager.addSwapPotionRecipes("swiftness", max, "+");
        BrewerManager.addSwapPotionRecipes("poison", max, "+");
        BrewerManager.addSwapPotionRecipes("regeneration", max, "+");
        BrewerManager.addSwapPotionRecipes("strength", max, "+");
        BrewerManager.addSwapPotionRecipes("haste", max, "+");
        BrewerManager.addSwapPotionRecipes("resistance", max, "+");
        BrewerManager.addSwapPotionRecipes("absorption", max, "+");
        BrewerManager.addSwapPotionRecipes("luck", max, "+");
        BrewerManager.addSwapPotionRecipes("unluck", max, "+");
        BrewerManager.addSwapPotionRecipes("wither", max, "+");
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<List<Integer>, BrewerRecipe> entry : recipeMap.entrySet()) {
            BrewerRecipe tempRecipe = entry.getValue();
            ComparableItemStackValidatedNBT input = BrewerManager.convertInput(tempRecipe.input);
            tempMap.put(Arrays.asList(input.hashCode(), FluidHelper.getFluidHash((FluidStack)tempRecipe.inputFluid)), tempRecipe);
            tempSet.add(input);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static BrewerRecipe addRecipe(int energy, ItemStack input, FluidStack inputFluid, FluidStack outputFluid) {
        if (input.func_190926_b() || inputFluid == null || outputFluid == null || energy <= 0 || BrewerManager.recipeExists(input, inputFluid)) {
            return null;
        }
        BrewerRecipe recipe = new BrewerRecipe(input, inputFluid, outputFluid, energy);
        recipeMap.put(Arrays.asList(BrewerManager.convertInput(input).hashCode(), FluidHelper.getFluidHash((FluidStack)inputFluid)), recipe);
        validationSet.add(BrewerManager.convertInput(input));
        validationFluids.add(inputFluid.getFluid().getName());
        return recipe;
    }

    public static BrewerRecipe removeRecipe(ItemStack input, FluidStack fluid) {
        return recipeMap.remove(Arrays.asList(BrewerManager.convertInput(input).hashCode(), FluidHelper.getFluidHash((FluidStack)fluid)));
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack, oreValidator);
    }

    public static void addDefaultPotionRecipes(PotionType input, ItemStack reagent, PotionType output) {
        BrewerManager.addRecipe(2400, reagent, TFFluids.getPotion((int)750, (PotionType)input), TFFluids.getPotion((int)750, (PotionType)output));
        BrewerManager.addRecipe(2400, reagent, TFFluids.getSplashPotion((int)750, (PotionType)input), TFFluids.getSplashPotion((int)750, (PotionType)output));
        BrewerManager.addRecipe(2400, reagent, TFFluids.getLingeringPotion((int)750, (PotionType)input), TFFluids.getLingeringPotion((int)750, (PotionType)output));
        BrewerManager.addSwapPotionRecipes(input);
        BrewerManager.addSwapPotionRecipes(output);
    }

    public static void addSwapPotionRecipes(PotionType potion) {
        BrewerManager.addRecipe(2400, new ItemStack(Items.field_151016_H), TFFluids.getPotion((int)750, (PotionType)potion), TFFluids.getSplashPotion((int)750, (PotionType)potion));
        BrewerManager.addRecipe(2400, new ItemStack(Items.field_185157_bK), TFFluids.getSplashPotion((int)750, (PotionType)potion), TFFluids.getLingeringPotion((int)750, (PotionType)potion));
    }

    public static void addSwapPotionRecipes(String baseName, int maxRank) {
        BrewerManager.addSwapPotionRecipes(baseName, maxRank, "");
    }

    public static void addSwapPotionRecipes(String baseName, int maxRank, String postfix) {
        for (int i = maxRank; i > 2; --i) {
            PotionType type = BrewerManager.getPotionType(baseName, i, postfix);
            if (type == PotionTypes.field_185229_a) continue;
            BrewerManager.addSwapPotionRecipes(type);
        }
    }

    public static PotionType getPotionType(String baseName, int rank, String postfix) {
        PotionType ret;
        switch (rank) {
            case 1: {
                ret = PotionType.func_185168_a((String)baseName);
                break;
            }
            case 2: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + 2 + postfix));
                if (ret != PotionTypes.field_185229_a) break;
                ret = PotionType.func_185168_a((String)("strong_" + baseName));
                break;
            }
            default: {
                ret = PotionType.func_185168_a((String)("cofhcore:" + baseName + rank + postfix));
            }
        }
        return ret;
    }

    static {
        oreValidator.addPrefix("dust");
        oreValidator.addPrefix("gem");
    }

    public static class BrewerRecipe {
        final ItemStack input;
        final FluidStack inputFluid;
        final FluidStack outputFluid;
        final int energy;

        BrewerRecipe(ItemStack input, FluidStack inputFluid, FluidStack outputFluid, int energy) {
            this.input = input;
            this.inputFluid = inputFluid;
            this.outputFluid = outputFluid;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public FluidStack getInputFluid() {
            return this.inputFluid;
        }

        public FluidStack getOutputFluid() {
            return this.outputFluid;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

