/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidatedNBT;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ColorHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.item.ItemMorb;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.init.TFItems;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeManager {
    private static Map<ComparableItemStackValidatedNBT, CentrifugeRecipe> recipeMap = new THashMap();
    private static Map<ComparableItemStackValidatedNBT, CentrifugeRecipe> recipeMapMobs = new THashMap();
    private static OreValidator oreValidator = new OreValidator();
    public static final int DEFAULT_ENERGY = 2000;

    public static CentrifugeRecipe getRecipe(ItemStack input) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidatedNBT query = CentrifugeManager.convertInput(input);
        CentrifugeRecipe recipe = recipeMap.get(query);
        if (recipe == null) {
            query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static CentrifugeRecipe getRecipeMob(ItemStack input) {
        if (input.func_190926_b() || !input.func_77973_b().equals((Object)TEItems.itemMorb)) {
            return null;
        }
        ComparableItemStackValidatedNBT query = CentrifugeManager.convertInput(ItemMorb.getGenericMorb(input));
        return recipeMapMobs.get(query);
    }

    public static boolean recipeExists(ItemStack input) {
        return CentrifugeManager.getRecipe(input) != null;
    }

    public static boolean recipeExistsMob(ItemStack input) {
        return CentrifugeManager.getRecipeMob(input) != null;
    }

    public static CentrifugeRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new CentrifugeRecipe[0]);
    }

    public static CentrifugeRecipe[] getRecipeListMobs() {
        return recipeMapMobs.values().toArray(new CentrifugeRecipe[0]);
    }

    public static void initialize() {
        int energy = 2000;
        CentrifugeManager.addRecipe(energy, new ItemStack(Items.field_151064_bs), Arrays.asList(new ItemStack(Items.field_151123_aH), new ItemStack(Items.field_151065_br)), null);
        CentrifugeManager.addRecipe(energy, new ItemStack(Items.field_151120_aE), Collections.singletonList(new ItemStack(Items.field_151102_aT, 2)), new FluidStack(FluidRegistry.WATER, 250));
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustElectrum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustGold), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), null);
        CentrifugeManager.addRecipe(energy * 3, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustInvar, (int)3), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustIron, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBronze, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustConstantan, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNickel)), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSignalum, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidRedstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLumium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustTin, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSilver)), new FluidStack(TFFluids.fluidGlowstone, 1000));
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustEnderium, (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustLead, (int)3), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPlatinum)), new FluidStack(TFFluids.fluidEnder, 1000));
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPyrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((Item)Items.field_151065_br, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCryotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlizz, (int)2), ItemHelper.cloneStack((Item)Items.field_151126_ay), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustAerotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBlitz, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter), new ItemStack(Items.field_151137_ax)), null);
        CentrifugeManager.addRecipe(energy * 2, ItemHelper.cloneStack((ItemStack)ItemMaterial.dustPetrotheum, (int)2), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustBasalz, (int)2), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian), new ItemStack(Items.field_151137_ax)), null);
        ItemStack gravel = new ItemStack(Blocks.field_150351_n);
        ItemStack sand = new ItemStack((Block)Blocks.field_150354_m);
        for (int i = 0; i < ColorHelper.WOOL_COLOR_CONFIG.length; ++i) {
            CentrifugeManager.addRecipe(energy, new ItemStack(Blocks.field_192444_dS, 2, i), Arrays.asList(gravel, sand, new ItemStack((Item)TFItems.itemDye, 1, 15 - i)), Arrays.asList(100, 100, 10), null);
        }
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.getOre((String)"dustBrass", (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemHelper.getOre((String)"dustZinc")), null);
        CentrifugeManager.addRecipe(energy * 4, ItemHelper.getOre((String)"dustCupronickel", (int)4), Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.dustCopper, (int)3), ItemMaterial.dustNickel), null);
        CentrifugeManager.loadMobs();
    }

    public static void loadMobs() {
        CentrifugeManager.addDefaultMobRecipe("minecraft:bat", Collections.singletonList(new ItemStack(Items.field_151116_aA)), Collections.singletonList(5), 0);
        CentrifugeManager.addDefaultMobRecipe("minecraft:chicken", Arrays.asList(new ItemStack(Items.field_151008_G, 2), new ItemStack(Items.field_151076_bf)), Arrays.asList(50, 100), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:cow", Arrays.asList(new ItemStack(Items.field_151116_aA, 2), new ItemStack(Items.field_151082_bd, 3)), Arrays.asList(50, 70), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:donkey", Collections.singletonList(new ItemStack(Items.field_151116_aA, 2)), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:horse", Collections.singletonList(new ItemStack(Items.field_151116_aA, 2)), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:llama", Collections.singletonList(new ItemStack(Items.field_151116_aA, 2)), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:mooshroom", Arrays.asList(new ItemStack(Items.field_151116_aA, 2), new ItemStack(Items.field_151082_bd, 3)), Arrays.asList(50, 70), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:ocelot", Collections.emptyList(), Collections.emptyList(), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:parrot", Collections.singletonList(new ItemStack(Items.field_151008_G, 2)), Collections.singletonList(80), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:pig", Collections.singletonList(new ItemStack(Items.field_151147_al, 3)), Collections.singletonList(70), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:polar_bear", Arrays.asList(new ItemStack(Items.field_151115_aP, 2), new ItemStack(Items.field_151115_aP, 2, 1)), Arrays.asList(80, 50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:rabbit", Arrays.asList(new ItemStack(Items.field_179555_bs), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179556_br)), Arrays.asList(50, 50, 10), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:sheep", Collections.singletonList(new ItemStack(Items.field_179561_bm, 2)), Collections.singletonList(80), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:skeleton_horse", Collections.singletonList(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:squid", Collections.singletonList(new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.BLACK.func_176767_b())), Collections.singletonList(70), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:wolf", Collections.emptyList(), Collections.emptyList(), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:zombie_horse", Collections.singletonList(new ItemStack(Items.field_151078_bh, 2)), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:blaze", Arrays.asList(new ItemStack(Items.field_151072_bj), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur)), Arrays.asList(50, 25), 10);
        CentrifugeManager.addDefaultMobRecipe("minecraft:cave_spider", Arrays.asList(new ItemStack(Items.field_151007_F, 2), new ItemStack(Items.field_151070_bp)), Arrays.asList(50, 25), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:creeper", Collections.singletonList(new ItemStack(Items.field_151016_H, 2)), Collections.singletonList(50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:elder_guardian", Arrays.asList(new ItemStack(Items.field_179562_cC, 2), new ItemStack(Items.field_179563_cD)), Arrays.asList(50, 50), 10);
        CentrifugeManager.addDefaultMobRecipe("minecraft:enderman", Collections.singletonList(new ItemStack(Items.field_151079_bi)), Collections.singletonList(50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:endermite", Collections.emptyList(), Collections.emptyList(), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:evocation_illager", Arrays.asList(new ItemStack(Items.field_190929_cY), new ItemStack(Items.field_151166_bC)), Arrays.asList(100, 50), 10);
        CentrifugeManager.addDefaultMobRecipe("minecraft:ghast", Arrays.asList(new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151016_H)), Arrays.asList(50, 50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:guardian", Arrays.asList(new ItemStack(Items.field_179562_cC, 2), new ItemStack(Items.field_179563_cD)), Arrays.asList(50, 50), 10);
        CentrifugeManager.addDefaultMobRecipe("minecraft:husk", Arrays.asList(new ItemStack(Items.field_151078_bh, 2), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151174_bG)), Arrays.asList(50, 2, 2), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:magma_cube", Arrays.asList(new ItemStack(Items.field_151064_bs), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustSulfur)), Arrays.asList(50, 25), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:shulker", Collections.singletonList(new ItemStack(Items.field_190930_cZ)), Collections.singletonList(50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:silverfish", Collections.emptyList(), Collections.emptyList(), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:skeleton", Arrays.asList(new ItemStack(Items.field_151032_g, 2), new ItemStack(Items.field_151103_aS, 2)), Arrays.asList(50, 50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:slime", Collections.singletonList(new ItemStack(Items.field_151123_aH, 2)), Collections.singletonList(50), 2);
        CentrifugeManager.addDefaultMobRecipe("minecraft:spider", Arrays.asList(new ItemStack(Items.field_151007_F, 2), new ItemStack(Items.field_151070_bp)), Arrays.asList(50, 25), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:stray", Arrays.asList(new ItemStack(Items.field_151032_g, 2), new ItemStack(Items.field_151103_aS, 2)), Arrays.asList(50, 50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:vex", Collections.emptyList(), Collections.emptyList(), 3);
        CentrifugeManager.addDefaultMobRecipe("minecraft:villager", Collections.singletonList(new ItemStack(Items.field_151166_bC)), Collections.singletonList(2), 0);
        CentrifugeManager.addDefaultMobRecipe("minecraft:vindication_illager", Collections.singletonList(new ItemStack(Items.field_151166_bC)), Collections.singletonList(50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:witch", Arrays.asList(new ItemStack(Items.field_151114_aO, 2), new ItemStack(Items.field_151016_H, 2), new ItemStack(Items.field_151137_ax, 2)), Arrays.asList(40, 40, 40), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:wither_skeleton", Arrays.asList(new ItemStack(Items.field_151044_h, 1), new ItemStack(Items.field_151103_aS, 2)), Arrays.asList(25, 50), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:zombie", Arrays.asList(new ItemStack(Items.field_151078_bh, 2), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151174_bG)), Arrays.asList(50, 2, 2), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:zombie_pigman", Arrays.asList(new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151074_bl), new ItemStack(Items.field_151043_k)), Arrays.asList(50, 50, 2), 5);
        CentrifugeManager.addDefaultMobRecipe("minecraft:zombie_villager", Arrays.asList(new ItemStack(Items.field_151078_bh, 2), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151174_bG)), Arrays.asList(50, 2, 2), 5);
        CentrifugeManager.addDefaultMobRecipe("thermalfoundation:blizz", Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.rodBlizz), new ItemStack(Items.field_151126_ay, 4)), Arrays.asList(50, 25), 10);
        CentrifugeManager.addDefaultMobRecipe("thermalfoundation:blitz", Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.rodBlitz), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustNiter, (int)2)), Arrays.asList(50, 25), 10);
        CentrifugeManager.addDefaultMobRecipe("thermalfoundation:basalz", Arrays.asList(ItemHelper.cloneStack((ItemStack)ItemMaterial.rodBasalz), ItemHelper.cloneStack((ItemStack)ItemMaterial.dustObsidian, (int)2)), Arrays.asList(50, 25), 10);
    }

    public static void refresh() {
        CentrifugeRecipe tempRecipe;
        THashMap tempMap = new THashMap(recipeMap.size());
        THashMap tempMapMobs = new THashMap(recipeMapMobs.size());
        for (Map.Entry<ComparableItemStackValidatedNBT, CentrifugeRecipe> entry : recipeMap.entrySet()) {
            tempRecipe = entry.getValue();
            tempMap.put(CentrifugeManager.convertInput(tempRecipe.input), tempRecipe);
        }
        for (Map.Entry<ComparableItemStackValidatedNBT, CentrifugeRecipe> entry : recipeMapMobs.entrySet()) {
            tempRecipe = entry.getValue();
            tempMapMobs.put(CentrifugeManager.convertInput(tempRecipe.input), tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
        recipeMapMobs.clear();
        recipeMapMobs = tempMapMobs;
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExists(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, chance, fluid, energy);
        recipeMap.put(CentrifugeManager.convertInput(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe addRecipe(int energy, ItemStack input, List<ItemStack> output, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExists(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, null, fluid, energy);
        recipeMap.put(CentrifugeManager.convertInput(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe addRecipeMob(int energy, ItemStack input, List<ItemStack> output, List<Integer> chance, FluidStack fluid) {
        if (input.func_190926_b() || output.isEmpty() && fluid == null || output.size() > 4 || energy <= 0 || CentrifugeManager.recipeExistsMob(input)) {
            return null;
        }
        CentrifugeRecipe recipe = new CentrifugeRecipe(input, output, chance, fluid, energy);
        recipeMapMobs.put(CentrifugeManager.convertInput(input), recipe);
        return recipe;
    }

    public static CentrifugeRecipe removeRecipe(ItemStack input) {
        return recipeMap.remove(CentrifugeManager.convertInput(input));
    }

    public static CentrifugeRecipe removeRecipeMob(ItemStack input) {
        return recipeMapMobs.remove(CentrifugeManager.convertInput(input));
    }

    public static ComparableItemStackValidatedNBT convertInput(ItemStack stack) {
        return new ComparableItemStackValidatedNBT(stack, oreValidator);
    }

    public static void addDefaultMobRecipe(String entityId, List<ItemStack> output, List<Integer> chance, int xp) {
        if (!ItemMorb.validMobs.contains(entityId)) {
            return;
        }
        ArrayList<ItemStack> outputStandard = new ArrayList<ItemStack>(output);
        ArrayList<ItemStack> outputReusable = new ArrayList<ItemStack>(output);
        ArrayList<Integer> chanceStandard = new ArrayList<Integer>(chance);
        ArrayList<Integer> chanceReusable = new ArrayList<Integer>(chance);
        outputStandard.add(ItemHelper.cloneStack((ItemStack)ItemMorb.morbStandard));
        outputReusable.add(ItemHelper.cloneStack((ItemStack)ItemMorb.morbReusable));
        chanceStandard.add(20);
        chanceReusable.add(80);
        CentrifugeManager.addRecipeMob(4000, ItemMorb.setTag(ItemHelper.cloneStack((ItemStack)ItemMorb.morbStandard), entityId, false), outputStandard, chanceStandard, new FluidStack(TFFluids.fluidExperience, xp * 20));
        CentrifugeManager.addRecipeMob(4000, ItemMorb.setTag(ItemHelper.cloneStack((ItemStack)ItemMorb.morbReusable), entityId, false), outputReusable, chanceReusable, new FluidStack(TFFluids.fluidExperience, xp * 20));
    }

    static {
        oreValidator.addPrefix("dust");
    }

    public static class CentrifugeRecipe {
        protected ItemStack input;
        protected List<ItemStack> output;
        protected List<Integer> chance;
        protected FluidStack fluid;
        protected int energy;

        CentrifugeRecipe(ItemStack input, @Nullable List<ItemStack> output, @Nullable List<Integer> chance, @Nullable FluidStack fluid, int energy) {
            this.input = input;
            this.output = new ArrayList<ItemStack>();
            if (output != null) {
                this.output.addAll(output);
            }
            this.chance = new ArrayList<Integer>();
            if (chance != null) {
                this.chance.addAll(chance);
            } else {
                for (int i = 0; i < this.output.size(); ++i) {
                    this.chance.add(100);
                }
            }
            this.fluid = fluid;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public List<ItemStack> getOutput() {
            return this.output;
        }

        public List<Integer> getChance() {
            return this.chance;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

