/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.inventory.ComparableItemStackValidated;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CompactorManager {
    private static Map<ComparableItemStackValidated, CompactorRecipe> recipeMapAll = new THashMap();
    private static Map<ComparableItemStackValidated, CompactorRecipe> recipeMapPlate = new THashMap();
    private static Map<ComparableItemStackValidated, CompactorRecipe> recipeMapCoin = new THashMap();
    private static Map<ComparableItemStackValidated, CompactorRecipe> recipeMapGear = new THashMap();
    private static Set<ComparableItemStackValidated> validationSet = new THashSet();
    public static final int DEFAULT_ENERGY = 4000;

    public static CompactorRecipe getRecipe(ItemStack input, Mode mode) {
        if (input.func_190926_b()) {
            return null;
        }
        ComparableItemStackValidated query = new ComparableItemStackValidated(input);
        CompactorRecipe recipe = null;
        switch (mode) {
            case PLATE: {
                recipe = recipeMapPlate.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPlate.get(query);
                break;
            }
            case COIN: {
                recipe = recipeMapCoin.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapCoin.get(query);
                break;
            }
            case GEAR: {
                recipe = recipeMapGear.get(query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapGear.get(query);
            }
        }
        if (recipe == null) {
            return recipeMapAll.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, Mode mode) {
        return CompactorManager.getRecipe(input, mode) != null;
    }

    public static CompactorRecipe[] getRecipeList(Mode mode) {
        switch (mode) {
            case PLATE: {
                return recipeMapPlate.values().toArray(new CompactorRecipe[0]);
            }
            case COIN: {
                return recipeMapCoin.values().toArray(new CompactorRecipe[0]);
            }
            case GEAR: {
                return recipeMapGear.values().toArray(new CompactorRecipe[0]);
            }
        }
        return recipeMapAll.values().toArray(new CompactorRecipe[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        return !input.func_190926_b() && validationSet.contains(new ComparableItemStackValidated(input));
    }

    public static void initialize() {
        String[] oreNames;
        for (String oreName : oreNames = OreDictionary.getOreNames()) {
            String oreType;
            if (oreName.startsWith("plate")) {
                oreType = oreName.substring(5, oreName.length());
                CompactorManager.addDefaultPlateRecipe(oreType);
                continue;
            }
            if (oreName.startsWith("gear")) {
                oreType = oreName.substring(4, oreName.length());
                CompactorManager.addDefaultGearRecipe(oreType);
                continue;
            }
            if (!oreName.startsWith("coin")) continue;
            oreType = oreName.substring(4, oreName.length());
            CompactorManager.addDefaultCoinRecipe(oreType);
        }
    }

    public static void refresh() {
        ComparableItemStackValidated input;
        CompactorRecipe tempRecipe;
        THashMap tempAll = new THashMap(recipeMapAll.size());
        THashMap tempPlate = new THashMap(recipeMapPlate.size());
        THashMap tempMint = new THashMap(recipeMapCoin.size());
        THashMap tempGear = new THashMap(recipeMapGear.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<ComparableItemStackValidated, CompactorRecipe> entry : recipeMapAll.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempPlate.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidated, CompactorRecipe> entry : recipeMapPlate.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempPlate.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidated, CompactorRecipe> entry : recipeMapCoin.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempMint.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackValidated, CompactorRecipe> entry : recipeMapGear.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackValidated(tempRecipe.input);
            tempGear.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapAll.clear();
        recipeMapPlate.clear();
        recipeMapCoin.clear();
        recipeMapGear.clear();
        recipeMapAll = tempAll;
        recipeMapPlate = tempPlate;
        recipeMapCoin = tempMint;
        recipeMapGear = tempGear;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static CompactorRecipe addRecipe(int energy, ItemStack input, ItemStack output, Mode mode) {
        if (input.func_190926_b() || output.func_190926_b() || energy <= 0 || CompactorManager.recipeExists(input, mode)) {
            return null;
        }
        CompactorRecipe recipe = new CompactorRecipe(input, output, energy);
        switch (mode) {
            case ALL: {
                recipeMapAll.put(new ComparableItemStackValidated(input), recipe);
                break;
            }
            case PLATE: {
                recipeMapPlate.put(new ComparableItemStackValidated(input), recipe);
                break;
            }
            case COIN: {
                recipeMapCoin.put(new ComparableItemStackValidated(input), recipe);
                break;
            }
            case GEAR: {
                recipeMapGear.put(new ComparableItemStackValidated(input), recipe);
            }
        }
        validationSet.add(new ComparableItemStackValidated(input));
        return recipe;
    }

    public static CompactorRecipe removeRecipe(ItemStack input, Mode mode) {
        switch (mode) {
            case ALL: {
                return recipeMapAll.remove(new ComparableItemStackValidated(input));
            }
            case PLATE: {
                return recipeMapPlate.remove(new ComparableItemStackValidated(input));
            }
            case COIN: {
                return recipeMapCoin.remove(new ComparableItemStackValidated(input));
            }
        }
        return recipeMapGear.remove(new ComparableItemStackValidated(input));
    }

    public static ComparableItemStackValidated convertInput(ItemStack stack) {
        return new ComparableItemStackValidated(stack);
    }

    private static void addDefaultPlateRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String plateName = "plate" + StringHelper.titleCase((String)oreType);
        if (!ItemHelper.oreNameExists((String)plateName)) {
            return;
        }
        CompactorManager.addDefaultPlateRecipe(oreType, ItemHelper.getOre((String)plateName));
    }

    private static void addDefaultPlateRecipe(String oreType, ItemStack plate) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        CompactorManager.addRecipe(4000, ItemHelper.getOre((String)("ingot" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PLATE);
        CompactorManager.addRecipe(4000, ItemHelper.getOre((String)("gem" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)plate, (int)1), Mode.PLATE);
    }

    private static void addDefaultGearRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String gearName = "gear" + StringHelper.titleCase((String)oreType);
        if (!ItemHelper.oreNameExists((String)gearName)) {
            return;
        }
        CompactorManager.addDefaultGearRecipe(oreType, ItemHelper.getOre((String)gearName));
    }

    private static void addDefaultGearRecipe(String oreType, ItemStack gear) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        CompactorManager.addRecipe(4000, ItemHelper.getOre((String)("ingot" + StringHelper.titleCase((String)oreType)), (int)4), ItemHelper.cloneStack((ItemStack)gear, (int)1), Mode.GEAR);
        CompactorManager.addRecipe(4000, ItemHelper.getOre((String)("gem" + StringHelper.titleCase((String)oreType)), (int)4), ItemHelper.cloneStack((ItemStack)gear, (int)1), Mode.GEAR);
    }

    private static void addDefaultCoinRecipe(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        String coinName = "coin" + StringHelper.titleCase((String)oreType);
        if (!ItemHelper.oreNameExists((String)coinName)) {
            return;
        }
        CompactorManager.addDefaultCoinRecipe(oreType, ItemHelper.getOre((String)coinName));
    }

    private static void addDefaultCoinRecipe(String oreType, ItemStack coin) {
        if (oreType == null || oreType.isEmpty()) {
            return;
        }
        CompactorManager.addRecipe(4000, ItemHelper.getOre((String)("ingot" + StringHelper.titleCase((String)oreType))), ItemHelper.cloneStack((ItemStack)coin, (int)3), Mode.COIN);
    }

    public static enum Mode {
        ALL,
        PLATE,
        COIN,
        GEAR;

    }

    public static class CompactorRecipe {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        CompactorRecipe(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

