/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PrecipitatorManager {
    private static Map<ItemWrapper, PrecipitatorRecipe> recipeMap = new THashMap();
    private static List<ItemStack> outputList = new ArrayList<ItemStack>();
    public static final int DEFAULT_ENERGY = 800;

    public static PrecipitatorRecipe getRecipe(ItemStack input) {
        return input.func_190926_b() ? null : recipeMap.get(new ItemWrapper(input));
    }

    public static boolean recipeExists(ItemStack input) {
        return PrecipitatorManager.getRecipe(input) != null;
    }

    public static ItemStack getOutput(int index) {
        return outputList.get(index);
    }

    public static int getOutputListSize() {
        return outputList.size();
    }

    public static int getIndex(ItemStack output) {
        for (int i = 0; i < outputList.size(); ++i) {
            if (!ItemHelper.itemsIdentical((ItemStack)output, (ItemStack)outputList.get(i))) continue;
            return i;
        }
        return 0;
    }

    public static PrecipitatorRecipe[] getRecipeList() {
        return recipeMap.values().toArray(new PrecipitatorRecipe[0]);
    }

    public static void initialize() {
        PrecipitatorManager.addRecipe(800, new ItemStack(Items.field_151126_ay, 4, 0), new FluidStack(FluidRegistry.WATER, 500));
        PrecipitatorManager.addRecipe(800, new ItemStack(Blocks.field_150433_aE), new FluidStack(FluidRegistry.WATER, 500));
        PrecipitatorManager.addRecipe(1600, new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.WATER, 1000));
        PrecipitatorManager.addRecipe(800, new ItemStack(Blocks.field_150431_aC, 2), new FluidStack(FluidRegistry.WATER, 500));
        PrecipitatorManager.addRecipe(1600, new ItemStack(Blocks.field_150403_cj), new FluidStack(FluidRegistry.WATER, 2000));
        PrecipitatorManager.loadRecipes();
    }

    public static void loadRecipes() {
    }

    public static void refresh() {
        THashMap tempMap = new THashMap(recipeMap.size());
        for (Map.Entry<ItemWrapper, PrecipitatorRecipe> entry : recipeMap.entrySet()) {
            PrecipitatorRecipe tempRecipe = entry.getValue();
            ItemWrapper output = new ItemWrapper(tempRecipe.output);
            tempMap.put(output, tempRecipe);
        }
        recipeMap.clear();
        recipeMap = tempMap;
    }

    public static PrecipitatorRecipe addRecipe(int energy, ItemStack output, FluidStack input) {
        if (output.func_190926_b() || input == null || energy <= 0 || PrecipitatorManager.recipeExists(output)) {
            return null;
        }
        PrecipitatorRecipe recipe = new PrecipitatorRecipe(output, input, energy);
        recipeMap.put(new ItemWrapper(output), recipe);
        outputList.add(output);
        return recipe;
    }

    public static class PrecipitatorRecipe {
        final ItemStack output;
        final FluidStack input;
        final int energy;

        PrecipitatorRecipe(ItemStack output, FluidStack input, int energy) {
            this.output = output;
            this.input = input;
            this.energy = energy;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public FluidStack getInput() {
            return this.input;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

