/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers;

import cofh.core.init.CoreProps;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.parsers.ConstantParser;
import cofh.thermalexpansion.util.parsers.IContentParser;
import cofh.thermalexpansion.util.parsers.OreDictParser;
import cofh.thermalexpansion.util.parsers.dynamo.CompressionParser;
import cofh.thermalexpansion.util.parsers.dynamo.EnervationParser;
import cofh.thermalexpansion.util.parsers.dynamo.MagmaticParser;
import cofh.thermalexpansion.util.parsers.dynamo.NumismaticParser;
import cofh.thermalexpansion.util.parsers.dynamo.ReactantParser;
import cofh.thermalexpansion.util.parsers.dynamo.SteamParser;
import cofh.thermalexpansion.util.parsers.machine.ChargerParser;
import cofh.thermalexpansion.util.parsers.machine.CompactorParser;
import cofh.thermalexpansion.util.parsers.machine.CrucibleParser;
import cofh.thermalexpansion.util.parsers.machine.FurnaceParser;
import cofh.thermalexpansion.util.parsers.machine.PulverizerParser;
import cofh.thermalexpansion.util.parsers.machine.RefineryParser;
import cofh.thermalexpansion.util.parsers.machine.SawmillParser;
import cofh.thermalexpansion.util.parsers.machine.SmelterParser;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.map.hash.THashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ContentParser {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static File contentFolder;
    private static THashMap<String, IContentParser> contentParsers;

    private ContentParser() {
    }

    public static void initialize() {
        contentFolder = new File(CoreProps.configDir, "/cofh/thermalexpansion/content/");
        if (!contentFolder.exists()) {
            try {
                contentFolder.mkdir();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        contentParsers.put((Object)"oredict", (Object)new OreDictParser());
        contentParsers.put((Object)"constants", (Object)new ConstantParser());
        contentParsers.put((Object)"furnace", (Object)new FurnaceParser());
        contentParsers.put((Object)"pulverizer", (Object)new PulverizerParser());
        contentParsers.put((Object)"sawmill", (Object)new SawmillParser());
        contentParsers.put((Object)"smelter", (Object)new SmelterParser());
        contentParsers.put((Object)"compactor", (Object)new CompactorParser());
        contentParsers.put((Object)"crucible", (Object)new CrucibleParser());
        contentParsers.put((Object)"refinery", (Object)new RefineryParser());
        contentParsers.put((Object)"charger", (Object)new ChargerParser());
        contentParsers.put((Object)"dynamo_steam", (Object)new SteamParser());
        contentParsers.put((Object)"dynamo_magmatic", (Object)new MagmaticParser());
        contentParsers.put((Object)"dynamo_compression", (Object)new CompressionParser());
        contentParsers.put((Object)"dynamo_reactant", (Object)new ReactantParser());
        contentParsers.put((Object)"dynamo_enervation", (Object)new EnervationParser());
        contentParsers.put((Object)"dynamo_numismatic", (Object)new NumismaticParser());
    }

    private static void addFiles(ArrayList<File> list, File folder) {
        File[] fList = folder.listFiles((file, name) -> name != null && (name.toLowerCase(Locale.US).endsWith(".json") || new File(file, name).isDirectory()));
        if (fList == null || fList.length <= 0) {
            ThermalExpansion.LOG.info("There are no content files present in " + folder + ".");
            return;
        }
        ThermalExpansion.LOG.info(fList.length + " content files present in " + folder + "/.");
        list.addAll(Arrays.asList(fList));
    }

    public static void parseFiles() {
        ModContainer mod = FMLCommonHandler.instance().findContainerFor((Object)"thermalexpansion");
        ContentParser.parseConstants(mod);
        ContentParser.parseRecipes(mod);
    }

    public static void parseConstants(ModContainer mod) {
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/content/"), null, (root, file) -> {
            String fileName = file.getFileName().toString();
            if (!"json".equals(FilenameUtils.getExtension((String)fileName)) || !fileName.startsWith("_")) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
            }
            catch (IOException e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)false, (boolean)false);
    }

    public static void parseRecipes(ModContainer mod) {
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/content/"), null, (root, file) -> {
            String fileName = file.getFileName().toString();
            if (!"json".equals(FilenameUtils.getExtension((String)fileName)) || fileName.startsWith("_")) {
                return true;
            }
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                for (Map.Entry contentEntry : json.entrySet()) {
                    if (ContentParser.parseEntry((String)contentEntry.getKey(), (JsonElement)contentEntry.getValue())) {
                        ThermalExpansion.LOG.debug("Content entry added from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\"");
                        continue;
                    }
                    ThermalExpansion.LOG.error("Error parsing entry from file " + fileName + ": \"" + (String)contentEntry.getKey() + "\" > Please make sure the entry is a valid JSON Array.");
                }
            }
            catch (IOException e) {
                ThermalExpansion.LOG.error("Error parsing content file " + fileName + "!", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)false, (boolean)false);
    }

    private static boolean parseEntry(String type, JsonElement content) {
        if (contentParsers.containsKey((Object)type)) {
            return ((IContentParser)contentParsers.get((Object)type)).parseContent(content);
        }
        return false;
    }

    static {
        contentParsers = new THashMap();
    }
}

