/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RefineryParser
extends BaseParser {
    public static final String FOSSIL = "fossil";
    public static final String FOSSILFUEL = "fossil-fuel";
    public static final String FOSSIL_FUEL = "fossil_fuel";
    int defaultEnergy = 5000;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            String type;
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            ItemStack output2 = ItemStack.field_190927_a;
            int energy = this.defaultEnergy;
            int chance = 100;
            FluidStack input = RefineryParser.parseFluidStack(content.get("input"));
            FluidStack output = RefineryParser.parseFluidStack(content.get("output"));
            if (input == null || output == null) {
                ++this.errorCount;
                continue;
            }
            if (content.has("output2")) {
                JsonElement outputElement = content.get("output2");
                output2 = RefineryParser.parseItemStack(outputElement);
                chance = RefineryParser.getChance(outputElement);
            }
            if (content.has("type") && (FOSSIL.equals(type = content.get("type").getAsString()) || FOSSILFUEL.equals(type) || FOSSIL_FUEL.equals(type))) {
                RefineryManager.addFossilFuel(input.getFluid());
            }
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (RefineryManager.addRecipe(energy, input, output, output2, chance) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

