/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;

public class SmelterParser
extends BaseParser {
    int defaultEnergy = 4000;

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            ItemStack output2 = ItemStack.field_190927_a;
            int energy = this.defaultEnergy;
            int chance = 100;
            ItemStack input = SmelterParser.parseItemStack(content.get("input"));
            ItemStack input2 = SmelterParser.parseItemStack(content.get("input2"));
            ItemStack output = SmelterParser.parseItemStack(content.get("output"));
            if (content.has("output2")) {
                JsonElement outputElement = content.get("output2");
                output2 = SmelterParser.parseItemStack(outputElement);
                chance = SmelterParser.getChance(outputElement);
            }
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (SmelterManager.addRecipe(energy, input, input2, output, output2, chance) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }
}

