/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.immersion.stacks;

import akka.japi.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.render.model.IStateParticleBakedModel;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.immersion.stacks.BlockStacks;
import pl.asie.charset.module.immersion.stacks.StackShapes;
import pl.asie.charset.module.immersion.stacks.TileEntityStacks;

public class RenderTileEntityStacks
implements IBakedModel,
IStateParticleBakedModel {
    private static final int[][][] QUAD_ORDERS = new int[][][]{new int[][]{{0, 4, 5, 1}, {1, 5, 6, 2}, {2, 6, 7, 3}, {3, 7, 4, 0}, {0, 1, 2, 3}, {4, 7, 6, 5}}, new int[][]{{0, 1, 5, 4}, {1, 2, 6, 5}, {2, 3, 7, 6}, {3, 0, 4, 7}, {0, 3, 2, 1}, {4, 5, 6, 7}}};
    private static final EnumFacing[][] QUAD_FACES;
    private static final int[][] QUAD_UVS;

    public ModelTransformer.IVertexTransformer createTransformer(int i, ItemStack stack, long rand) {
        int c = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
        AxisAlignedBB box = StackShapes.getIngotBox(i, stack);
        StackShapes.FlatRenderMode renderMode = StackShapes.getRenderMode(stack);
        float[] color = new float[]{MathHelper.func_76131_a((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)(c >> 8 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)(c & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), 1.0f};
        float offsetX = ((float)((rand += (long)(i * 17237)) & 7L) - 3.5f) / 256.0f;
        float offsetZ = ((float)(rand >> 3 & 7L) - 3.5f) / 256.0f;
        float rotation = ((float)(rand >> 6 & 0xFL) - 7.5f) * 0.025f;
        return (quad, element, data) -> {
            switch (element.func_177375_c()) {
                case POSITION: {
                    float x = data[1] * 0.5f - 0.25f;
                    float y = data[2] - 0.5f;
                    float z = data[0] * 0.5f - 0.25f;
                    float xp = x;
                    float zp = z;
                    switch (renderMode) {
                        case OFFSET_ROTATE: {
                            x = zp * MathHelper.func_76126_a((float)rotation) + xp * MathHelper.func_76134_b((float)rotation);
                            z = zp * MathHelper.func_76134_b((float)rotation) - xp * MathHelper.func_76126_a((float)rotation);
                        }
                        case OFFSET: {
                            x += offsetX;
                            z += offsetZ;
                            break;
                        }
                        case ROTATE: {
                            x = zp * MathHelper.func_76126_a((float)rotation) + xp * MathHelper.func_76134_b((float)rotation);
                            z = zp * MathHelper.func_76134_b((float)rotation) - xp * MathHelper.func_76126_a((float)rotation);
                        }
                    }
                    return new float[]{x + 0.25f + (float)box.field_72340_a, y + 0.03125f + (float)box.field_72338_b, z + 0.25f + (float)box.field_72339_c, data[3]};
                }
                case NORMAL: {
                    return new float[]{data[1], data[2], data[0], data[3]};
                }
                case COLOR: {
                    return new float[]{data[0] * color[0], data[1] * color[1], data[2] * color[2], data[3] * color[3]};
                }
            }
            return data;
        };
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null || !(state instanceof IExtendedBlockState)) {
            return Collections.emptyList();
        }
        TileEntityStacks stacks = (TileEntityStacks)((Object)((IExtendedBlockState)state).getValue(BlockStacks.PROPERTY_TILE));
        if (stacks == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
        for (int i = 0; i < 64; ++i) {
            ItemStack stack = stacks.stacks[i];
            if (stack == null) continue;
            if (StackShapes.isIngot(stack)) {
                int c;
                Function getter;
                ItemMaterial blockMaterial;
                Vec3d[] vecs = StackShapes.INGOT_POSITIONS[i];
                ItemMaterial material = ItemMaterialRegistry.INSTANCE.getMaterialIfPresent(stack);
                ItemMaterial itemMaterial = blockMaterial = material != null ? material.getRelated("block") : null;
                if (blockMaterial == null) {
                    getter = f -> RenderUtils.getItemSprite((ItemStack)new ItemStack(Blocks.field_150339_S), (EnumFacing)f);
                    c = ColorLookupHandler.INSTANCE.getColor(stack, RenderUtils.AveragingMode.FULL) | 0xFF000000;
                } else {
                    getter = f -> RenderUtils.getItemSprite((ItemStack)blockMaterial.getStack(), (EnumFacing)f);
                    c = Minecraft.func_71410_x().getItemColors().func_186728_a(blockMaterial.getStack(), 0);
                }
                float[] color = new float[]{MathHelper.func_76131_a((float)((float)(c >> 16 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)(c >> 8 & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)(c & 0xFF) / 255.0f), (float)0.0f, (float)1.0f), 1.0f};
                int j = 0;
                int yOff = i >> 3 & 1;
                for (int[] vecOrder : QUAD_ORDERS[yOff]) {
                    int uv_offset;
                    TextureAtlasSprite sprite;
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
                    EnumFacing face = QUAD_FACES[yOff][j];
                    try {
                        sprite = (TextureAtlasSprite)getter.apply((Object)face);
                    }
                    catch (Exception e) {
                        try {
                            sprite = (TextureAtlasSprite)getter.apply(null);
                        }
                        catch (Exception ee) {
                            throw new RuntimeException(ee);
                        }
                    }
                    builder.setTexture(sprite);
                    builder.setApplyDiffuseLighting(this.func_177555_b());
                    builder.setContractUVs(false);
                    builder.setQuadOrientation(face);
                    int n = uv_offset = j < 4 ? 1 : 0;
                    if (yOff == 1) {
                        uv_offset = 1 - uv_offset;
                    }
                    for (int k = 0; k < vecOrder.length; ++k) {
                        Vec3d vec = vecs[vecOrder[k]];
                        int[] uv = QUAD_UVS[k + uv_offset & 3];
                        block13: for (int e = 0; e < builder.getVertexFormat().func_177345_h(); ++e) {
                            VertexFormatElement el = builder.getVertexFormat().func_177348_c(e);
                            switch (el.func_177375_c()) {
                                case POSITION: {
                                    builder.put(e, new float[]{(float)vec.field_72450_a / 16.0f, (float)vec.field_72448_b / 16.0f, (float)vec.field_72449_c / 16.0f, 1.0f});
                                    continue block13;
                                }
                                case COLOR: {
                                    builder.put(e, color);
                                    continue block13;
                                }
                                case NORMAL: {
                                    builder.put(e, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e(), 0.0f});
                                    continue block13;
                                }
                                case UV: {
                                    float u = sprite.func_94214_a((double)uv[0]);
                                    float v = sprite.func_94207_b((double)uv[1]);
                                    builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                                    continue block13;
                                }
                                default: {
                                    builder.put(e, new float[0]);
                                }
                            }
                        }
                    }
                    list.add((BakedQuad)builder.build());
                    ++j;
                }
                continue;
            }
            if (!StackShapes.isFlatPlaced(stack)) continue;
            IBakedModel model = RenderUtils.getItemModel((ItemStack)stack, (World)stacks.func_145831_w(), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
            ModelTransformer.IVertexTransformer transformer = this.createTransformer(i, stack, rand);
            for (BakedQuad quad : model.func_188616_a(state, null, 0L)) {
                list.add(ModelTransformer.transform((BakedQuad)quad, (ModelTransformer.IVertexTransformer)transformer));
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                for (BakedQuad quad : model.func_188616_a(state, facing, 0L)) {
                    list.add(ModelTransformer.transform((BakedQuad)quad, (ModelTransformer.IVertexTransformer)transformer));
                }
            }
        }
        return list;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return (TextureAtlasSprite)ModelLoader.defaultTextureGetter().apply(TextureMap.field_174945_f);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public TextureAtlasSprite getParticleTexture(IBlockState state, @Nullable EnumFacing facing) {
        TextureAtlasSprite sprite = null;
        TileEntityStacks stacks = (TileEntityStacks)((Object)((IExtendedBlockState)state).getValue(BlockStacks.PROPERTY_TILE));
        if (stacks != null) {
            for (int i = 63; i >= 0; --i) {
                ItemStack stack = stacks.stacks[i];
                if (stack == null || stack.func_190926_b()) continue;
                sprite = RenderUtils.getItemSprite((ItemStack)stack);
                break;
            }
        }
        return sprite != null ? sprite : this.func_177554_e();
    }

    static {
        QUAD_UVS = new int[][]{{0, 16}, {16, 16}, {16, 0}, {0, 0}};
        QUAD_FACES = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.UP}, {EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.UP}};
    }
}

