/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.builder;

import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.GenericRFToolsBlock;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderContainer;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderTileEntity;
import mcjty.rftoolsdim.blocks.builder.GuiDimensionBuilder;
import mcjty.rftoolsdim.theoneprobe.TheOneProbeSupport;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class DimensionBuilderBlock
extends GenericRFToolsBlock<DimensionBuilderTileEntity, DimensionBuilderContainer>
implements Infusable {
    public static final PropertyEnum<OperationType> OPERATIONTYPE = PropertyEnum.func_177709_a((String)"operationtype", OperationType.class);

    public boolean needsRedstoneCheck() {
        return true;
    }

    public DimensionBuilderBlock(boolean creative) {
        super(Material.field_151573_f, DimensionBuilderTileEntity.class, DimensionBuilderContainer.class, "dimension_builder", true);
        this.setCreative(creative);
    }

    public int getGuiID() {
        return RFToolsDim.GUI_DIMENSION_BUILDER;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<GuiDimensionBuilder> getGuiClass() {
        return GuiDimensionBuilder.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This builds a dimension and powers it when");
            list.add(TextFormatting.WHITE + "the dimension is ready.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(TextFormatting.YELLOW + "faster dimension creation speed.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        DimensionBuilderTileEntity tileEntity;
        NBTTagCompound tagCompound;
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DimensionBuilderTileEntity && (tagCompound = (tileEntity = (DimensionBuilderTileEntity)te).hasTab()) != null) {
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            int pct = (tickCost - ticksLeft) * 100 / tickCost;
            TheOneProbeSupport.addDimensionElement(probeInfo.horizontal(), pct).text(pct + "%");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        DimensionBuilderTileEntity tileEntity;
        NBTTagCompound tagCompound;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof DimensionBuilderTileEntity && (tagCompound = (tileEntity = (DimensionBuilderTileEntity)te).hasTab()) != null) {
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            int pct = (tickCost - ticksLeft) * 100 / tickCost;
            currenttip.add(pct + "%");
        }
        return currenttip;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        DimensionBuilderTileEntity te = (DimensionBuilderTileEntity)world.func_175625_s(pos);
        return state.func_177226_a(OPERATIONTYPE, (Comparable)((Object)te.getState()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPERATIONTYPE});
    }

    public static enum OperationType implements IStringSerializable
    {
        CHARGING("charging"),
        EMPTY("empty"),
        BUILDING1("building1"),
        BUILDING2("building2");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

