/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.builder;

import java.util.Map;
import java.util.Random;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderBlock;
import mcjty.rftoolsdim.blocks.builder.DimensionBuilderContainer;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DimensionBuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_GETBUILDING = "getBuilding";
    public static final String CLIENTCMD_GETBUILDING = "getBuilding";
    public static final String CMD_RSMODE = "rsMode";
    public static final String COMPONENT_NAME = "dimension_builder";
    private static int buildPercentage = 0;
    private int creative = -1;
    private int state = 0;
    public static int OK = 0;
    public static int ERROR_NOOWNER = -1;
    public static int ERROR_TOOMANYDIMENSIONS = -2;
    private int errorMode = 0;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimensionBuilderContainer.factory, 1);
    private static int counter = 20;
    private static Random random = new Random();

    public DimensionBuilderTileEntity() {
        super(MachineConfiguration.BUILDER_MAXENERGY, MachineConfiguration.BUILDER_RECEIVEPERTICK);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        int oldstate = this.state;
        super.onDataPacket(net, packet);
        if (oldstate != this.state) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private boolean isCreative() {
        return false;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        NBTTagCompound tagCompound = this.hasTab();
        if (tagCompound == null) {
            this.setState(-1);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setState(-1);
            return;
        }
        int ticksLeft = tagCompound.func_74762_e("ticksLeft");
        if (ticksLeft > 0) {
            ticksLeft = this.createDimensionTick(tagCompound, ticksLeft);
        } else {
            this.maintainDimensionTick(tagCompound);
        }
        this.setState(ticksLeft);
    }

    public NBTTagCompound hasTab() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return null;
        }
        return itemStack.func_77978_p();
    }

    private void maintainDimensionTick(NBTTagCompound tagCompound) {
        int id = tagCompound.func_74762_e("id");
        if (id != 0) {
            int energy;
            int maxEnergy;
            DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(this.func_145831_w());
            int rf = this.isCheaterDimension(tagCompound) ? MachineConfiguration.BUILDER_MAXENERGY : this.getEnergyStored();
            if (rf > (maxEnergy = PowerConfiguration.MAX_DIMENSION_POWER - (energy = dimensionStorage.getEnergyLevel(id)))) {
                rf = maxEnergy;
            }
            if (Logging.debugMode && --counter < 0) {
                counter = 20;
                Logging.log((String)("#################### id:" + id + ", rf:" + rf + ", energy:" + energy + ", max:" + maxEnergy));
            }
            if (!this.isCheaterDimension(tagCompound)) {
                this.consumeEnergy(rf);
            }
            dimensionStorage.setEnergyLevel(id, energy + rf);
            dimensionStorage.save(this.func_145831_w());
        }
    }

    private int createDimensionTick(NBTTagCompound tagCompound, int ticksLeft) {
        RfToolsDimensionManager manager;
        if (GeneralConfiguration.dimensionBuilderNeedsOwner) {
            int cnt;
            int tickCost;
            if (this.getOwnerUUID() == null) {
                this.errorMode = ERROR_NOOWNER;
                return ticksLeft;
            }
            if (GeneralConfiguration.maxDimensionsPerPlayer >= 0 && (ticksLeft == (tickCost = tagCompound.func_74762_e("tickCost")) || ticksLeft < 5) && (cnt = (manager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w())).countOwnedDimensions(this.getOwnerUUID())) >= GeneralConfiguration.maxDimensionsPerPlayer) {
                this.errorMode = ERROR_TOOMANYDIMENSIONS;
                return ticksLeft;
            }
        }
        this.errorMode = OK;
        int createCost = tagCompound.func_74762_e("rfCreateCost");
        createCost = (int)((float)createCost * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.isCheaterDimension(tagCompound) || this.getEnergyStored() >= createCost) {
            if (this.isCheaterDimension(tagCompound)) {
                ticksLeft = 0;
            } else {
                this.consumeEnergy(createCost);
                --ticksLeft;
                if (random.nextFloat() < this.getInfusedFactor() && --ticksLeft < 0) {
                    ticksLeft = 0;
                }
            }
            tagCompound.func_74768_a("ticksLeft", ticksLeft);
            if (ticksLeft <= 0) {
                manager = RfToolsDimensionManager.getDimensionManager(this.func_145831_w());
                DimensionDescriptor descriptor = new DimensionDescriptor(tagCompound);
                String name = tagCompound.func_74779_i("name");
                int id = manager.createNewDimension(this.func_145831_w(), descriptor, name, this.getOwnerName(), this.getOwnerUUID());
                tagCompound.func_74768_a("id", id);
            }
        }
        return ticksLeft;
    }

    private boolean isCheaterDimension(NBTTagCompound tagCompound) {
        if (this.isCreative()) {
            return true;
        }
        String descriptionString = tagCompound.func_74779_i("descriptionString");
        return descriptionString.contains("XCheater");
    }

    public DimensionBuilderBlock.OperationType getState() {
        return DimensionBuilderBlock.OperationType.values()[this.state];
    }

    private void setState(int ticksLeft) {
        int oldstate = this.state;
        this.state = 0;
        this.state = ticksLeft == 0 ? 0 : (ticksLeft == -1 ? 1 : ((ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.markDirtyClient();
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return DimensionBuilderContainer.factory.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return DimensionBuilderContainer.factory.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return DimensionBuilderContainer.factory.isOutputSlot(index);
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void requestBuildingPercentage() {
        RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer("rftoolsdim", this.func_174877_v(), "getBuilding", "getBuilding", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getBuilding".equals(command)) {
            ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
            if (itemStack.func_190926_b()) {
                return 0;
            }
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return 0;
            }
            if (this.errorMode != OK) {
                return this.errorMode;
            }
            int ticksLeft = tagCompound.func_74762_e("ticksLeft");
            int tickCost = tagCompound.func_74762_e("tickCost");
            return (tickCost - ticksLeft) * 100 / tickCost;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getBuilding".equals(command)) {
            buildPercentage = result;
            return true;
        }
        return false;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            String m = args.get("rs").getString();
            this.setRSMode(RedstoneMode.getMode((String)m));
            return true;
        }
        return false;
    }

    public static int getBuildPercentage() {
        return buildPercentage;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.state = tagCompound.func_74771_c("state");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("state", (byte)this.state);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }
}

