/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.energyextractor;

import mcjty.lib.McJtyLib;
import mcjty.lib.compat.RedstoneFluxCompatibility;
import mcjty.lib.entity.GenericEnergyProviderTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyExtractorTileEntity
extends GenericEnergyProviderTileEntity
implements ITickable {
    public EnergyExtractorTileEntity() {
        super(MachineConfiguration.EXTRACTOR_MAXENERGY, MachineConfiguration.EXTRACTOR_SENDPERTICK);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        int energyStored = this.getEnergyStored();
        if (energyStored < MachineConfiguration.EXTRACTOR_MAXENERGY) {
            int needed = MachineConfiguration.EXTRACTOR_MAXENERGY - energyStored;
            DimensionStorage storage = DimensionStorage.getDimensionStorage(this.func_145831_w());
            int dimensionEnergy = storage.getEnergyLevel(this.func_145831_w().field_73011_w.getDimension());
            if (needed > dimensionEnergy) {
                needed = dimensionEnergy;
            }
            if (needed > 0) {
                energyStored += needed;
                this.modifyEnergyStored(needed);
                storage.setEnergyLevel(this.func_145831_w().field_73011_w.getDimension(), dimensionEnergy -= needed);
                storage.save(this.func_145831_w());
            }
        }
        if (energyStored <= 0) {
            return;
        }
        int rf = MachineConfiguration.EXTRACTOR_SENDPERTICK;
        for (EnumFacing facing : EnumFacing.values()) {
            int rfToGive;
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            EnumFacing opposite = facing.func_176734_d();
            if (!EnergyTools.isEnergyTE((TileEntity)te) && (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, opposite))) continue;
            int n = rfToGive = rf <= energyStored ? rf : energyStored;
            int received = McJtyLib.redstoneflux && RedstoneFluxCompatibility.isEnergyConnection((TileEntity)te) ? (RedstoneFluxCompatibility.canConnectEnergy((TileEntity)te, (EnumFacing)opposite) ? EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive) : 0) : EnergyTools.receiveEnergy((TileEntity)te, (EnumFacing)opposite, (int)rfToGive);
            if ((energyStored -= this.storage.extractEnergy(received, false)) <= 0) break;
        }
    }
}

