/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.api.dimension.IDimensionInformation;
import mcjty.rftoolsdim.compat.ChiselCompat;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.CelestialBodyDescriptor;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.dimensions.description.MobDescriptor;
import mcjty.rftoolsdim.dimensions.description.SkyDescriptor;
import mcjty.rftoolsdim.dimensions.description.WeatherDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import mcjty.rftoolsdim.dimensions.types.CelestialBodyType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.dimensions.types.EffectType;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.PatreonType;
import mcjty.rftoolsdim.dimensions.types.SkyType;
import mcjty.rftoolsdim.dimensions.types.StructureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import mcjty.rftoolsdim.dimensions.world.BiomeControllerMapping;
import mcjty.rftoolsdim.varia.GenericTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionInformation
implements IDimensionInformation {
    private final DimensionDescriptor descriptor;
    private String name;
    private String ownerName;
    private UUID owner;
    private BlockPos spawnPoint = null;
    private int probeCounter = 0;
    private long forcedDimensionSeed = 0L;
    private long baseSeed = 0L;
    private int worldVersion = 0;
    public static final int VERSION_OLD = 0;
    public static final int VERSION_CORRECTSEED = 1;
    public static final int VERSION_DIMLETSSEED = 2;
    private TerrainType terrainType = TerrainType.TERRAIN_VOID;
    private IBlockState baseBlockForTerrain = null;
    private Block fluidForTerrain = null;
    private IBlockState tendrilBlock = null;
    private IBlockState canyonBlock = null;
    private IBlockState[] pyramidBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private IBlockState[] sphereBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private IBlockState[] hugeSphereBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private IBlockState[] scatteredSphereBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private IBlockState[] liquidSphereBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private Block[] liquidSphereFluids = new Block[]{Blocks.field_150355_j};
    private IBlockState[] hugeLiquidSphereBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
    private Block[] hugeLiquidSphereFluids = new Block[]{Blocks.field_150355_j};
    private IBlockState[] extraOregen = new IBlockState[0];
    private Block[] fluidsForLakes = new Block[0];
    private List<MobDescriptor> extraMobs = new ArrayList<MobDescriptor>();
    private boolean peaceful = false;
    private boolean noanimals = false;
    private boolean shelter = false;
    private boolean respawnHere = false;
    private boolean cheater = false;
    private Set<FeatureType> featureTypes = EnumSet.noneOf(FeatureType.class);
    private Set<StructureType> structureTypes = EnumSet.noneOf(StructureType.class);
    private Set<EffectType> effectTypes = EnumSet.noneOf(EffectType.class);
    private ControllerType controllerType = null;
    private final List<Biome> biomes = new ArrayList<Biome>();
    private final Map<Integer, Integer> biomeMapping = new HashMap<Integer, Integer>();
    private String digitString = "";
    private Float celestialAngle = null;
    private Float timeSpeed = null;
    private SkyDescriptor skyDescriptor;
    private List<CelestialBodyDescriptor> celestialBodyDescriptors;
    private long patreon1 = 0L;
    private String[] dimensionTypes = new String[0];
    private WeatherDescriptor weatherDescriptor;
    private int actualRfCost;
    private String injectedDimlets = "";

    public DimensionInformation(String name, DimensionDescriptor descriptor, World world, String playerName, UUID player) {
        this.name = name;
        this.descriptor = descriptor;
        this.ownerName = playerName;
        this.owner = player;
        this.forcedDimensionSeed = descriptor.getForcedSeed();
        long overworldSeed = RfToolsDimensionManager.getWorldForDimension(world, 0).func_72905_C();
        this.baseSeed = GeneralConfiguration.randomizeSeed ? (long)(Math.random() * 10000.0 + 1.0) : overworldSeed;
        this.worldVersion = 2;
        this.setupFromDescriptor(overworldSeed);
        this.setupBiomeMapping();
        this.dump(null);
    }

    private void setupFromDescriptor(long seed) {
        List<Pair<DimletKey, List<DimletKey>>> dimlets = this.descriptor.getDimletsWithModifiers();
        Random random = new Random(this.descriptor.calculateSeed(seed));
        this.actualRfCost = 0;
        DimletType.DIMLET_PATREON.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_TERRAIN.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_FEATURE.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_STRUCTURE.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_BIOME.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_DIGIT.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_SKY.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_MOB.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_SPECIAL.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_TIME.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_EFFECT.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_WEATHER.dimletType.constructDimension(dimlets, random, this);
        this.actualRfCost += this.descriptor.getRfMaintainCost();
    }

    public void injectDimlet(DimletKey key) {
        DimletType type = key.getType();
        IDimletType itype = type.dimletType;
        if (itype.isInjectable(key)) {
            this.addToCost(key);
            itype.inject(key, this);
            this.injectedDimlets = this.injectedDimlets.isEmpty() ? key.toString() : this.injectedDimlets + "," + key;
        }
    }

    public DimensionInformation(DimensionDescriptor descriptor, NBTTagCompound tagCompound) {
        this.name = tagCompound.func_74779_i("name");
        this.ownerName = tagCompound.func_74779_i("owner");
        this.owner = tagCompound.func_74764_b("ownerM") ? new UUID(tagCompound.func_74763_f("ownerM"), tagCompound.func_74763_f("ownerL")) : null;
        this.descriptor = descriptor;
        this.setSpawnPoint(BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"spawnPoint"));
        this.probeCounter = tagCompound.func_74762_e("probeCounter");
        int version = tagCompound.func_74762_e("version");
        if (version == 1) {
            this.setupFromNBT(tagCompound);
        } else {
            this.setupFromDescriptor(1L);
        }
        this.setupBiomeMapping();
    }

    public static int[] getIntArraySafe(NBTTagCompound tagCompound, String name) {
        if (!tagCompound.func_74764_b(name)) {
            return new int[0];
        }
        NBTBase tag = tagCompound.func_74781_a(name);
        if (tag instanceof NBTTagIntArray) {
            return tagCompound.func_74759_k(name);
        }
        return new int[0];
    }

    private void setupFromNBT(NBTTagCompound tagCompound) {
        this.terrainType = TerrainType.values()[tagCompound.func_74762_e("terrain")];
        this.featureTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "features"), (Enum[])FeatureType.values());
        this.structureTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "structures"), (Enum[])StructureType.values());
        this.effectTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "effects"), (Enum[])EffectType.values());
        this.biomes.clear();
        for (int a : DimensionInformation.getIntArraySafe(tagCompound, "biomes")) {
            Biome biome = Biome.func_150568_d((int)a);
            if (biome != null) {
                this.biomes.add(biome);
                continue;
            }
            this.biomes.add(Biomes.field_76772_c);
        }
        this.controllerType = tagCompound.func_74764_b("controller") ? ControllerType.values()[tagCompound.func_74762_e("controller")] : (this.biomes.isEmpty() ? ControllerType.CONTROLLER_DEFAULT : ControllerType.CONTROLLER_SINGLE);
        this.digitString = tagCompound.func_74779_i("digits");
        this.forcedDimensionSeed = tagCompound.func_74763_f("forcedSeed");
        this.baseSeed = tagCompound.func_74763_f("baseSeed");
        this.worldVersion = tagCompound.func_74762_e("worldVersion");
        this.baseBlockForTerrain = this.getBlockMeta(tagCompound, "baseBlock");
        this.tendrilBlock = this.getBlockMeta(tagCompound, "tendrilBlock");
        this.canyonBlock = this.getBlockMeta(tagCompound, "canyonBlock");
        this.fluidForTerrain = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e("fluidBlock"));
        this.hugeLiquidSphereFluids = this.readFluidsFromNBT(tagCompound, "hugeLiquidSphereFluids");
        this.hugeLiquidSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "hugeLiquidSphereBlocks");
        Block oldLiquidSphereFluid = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e("liquidSphereFluid"));
        this.liquidSphereFluids = this.readFluidsFromNBT(tagCompound, "liquidSphereFluids");
        if (this.liquidSphereFluids.length == 0) {
            this.liquidSphereFluids = new Block[]{oldLiquidSphereFluid};
        }
        IBlockState oldLiquidSphereBlock = this.getBlockMeta(tagCompound, "liquidSphereBlock");
        this.liquidSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "liquidSphereBlocks");
        if (this.liquidSphereBlocks.length == 0) {
            this.liquidSphereBlocks = new IBlockState[]{oldLiquidSphereBlock};
        }
        this.pyramidBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "pyramidBlocks");
        if (this.pyramidBlocks.length == 0) {
            this.pyramidBlocks = new IBlockState[]{Blocks.field_150348_b.func_176223_P()};
        }
        IBlockState oldSphereBlock = this.getBlockMeta(tagCompound, "sphereBlock");
        this.sphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "sphereBlocks");
        if (this.sphereBlocks.length == 0) {
            this.sphereBlocks = new IBlockState[]{oldSphereBlock};
        }
        this.hugeSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "hugeSphereBlocks");
        this.scatteredSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "scatteredSphereBlocks");
        this.extraOregen = DimensionInformation.readBlockArrayFromNBT(tagCompound, "extraOregen");
        this.fluidsForLakes = this.readFluidsFromNBT(tagCompound, "lakeFluids");
        this.peaceful = tagCompound.func_74767_n("peaceful");
        this.noanimals = tagCompound.func_74767_n("noanimals");
        this.shelter = tagCompound.func_74767_n("shelter");
        this.respawnHere = tagCompound.func_74767_n("respawnHere");
        this.cheater = tagCompound.func_74767_n("cheater");
        this.celestialAngle = tagCompound.func_74764_b("celestialAngle") ? Float.valueOf(tagCompound.func_74760_g("celestialAngle")) : null;
        this.timeSpeed = tagCompound.func_74764_b("timeSpeed") ? Float.valueOf(tagCompound.func_74760_g("timeSpeed")) : null;
        this.probeCounter = tagCompound.func_74762_e("probes");
        this.actualRfCost = tagCompound.func_74762_e("actualCost");
        this.injectedDimlets = tagCompound.func_74779_i("injectedDimlets");
        this.skyDescriptor = new SkyDescriptor.Builder().fromNBT(tagCompound).build();
        this.calculateCelestialBodyDescriptors();
        this.patreon1 = tagCompound.func_74763_f("patreon1");
        this.weatherDescriptor = new WeatherDescriptor.Builder().fromNBT(tagCompound).build();
        this.extraMobs.clear();
        NBTTagList list = tagCompound.func_150295_c("mobs", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            String className = tc.func_74779_i("class");
            int chance = tc.func_74762_e("chance");
            int minGroup = tc.func_74762_e("minGroup");
            int maxGroup = tc.func_74762_e("maxGroup");
            int maxLoaded = tc.func_74762_e("maxLoaded");
            Class<EntityLiving> c = null;
            try {
                c = GenericTools.castClass(Class.forName(className), EntityLiving.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            MobDescriptor mob = new MobDescriptor(c, chance, minGroup, maxGroup, maxLoaded);
            this.extraMobs.add(mob);
        }
        String ds = tagCompound.func_74779_i("dimensionTypes");
        this.dimensionTypes = StringUtils.split((String)ds, (String)",");
        if (this.dimensionTypes == null) {
            this.dimensionTypes = new String[0];
        }
    }

    private Block[] readFluidsFromNBT(NBTTagCompound tagCompound, String name) {
        ArrayList<Object> fluids = new ArrayList<Object>();
        if (tagCompound.func_74764_b(name + "_reg")) {
            NBTTagList list = tagCompound.func_150295_c(name + "_reg", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagString reg = (NBTTagString)list.func_179238_g(i);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(reg.func_150285_a_()));
                if (block == null) {
                    Logging.logError((String)("Block with id " + reg.func_150285_a_() + " no longer exists! Ignoring..."));
                    continue;
                }
                fluids.add(block);
            }
        } else {
            for (int a : DimensionInformation.getIntArraySafe(tagCompound, name)) {
                fluids.add(Block.field_149771_c.func_148754_a(a));
            }
        }
        return fluids.toArray(new Block[fluids.size()]);
    }

    private static IBlockState[] readBlockArrayFromNBT(NBTTagCompound tagCompound, String name) {
        ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
        int[] metas = DimensionInformation.getIntArraySafe(tagCompound, name + "_meta");
        if (tagCompound.func_74764_b(name + "_reg")) {
            NBTTagList list = tagCompound.func_150295_c(name + "_reg", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagString reg = (NBTTagString)list.func_179238_g(i);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(reg.func_150285_a_()));
                if (block == null) {
                    Logging.logError((String)("Block with id " + reg.func_150285_a_() + " no longer exists! Ignoring..."));
                    continue;
                }
                int meta = 0;
                if (i < metas.length) {
                    meta = metas[i];
                }
                try {
                    blocks.add(block.func_176203_a(meta));
                    continue;
                }
                catch (Exception e) {
                    Logging.logError((String)("Block with id " + reg.func_150285_a_() + " no longer supports meta " + meta + "! Ignoring..."));
                }
            }
        } else {
            int[] blockIds = DimensionInformation.getIntArraySafe(tagCompound, name);
            for (int i = 0; i < blockIds.length; ++i) {
                int id = blockIds[i];
                Block block = (Block)Block.field_149771_c.func_148754_a(id);
                int meta = 0;
                if (i < metas.length) {
                    meta = metas[i];
                }
                try {
                    blocks.add(block.func_176203_a(meta));
                    continue;
                }
                catch (Exception e) {
                    Logging.logError((String)"Block has changed in dimension: ignoring");
                }
            }
        }
        return blocks.toArray(new IBlockState[blocks.size()]);
    }

    private IBlockState getBlockMeta(NBTTagCompound tagCompound, String name) {
        Block block = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e(name));
        int meta = tagCompound.func_74762_e(name + "_meta");
        return block.func_176203_a(meta);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        BlockPos spawnPoint;
        tagCompound.func_74778_a("name", this.getName());
        tagCompound.func_74778_a("owner", this.ownerName);
        if (this.owner != null) {
            tagCompound.func_74772_a("ownerM", this.owner.getMostSignificantBits());
            tagCompound.func_74772_a("ownerL", this.owner.getLeastSignificantBits());
        }
        if ((spawnPoint = this.getSpawnPoint()) != null) {
            BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"spawnPoint", (BlockPos)spawnPoint);
        }
        tagCompound.func_74768_a("probeCounter", this.getProbeCounter());
        tagCompound.func_74768_a("version", 1);
        tagCompound.func_74768_a("terrain", this.terrainType == null ? TerrainType.TERRAIN_VOID.ordinal() : this.terrainType.ordinal());
        tagCompound.func_74783_a("features", DimensionInformation.toIntArray(this.featureTypes));
        tagCompound.func_74783_a("structures", DimensionInformation.toIntArray(this.structureTypes));
        tagCompound.func_74783_a("effects", DimensionInformation.toIntArray(this.effectTypes));
        ArrayList<Integer> c = new ArrayList<Integer>(this.biomes.size());
        for (Biome t : this.biomes) {
            if (t != null) {
                c.add(Biome.func_185362_a((Biome)t));
                continue;
            }
            c.add(Biome.func_185362_a((Biome)Biomes.field_76772_c));
        }
        tagCompound.func_74783_a("biomes", ArrayUtils.toPrimitive((Integer[])c.toArray(new Integer[c.size()])));
        tagCompound.func_74768_a("controller", this.controllerType == null ? ControllerType.CONTROLLER_DEFAULT.ordinal() : this.controllerType.ordinal());
        tagCompound.func_74778_a("digits", this.digitString);
        tagCompound.func_74772_a("forcedSeed", this.forcedDimensionSeed);
        tagCompound.func_74772_a("baseSeed", this.baseSeed);
        tagCompound.func_74768_a("worldVersion", this.worldVersion);
        this.setBlockMeta(tagCompound, this.baseBlockForTerrain, "baseBlock");
        this.setBlockMeta(tagCompound, this.tendrilBlock, "tendrilBlock");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.pyramidBlocks, "pyramidBlocks");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.sphereBlocks, "sphereBlocks");
        if (this.sphereBlocks.length > 0) {
            this.setBlockMeta(tagCompound, this.sphereBlocks[0], "sphereBlock");
        }
        DimensionInformation.writeBlocksToNBT(tagCompound, this.hugeSphereBlocks, "hugeSphereBlocks");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.scatteredSphereBlocks, "scatteredSphereBlocks");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.hugeLiquidSphereBlocks, "hugeLiquidSphereBlocks");
        DimensionInformation.writeFluidsToNBT(tagCompound, this.hugeLiquidSphereFluids, "hugeLiquidSphereFluids");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.liquidSphereBlocks, "liquidSphereBlocks");
        if (this.liquidSphereBlocks.length > 0) {
            this.setBlockMeta(tagCompound, this.liquidSphereBlocks[0], "liquidSphereBlock");
        }
        DimensionInformation.writeFluidsToNBT(tagCompound, this.liquidSphereFluids, "liquidSphereFluids");
        if (this.liquidSphereFluids.length > 0) {
            tagCompound.func_74768_a("liquidSphereFluid", Block.field_149771_c.func_148757_b((Object)this.liquidSphereFluids[0]));
        }
        this.setBlockMeta(tagCompound, this.canyonBlock, "canyonBlock");
        tagCompound.func_74768_a("fluidBlock", Block.field_149771_c.func_148757_b((Object)this.fluidForTerrain));
        DimensionInformation.writeBlocksToNBT(tagCompound, this.extraOregen, "extraOregen");
        DimensionInformation.writeFluidsToNBT(tagCompound, this.fluidsForLakes, "lakeFluids");
        tagCompound.func_74757_a("peaceful", this.peaceful);
        tagCompound.func_74757_a("noanimals", this.noanimals);
        tagCompound.func_74757_a("shelter", this.shelter);
        tagCompound.func_74757_a("respawnHere", this.respawnHere);
        tagCompound.func_74757_a("cheater", this.cheater);
        if (this.celestialAngle != null) {
            tagCompound.func_74776_a("celestialAngle", this.celestialAngle.floatValue());
        }
        if (this.timeSpeed != null) {
            tagCompound.func_74776_a("timeSpeed", this.timeSpeed.floatValue());
        }
        tagCompound.func_74768_a("probes", this.probeCounter);
        tagCompound.func_74768_a("actualCost", this.actualRfCost);
        tagCompound.func_74778_a("injectedDimlets", this.injectedDimlets);
        this.skyDescriptor.writeToNBT(tagCompound);
        this.weatherDescriptor.writeToNBT(tagCompound);
        tagCompound.func_74772_a("patreon1", this.patreon1);
        NBTTagList list = new NBTTagList();
        for (MobDescriptor mob : this.extraMobs) {
            NBTTagCompound tc = new NBTTagCompound();
            if (mob == null) continue;
            tc.func_74778_a("class", mob.field_76300_b.getName());
            tc.func_74768_a("chance", mob.field_76292_a);
            tc.func_74768_a("minGroup", mob.field_76301_c);
            tc.func_74768_a("maxGroup", mob.field_76299_d);
            tc.func_74768_a("maxLoaded", mob.getMaxLoaded());
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("mobs", (NBTBase)list);
        tagCompound.func_74778_a("dimensionTypes", StringUtils.join((Object[])this.dimensionTypes, (String)","));
    }

    private void setBlockMeta(NBTTagCompound tagCompound, IBlockState blockMeta, String name) {
        tagCompound.func_74768_a(name, Block.field_149771_c.func_148757_b((Object)blockMeta.func_177230_c()));
        tagCompound.func_74768_a(name + "_meta", blockMeta.func_177230_c().func_176201_c(blockMeta));
    }

    private static void writeFluidsToNBT(NBTTagCompound tagCompound, Block[] fluids, String name) {
        NBTTagList list = new NBTTagList();
        for (Block t : fluids) {
            list.func_74742_a((NBTBase)new NBTTagString(t.getRegistryName().toString()));
        }
        tagCompound.func_74782_a(name + "_reg", (NBTBase)list);
    }

    private static void writeBlocksToNBT(NBTTagCompound tagCompound, IBlockState[] blocks, String name) {
        NBTTagList list = new NBTTagList();
        ArrayList<Integer> meta = new ArrayList<Integer>(blocks.length);
        for (IBlockState t : blocks) {
            list.func_74742_a((NBTBase)new NBTTagString(t.func_177230_c().getRegistryName().toString()));
            meta.add(t.func_177230_c().func_176201_c(t));
        }
        tagCompound.func_74782_a(name + "_reg", (NBTBase)list);
        tagCompound.func_74783_a(name + "_meta", ArrayUtils.toPrimitive((Integer[])meta.toArray(new Integer[meta.size()])));
    }

    private static <T extends Enum<T>> int[] toIntArray(Collection<T> collection) {
        ArrayList<Integer> c = new ArrayList<Integer>(collection.size());
        for (Enum t : collection) {
            c.add(t.ordinal());
        }
        return ArrayUtils.toPrimitive((Integer[])c.toArray(new Integer[c.size()]));
    }

    private static <T extends Enum<T>> Set<T> toEnumSet(int[] arr, T[] values) {
        HashSet<T> list = new HashSet<T>();
        for (int a : arr) {
            list.add(values[a]);
        }
        return list;
    }

    private void logDebug(EntityPlayer player, String message) {
        if (player == null) {
            Logging.log((String)message);
        } else {
            Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + message));
        }
    }

    public static String getDisplayName(Block block) {
        if (block == null) {
            return "null";
        }
        return DimensionInformation.getDisplayName(block.func_176223_P());
    }

    public static String getDisplayName(IBlockState state) {
        Fluid fluid;
        String readableName;
        if (state == null) {
            return "null";
        }
        Block block = state.func_177230_c();
        String suffix = "";
        if ("chisel".equals(block.getRegistryName().func_110624_b()) && RFToolsDim.chisel && (readableName = ChiselCompat.getReadableName(state)) != null) {
            suffix = ", " + readableName;
        }
        if (block instanceof BlockLiquid && (fluid = FluidRegistry.lookupFluidForBlock((Block)block)) != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            return stack.getLocalizedName() + suffix;
        }
        ItemStack itemStack = new ItemStack(block, 1, block.func_176201_c(state));
        if (itemStack.func_190926_b()) {
            return block.func_149732_F() + suffix;
        }
        return itemStack.func_82833_r() + suffix;
    }

    public void dump(EntityPlayer player) {
        String digits;
        if (!this.injectedDimlets.isEmpty()) {
            this.logDebug(player, "    Injected dimlets: " + this.injectedDimlets);
        }
        if (!(digits = this.getDigitString()).isEmpty()) {
            this.logDebug(player, "    Digits: " + digits);
        }
        if (this.forcedDimensionSeed != 0L) {
            this.logDebug(player, "    Forced seed: " + this.forcedDimensionSeed);
        }
        if (this.baseSeed != 0L) {
            this.logDebug(player, "    Base seed: " + this.baseSeed);
        }
        this.logDebug(player, "    World version: " + this.worldVersion);
        TerrainType terrainType = this.getTerrainType();
        this.logDebug(player, "    Terrain: " + terrainType.toString());
        this.logDebug(player, "        Base block: " + DimensionInformation.getDisplayName(this.baseBlockForTerrain));
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_TENDRILS)) {
            this.logDebug(player, "        Tendril block: " + DimensionInformation.getDisplayName(this.tendrilBlock));
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_PYRAMIDS)) {
            for (IBlockState iBlockState : this.pyramidBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Pyramid blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_ORBS)) {
            for (IBlockState iBlockState : this.sphereBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Orb blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGEORBS)) {
            for (IBlockState iBlockState : this.hugeSphereBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Huge Orb blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_SCATTEREDORBS)) {
            for (IBlockState iBlockState : this.scatteredSphereBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Scattered Orb blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_LIQUIDORBS)) {
            for (IBlockState iBlockState : this.liquidSphereBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Liquid Orb blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGELIQUIDORBS)) {
            for (IBlockState iBlockState : this.hugeLiquidSphereBlocks) {
                if (iBlockState == null) continue;
                this.logDebug(player, "        Huge Liquid Orb blocks: " + DimensionInformation.getDisplayName(iBlockState));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_CANYONS)) {
            this.logDebug(player, "        Canyon block: " + DimensionInformation.getDisplayName(this.canyonBlock));
        }
        this.logDebug(player, "        Base fluid: " + DimensionInformation.getDisplayName(this.fluidForTerrain));
        this.logDebug(player, "    Biome controller: " + (this.controllerType == null ? "<null>" : this.controllerType.name()));
        for (Biome biome : this.getBiomes()) {
            if (biome == null) continue;
            this.logDebug(player, "    Biome: " + biome.field_76791_y);
        }
        for (FeatureType featureType : this.getFeatureTypes()) {
            this.logDebug(player, "    Feature: " + featureType.toString());
        }
        for (IBlockState iBlockState : this.extraOregen) {
            if (iBlockState == null) continue;
            this.logDebug(player, "        Extra ore: " + DimensionInformation.getDisplayName(iBlockState));
        }
        for (Block block : this.fluidsForLakes) {
            this.logDebug(player, "        Lake fluid: " + DimensionInformation.getDisplayName(block));
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_LIQUIDORBS)) {
            for (Block block : this.liquidSphereFluids) {
                this.logDebug(player, "        Liquid orb fluids: " + DimensionInformation.getDisplayName(block));
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGELIQUIDORBS)) {
            for (Block block : this.hugeLiquidSphereFluids) {
                this.logDebug(player, "        Huge Liquid orb fluids: " + DimensionInformation.getDisplayName(block));
            }
        }
        for (StructureType structureType : this.getStructureTypes()) {
            this.logDebug(player, "    Structure: " + structureType.toString());
        }
        for (EffectType effectType : this.getEffectTypes()) {
            this.logDebug(player, "    Effect: " + effectType.toString());
        }
        this.logDebug(player, "    Sun brightness: " + this.skyDescriptor.getSunBrightnessFactor());
        this.logDebug(player, "    Star brightness: " + this.skyDescriptor.getStarBrightnessFactor());
        float r = this.skyDescriptor.getSkyColorFactorR();
        float g = this.skyDescriptor.getSkyColorFactorG();
        float b = this.skyDescriptor.getSkyColorFactorB();
        this.logDebug(player, "    Sky color: " + r + ", " + g + ", " + b);
        r = this.skyDescriptor.getFogColorFactorR();
        g = this.skyDescriptor.getFogColorFactorG();
        b = this.skyDescriptor.getFogColorFactorB();
        this.logDebug(player, "    Fog color: " + r + ", " + g + ", " + b);
        r = this.skyDescriptor.getCloudColorFactorR();
        g = this.skyDescriptor.getCloudColorFactorG();
        b = this.skyDescriptor.getCloudColorFactorB();
        this.logDebug(player, "    Cloud color: " + r + ", " + g + ", " + b);
        SkyType skyType = this.skyDescriptor.getSkyType();
        if (skyType != SkyType.SKY_NORMAL) {
            this.logDebug(player, "    Sky type: " + skyType.toString());
        }
        for (CelestialBodyType bodyType : this.skyDescriptor.getCelestialBodies()) {
            this.logDebug(player, "    Sky body: " + bodyType.name());
        }
        if (this.weatherDescriptor.getRainStrength() > -0.5f) {
            this.logDebug(player, "    Weather rain: " + this.weatherDescriptor.getRainStrength());
        }
        if (this.weatherDescriptor.getThunderStrength() > -0.5f) {
            this.logDebug(player, "    Weather thunder " + this.weatherDescriptor.getThunderStrength());
        }
        for (MobDescriptor mob : this.extraMobs) {
            if (mob == null) continue;
            this.logDebug(player, "    Mob: " + mob.field_76300_b.getName());
        }
        if (this.peaceful) {
            this.logDebug(player, "    Peaceful mode");
        }
        if (this.noanimals) {
            this.logDebug(player, "    No animals mode");
        }
        if (this.shelter) {
            this.logDebug(player, "    Safe shelter");
        }
        if (this.respawnHere) {
            this.logDebug(player, "    Respawn local");
        }
        if (this.cheater) {
            this.logDebug(player, "    CHEATER!");
        }
        if (this.celestialAngle != null) {
            this.logDebug(player, "    Celestial angle: " + this.celestialAngle);
        }
        if (this.timeSpeed != null) {
            this.logDebug(player, "    Time speed: " + this.timeSpeed);
        }
        if (this.probeCounter > 0) {
            this.logDebug(player, "    Probes: " + this.probeCounter);
        }
        if (this.patreon1 != 0L) {
            this.logDebug(player, "    Patreon: " + this.patreon1);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.ownerName);
        if (this.owner == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeLong(this.owner.getMostSignificantBits());
            buf.writeLong(this.owner.getLeastSignificantBits());
        }
        NetworkTools.writeEnum((ByteBuf)buf, (Enum)this.terrainType, (Enum)TerrainType.TERRAIN_VOID);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.featureTypes);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.structureTypes);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.effectTypes);
        buf.writeInt(this.biomes.size());
        for (Biome entry : this.biomes) {
            if (entry != null) {
                int id = Biome.func_185362_a((Biome)entry);
                buf.writeInt(id);
                continue;
            }
            buf.writeInt(Biome.func_185362_a((Biome)Biomes.field_76772_c));
        }
        NetworkTools.writeEnum((ByteBuf)buf, (Enum)this.controllerType, (Enum)ControllerType.CONTROLLER_DEFAULT);
        NetworkTools.writeString((ByteBuf)buf, (String)this.digitString);
        buf.writeLong(this.forcedDimensionSeed);
        buf.writeLong(this.baseSeed);
        buf.writeInt(this.worldVersion);
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.baseBlockForTerrain.func_177230_c()));
        buf.writeInt(this.baseBlockForTerrain.func_177230_c().func_176201_c(this.baseBlockForTerrain));
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.tendrilBlock.func_177230_c()));
        buf.writeInt(this.tendrilBlock.func_177230_c().func_176201_c(this.tendrilBlock));
        DimensionInformation.writeBlockArrayToBuf(buf, this.pyramidBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.sphereBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.hugeSphereBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.scatteredSphereBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.liquidSphereBlocks);
        DimensionInformation.writeFluidArrayToBuf(buf, this.liquidSphereFluids);
        DimensionInformation.writeBlockArrayToBuf(buf, this.hugeLiquidSphereBlocks);
        DimensionInformation.writeFluidArrayToBuf(buf, this.hugeLiquidSphereFluids);
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.canyonBlock.func_177230_c()));
        buf.writeInt(this.canyonBlock.func_177230_c().func_176201_c(this.canyonBlock));
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.fluidForTerrain));
        DimensionInformation.writeBlockArrayToBuf(buf, this.extraOregen);
        DimensionInformation.writeFluidArrayToBuf(buf, this.fluidsForLakes);
        buf.writeBoolean(this.peaceful);
        buf.writeBoolean(this.noanimals);
        buf.writeBoolean(this.shelter);
        buf.writeBoolean(this.respawnHere);
        buf.writeBoolean(this.cheater);
        NetworkTools.writeFloat((ByteBuf)buf, (Float)this.celestialAngle);
        NetworkTools.writeFloat((ByteBuf)buf, (Float)this.timeSpeed);
        buf.writeInt(this.probeCounter);
        buf.writeInt(this.actualRfCost);
        NetworkTools.writeString((ByteBuf)buf, (String)this.injectedDimlets);
        this.skyDescriptor.toBytes(buf);
        this.weatherDescriptor.toBytes(buf);
        buf.writeLong(this.patreon1);
        int mobsize = 0;
        for (MobDescriptor mob : this.extraMobs) {
            if (mob == null) continue;
            ++mobsize;
        }
        buf.writeInt(mobsize);
        for (MobDescriptor mob : this.extraMobs) {
            if (mob == null) continue;
            NetworkTools.writeString((ByteBuf)buf, (String)mob.field_76300_b.getName());
            buf.writeInt(mob.field_76292_a);
            buf.writeInt(mob.field_76301_c);
            buf.writeInt(mob.field_76299_d);
            buf.writeInt(mob.getMaxLoaded());
        }
        buf.writeInt(this.dimensionTypes.length);
        for (String type : this.dimensionTypes) {
            NetworkTools.writeString((ByteBuf)buf, (String)type);
        }
    }

    private static void writeFluidArrayToBuf(ByteBuf buf, Block[] fluids) {
        buf.writeInt(fluids.length);
        for (Block block : fluids) {
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block));
        }
    }

    private static void writeBlockArrayToBuf(ByteBuf buf, IBlockState[] array) {
        buf.writeInt(array.length);
        for (IBlockState block : array) {
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block.func_177230_c()));
            buf.writeInt(block.func_177230_c().func_176201_c(block));
        }
    }

    public DimensionInformation(String name, DimensionDescriptor descriptor, ByteBuf buf) {
        int i;
        this.name = name;
        this.descriptor = descriptor;
        this.ownerName = NetworkTools.readString((ByteBuf)buf);
        this.owner = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.terrainType = (TerrainType)NetworkTools.readEnum((ByteBuf)buf, (Enum[])TerrainType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.featureTypes, (Enum[])FeatureType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.structureTypes, (Enum[])StructureType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.effectTypes, (Enum[])EffectType.values());
        this.biomes.clear();
        int size = buf.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            int id = buf.readInt();
            Biome biome = Biome.func_150568_d((int)id);
            if (biome != null) {
                this.biomes.add(biome);
                continue;
            }
            this.biomes.add(Biomes.field_76772_c);
        }
        this.controllerType = (ControllerType)NetworkTools.readEnum((ByteBuf)buf, (Enum[])ControllerType.values());
        this.digitString = NetworkTools.readString((ByteBuf)buf);
        this.forcedDimensionSeed = buf.readLong();
        this.baseSeed = buf.readLong();
        this.worldVersion = buf.readInt();
        Block block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        int meta = buf.readInt();
        this.baseBlockForTerrain = block.func_176203_a(meta);
        block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        meta = buf.readInt();
        this.tendrilBlock = block.func_176203_a(meta);
        this.pyramidBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.sphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.hugeSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.scatteredSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.liquidSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.liquidSphereFluids = DimensionInformation.readFluidArrayFromBuf(buf);
        this.hugeLiquidSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.hugeLiquidSphereFluids = DimensionInformation.readFluidArrayFromBuf(buf);
        block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        meta = buf.readInt();
        this.canyonBlock = block.func_176203_a(meta);
        this.fluidForTerrain = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        this.extraOregen = DimensionInformation.readBlockArrayFromBuf(buf);
        this.fluidsForLakes = DimensionInformation.readFluidArrayFromBuf(buf);
        this.peaceful = buf.readBoolean();
        this.noanimals = buf.readBoolean();
        this.shelter = buf.readBoolean();
        this.respawnHere = buf.readBoolean();
        this.cheater = buf.readBoolean();
        this.celestialAngle = NetworkTools.readFloat((ByteBuf)buf);
        this.timeSpeed = NetworkTools.readFloat((ByteBuf)buf);
        this.probeCounter = buf.readInt();
        this.actualRfCost = buf.readInt();
        this.injectedDimlets = NetworkTools.readString((ByteBuf)buf);
        this.skyDescriptor = new SkyDescriptor.Builder().fromBytes(buf).build();
        this.calculateCelestialBodyDescriptors();
        this.weatherDescriptor = new WeatherDescriptor.Builder().fromBytes(buf).build();
        this.patreon1 = buf.readLong();
        this.extraMobs.clear();
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            String className = NetworkTools.readString((ByteBuf)buf);
            int chance = buf.readInt();
            int minGroup = buf.readInt();
            int maxGroup = buf.readInt();
            int maxLoaded = buf.readInt();
            try {
                Class<EntityLiving> c = GenericTools.castClass(Class.forName(className), EntityLiving.class);
                MobDescriptor mob = new MobDescriptor(c, chance, minGroup, maxGroup, maxLoaded);
                this.extraMobs.add(mob);
                continue;
            }
            catch (ClassNotFoundException e) {
                Logging.logError((String)("Cannot find class: " + className + "!"), (Throwable)e);
            }
        }
        size = buf.readInt();
        this.dimensionTypes = new String[size];
        for (i = 0; i < size; ++i) {
            this.dimensionTypes[i] = NetworkTools.readString((ByteBuf)buf);
        }
        this.setupBiomeMapping();
    }

    private static Block[] readFluidArrayFromBuf(ByteBuf buf) {
        ArrayList<Object> blocks = new ArrayList<Object>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            blocks.add(Block.field_149771_c.func_148754_a(buf.readInt()));
        }
        return blocks.toArray(new Block[blocks.size()]);
    }

    private static IBlockState[] readBlockArrayFromBuf(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<IBlockState> blocksMeta = new ArrayList<IBlockState>();
        for (int i = 0; i < size; ++i) {
            Block b = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
            int m = buf.readInt();
            blocksMeta.add(b.func_176203_a(m));
        }
        return blocksMeta.toArray(new IBlockState[blocksMeta.size()]);
    }

    public BlockPos getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(BlockPos spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public void setSkyDescriptor(SkyDescriptor sd) {
        this.skyDescriptor = sd;
        this.calculateCelestialBodyDescriptors();
    }

    private void calculateCelestialBodyDescriptors() {
        List<CelestialBodyType> celestialBodies = this.skyDescriptor.getCelestialBodies();
        int sunidx = -1;
        int bestsun = 0;
        int moonidx = -1;
        int bestmoon = 0;
        for (int i = 0; i < celestialBodies.size(); ++i) {
            CelestialBodyType type = celestialBodies.get(i);
            if (type.getGoodSunFactor() > bestsun) {
                bestsun = type.getGoodSunFactor();
                sunidx = i;
            }
            if (type.getGoodMoonFactor() <= bestmoon) continue;
            bestmoon = type.getGoodMoonFactor();
            moonidx = i;
        }
        Random random = new Random(123L);
        random.nextFloat();
        this.celestialBodyDescriptors = new ArrayList<CelestialBodyDescriptor>();
        for (int i = 0; i < celestialBodies.size(); ++i) {
            CelestialBodyType type = celestialBodies.get(i);
            this.celestialBodyDescriptors.add(new CelestialBodyDescriptor(type, i == sunidx || i == moonidx));
        }
    }

    public static List<Pair<DimletKey, List<DimletKey>>> extractType(DimletType type, List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        ArrayList<Pair<DimletKey, List<DimletKey>>> result = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        for (Pair<DimletKey, List<DimletKey>> dimlet : dimlets) {
            if (((DimletKey)dimlet.getLeft()).getType() != type) continue;
            result.add(dimlet);
        }
        return result;
    }

    public void updateCostFactor(DimletKey key) {
        this.actualRfCost += this.calculateCostFactor(key);
    }

    private int calculateCostFactor(DimletKey key) {
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings == null) {
            Logging.logError((String)("Something went wrong for key: " + key));
            return 0;
        }
        return (int)((float)settings.getMaintainCost().intValue() * PowerConfiguration.afterCreationCostFactor);
    }

    private void addToCost(DimletKey key) {
        Settings settings = KnownDimletConfiguration.getSettings(key);
        if (settings == null) {
            return;
        }
        int rfMaintainCost = settings.getMaintainCost();
        if (rfMaintainCost < 0) {
            int nominalCost = this.descriptor.calculateNominalCost();
            int rfMinimum = Math.max(10, nominalCost * PowerConfiguration.minimumCostPercentage / 100);
            this.actualRfCost -= this.actualRfCost * -rfMaintainCost / 100;
            if (this.actualRfCost < rfMinimum) {
                this.actualRfCost = rfMinimum;
            }
        } else {
            this.actualRfCost += rfMaintainCost;
        }
    }

    public static void getMaterialAndFluidModifiers(List<DimletKey> modifiers, List<IBlockState> blocks, List<Block> fluids) {
        if (modifiers != null) {
            for (DimletKey modifier : modifiers) {
                if (modifier.getType() == DimletType.DIMLET_MATERIAL) {
                    IBlockState block = DimletObjectMapping.getBlock(modifier);
                    blocks.add(block);
                    continue;
                }
                if (modifier.getType() != DimletType.DIMLET_LIQUID) continue;
                Block fluid = DimletObjectMapping.getFluid(modifier);
                fluids.add(fluid);
            }
        }
    }

    public IBlockState getFeatureBlock(Random random, Map<FeatureType, List<DimletKey>> modifiersForFeature, FeatureType featureType) {
        IBlockState block;
        if (this.featureTypes.contains((Object)featureType)) {
            ArrayList<IBlockState> blocks = new ArrayList<IBlockState>();
            ArrayList<Block> fluids = new ArrayList<Block>();
            DimensionInformation.getMaterialAndFluidModifiers(modifiersForFeature.get((Object)featureType), blocks, fluids);
            if (!blocks.isEmpty()) {
                block = (IBlockState)blocks.get(random.nextInt(blocks.size()));
                if (block == null) {
                    block = Blocks.field_150348_b.func_176223_P();
                }
            } else if (random.nextFloat() < WorldgenConfiguration.randomFeatureMaterialChance) {
                DimletKey key = DimletRandomizer.getRandomMaterialBlock(random);
                if (key != null) {
                    this.actualRfCost += this.calculateCostFactor(key);
                    block = DimletObjectMapping.getBlock(key);
                } else {
                    block = Blocks.field_150348_b.func_176223_P();
                }
            } else {
                block = Blocks.field_150348_b.func_176223_P();
            }
        } else {
            block = Blocks.field_150348_b.func_176223_P();
        }
        return block;
    }

    private void setupBiomeMapping() {
        this.biomeMapping.clear();
        if (this.controllerType == ControllerType.CONTROLLER_FILTERED) {
            final HashSet<Integer> ids = new HashSet<Integer>();
            for (Biome biome : this.biomes) {
                if (biome != null) {
                    ids.add(Biome.func_185362_a((Biome)biome));
                    continue;
                }
                ids.add(Biome.func_185362_a((Biome)Biomes.field_76772_c));
            }
            ControllerType.BiomeFilter biomeFilter = new ControllerType.BiomeFilter(){

                @Override
                public boolean match(Biome biome) {
                    return ids.contains(Biome.func_185362_a((Biome)biome));
                }

                @Override
                public double calculateBiomeDistance(Biome a, Biome b) {
                    return this.calculateBiomeDistance(a, b, false, false, false);
                }
            };
            BiomeControllerMapping.makeFilteredBiomeMap(this.biomeMapping, biomeFilter);
        }
    }

    public DimensionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(String name, UUID o) {
        this.ownerName = name;
        this.owner = o;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TerrainType getTerrainType() {
        return this.terrainType;
    }

    public void setTerrainType(TerrainType type) {
        this.terrainType = type;
    }

    public boolean hasFeatureType(FeatureType type) {
        return this.featureTypes.contains((Object)type);
    }

    public Set<FeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public boolean hasStructureType(StructureType type) {
        return this.structureTypes.contains((Object)type);
    }

    public Set<StructureType> getStructureTypes() {
        return this.structureTypes;
    }

    public boolean hasEffectType(EffectType type) {
        return this.effectTypes.contains((Object)type);
    }

    public Set<EffectType> getEffectTypes() {
        return this.effectTypes;
    }

    public List<Biome> getBiomes() {
        return this.biomes;
    }

    public Map<Integer, Integer> getBiomeMapping() {
        if (this.biomeMapping.isEmpty()) {
            this.setupBiomeMapping();
        }
        return this.biomeMapping;
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(ControllerType controllerType) {
        this.controllerType = controllerType;
    }

    public String getDigitString() {
        return this.digitString;
    }

    public void setDigitString(String digitString) {
        this.digitString = digitString;
    }

    public IBlockState getBaseBlockForTerrain() {
        return this.baseBlockForTerrain;
    }

    public void setBaseBlockForTerrain(IBlockState blockMeta) {
        this.baseBlockForTerrain = blockMeta;
    }

    public IBlockState getTendrilBlock() {
        return this.tendrilBlock;
    }

    public void setTendrilBlock(IBlockState block) {
        this.tendrilBlock = block;
    }

    public IBlockState getCanyonBlock() {
        return this.canyonBlock;
    }

    public void setCanyonBlock(IBlockState canyonBlock) {
        this.canyonBlock = canyonBlock;
    }

    public IBlockState[] getPyramidBlocks() {
        return this.pyramidBlocks;
    }

    public void setPyramidBlocks(IBlockState[] pyramidBlocks) {
        this.pyramidBlocks = pyramidBlocks;
    }

    public IBlockState[] getSphereBlocks() {
        return this.sphereBlocks;
    }

    public void setSphereBlocks(IBlockState[] sphereBlocks) {
        this.sphereBlocks = sphereBlocks;
    }

    public IBlockState[] getHugeSphereBlocks() {
        return this.hugeSphereBlocks;
    }

    public void setHugeSphereBlocks(IBlockState[] hugeSphereBlocks) {
        this.hugeSphereBlocks = hugeSphereBlocks;
    }

    public void setScatteredSphereBlocks(IBlockState[] scatteredSphereBlocks) {
        this.scatteredSphereBlocks = scatteredSphereBlocks;
    }

    public IBlockState[] getScatteredSphereBlocks() {
        return this.scatteredSphereBlocks;
    }

    public IBlockState[] getLiquidSphereBlocks() {
        return this.liquidSphereBlocks;
    }

    public void setLiquidSphereBlocks(IBlockState[] liquidSphereBlocks) {
        this.liquidSphereBlocks = liquidSphereBlocks;
    }

    public Block[] getLiquidSphereFluids() {
        return this.liquidSphereFluids;
    }

    public void setLiquidSphereFluids(Block[] liquidSphereFluids) {
        this.liquidSphereFluids = liquidSphereFluids;
    }

    public IBlockState[] getHugeLiquidSphereBlocks() {
        return this.hugeLiquidSphereBlocks;
    }

    public void setHugeLiquidSphereBlocks(IBlockState[] hugeLiquidSphereBlocks) {
        this.hugeLiquidSphereBlocks = hugeLiquidSphereBlocks;
    }

    public Block[] getHugeLiquidSphereFluids() {
        return this.hugeLiquidSphereFluids;
    }

    public void setHugeLiquidSphereFluids(Block[] hugeLiquidSphereFluids) {
        this.hugeLiquidSphereFluids = hugeLiquidSphereFluids;
    }

    public IBlockState[] getExtraOregen() {
        return this.extraOregen;
    }

    public void setExtraOregen(IBlockState[] blocks) {
        this.extraOregen = blocks;
    }

    public Block getFluidForTerrain() {
        return this.fluidForTerrain;
    }

    public void setFluidForTerrain(Block block) {
        this.fluidForTerrain = block;
    }

    public Block[] getFluidsForLakes() {
        return this.fluidsForLakes;
    }

    public void setFluidsForLakes(Block[] blocks) {
        this.fluidsForLakes = blocks;
    }

    public SkyDescriptor getSkyDescriptor() {
        return this.skyDescriptor;
    }

    public WeatherDescriptor getWeatherDescriptor() {
        return this.weatherDescriptor;
    }

    public void setWeatherDescriptor(WeatherDescriptor weatherDescriptor) {
        this.weatherDescriptor = weatherDescriptor;
    }

    public List<CelestialBodyDescriptor> getCelestialBodyDescriptors() {
        return this.celestialBodyDescriptors;
    }

    public String[] getDimensionTypes() {
        return this.dimensionTypes;
    }

    public void setDimensionTypes(String[] dimensionTypes) {
        this.dimensionTypes = dimensionTypes;
    }

    public List<MobDescriptor> getExtraMobs() {
        return this.extraMobs;
    }

    public boolean isPeaceful() {
        return this.peaceful;
    }

    public void setPeaceful(boolean peaceful) {
        this.peaceful = peaceful;
    }

    public boolean isNoanimals() {
        return this.noanimals;
    }

    public void setNoanimals(boolean noanimals) {
        this.noanimals = noanimals;
    }

    public long getPatreon1() {
        return this.patreon1;
    }

    public boolean isPatreonBitSet(PatreonType patreon) {
        return (this.patreon1 & 1L << patreon.getBit()) != 0L;
    }

    public void setPatreon1(long patreon1) {
        this.patreon1 = patreon1;
    }

    public void togglePatreonBit(PatreonType patreon) {
        this.patreon1 ^= 1L << patreon.getBit();
    }

    public boolean isShelter() {
        return this.shelter;
    }

    public void setShelter(boolean shelter) {
        this.shelter = shelter;
    }

    public boolean isRespawnHere() {
        return this.respawnHere;
    }

    public void setRespawnHere(boolean respawnHere) {
        this.respawnHere = respawnHere;
    }

    public boolean isCheater() {
        return this.cheater;
    }

    public void setCheater(boolean cheater) {
        this.cheater = cheater;
    }

    public Float getCelestialAngle() {
        return this.celestialAngle;
    }

    public Float getTimeSpeed() {
        return this.timeSpeed;
    }

    public void setCelestialAngle(Float celestialAngle) {
        this.celestialAngle = celestialAngle;
    }

    public void setTimeSpeed(Float timeSpeed) {
        this.timeSpeed = timeSpeed;
    }

    public void addProbe() {
        ++this.probeCounter;
    }

    public void removeProbe() {
        --this.probeCounter;
        if (this.probeCounter < 0) {
            this.probeCounter = 0;
        }
    }

    public int getProbeCounter() {
        return this.probeCounter;
    }

    public int getActualRfCost() {
        return this.actualRfCost;
    }

    public long getForcedDimensionSeed() {
        return this.forcedDimensionSeed;
    }

    public long getBaseSeed() {
        return this.baseSeed;
    }

    public int getWorldVersion() {
        return this.worldVersion;
    }
}

