/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ItemUtils;

@CharsetModule(name="tweak.equalizeMobChances", description="Allows a mob wearing armor comparable to yours to rarely spawn", profile=ModuleProfile.FORCED)
public class CharsetTweakMobEqualizer {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void upgradeMob(LivingSpawnEvent.SpecialSpawn event) {
        EnumDifficulty difficulty = event.getWorld().func_175659_aa();
        if (difficulty == null || difficulty.func_151525_a() <= 1) {
            return;
        }
        if (!(event.getEntityLiving() instanceof EntityMob)) {
            return;
        }
        EntityMob ent = (EntityMob)event.getEntityLiving();
        if (event.getWorld().field_73012_v.nextInt(400) > difficulty.func_151525_a()) {
            return;
        }
        if (!ent.func_98052_bS()) {
            return;
        }
        EntityPlayer template = this.pickNearPlayer(event);
        if (template == null) {
            return;
        }
        int equipmentCount = 0;
        ItemStack[] equipmentCopies = new ItemStack[6];
        boolean copyArmor = event.getEntity() instanceof IRangedAttackMob || event.getWorld().field_73012_v.nextBoolean();
        boolean copyWeapon = !(event.getEntity() instanceof IRangedAttackMob) || event.getWorld().field_73012_v.nextBoolean();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || !copyArmor) continue;
            ItemStack is = template.func_184582_a(slot);
            if (!is.func_190926_b() && is.func_77973_b().isValidArmor(is, slot, (Entity)ent)) {
                equipmentCopies[slot.ordinal()] = is.func_77946_l();
                ++equipmentCount;
                continue;
            }
            equipmentCopies[slot.ordinal()] = ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> carriedWeapons = new ArrayList<ItemStack>();
        if (copyWeapon) {
            ItemStack currentWeapon = ent.func_184582_a(EntityEquipmentSlot.MAINHAND);
            double currentWeaponDmg = ItemUtils.getAttributeValue((EntityEquipmentSlot)EntityEquipmentSlot.MAINHAND, (ItemStack)currentWeapon, (IAttribute)SharedMonsterAttributes.field_111264_e);
            for (int i = 0; i < 9; ++i) {
                double playerWeaponDmg;
                EnumAction act;
                ItemStack playerWeapon = template.field_71071_by.func_70301_a(i);
                if (playerWeapon.func_190926_b() || playerWeapon.func_190916_E() != 1 || playerWeapon.func_77976_d() != 1 || (act = playerWeapon.func_77975_n()) != EnumAction.BLOCK && act != EnumAction.NONE && act != EnumAction.BOW || !((playerWeaponDmg = ItemUtils.getAttributeValue((EntityEquipmentSlot)EntityEquipmentSlot.MAINHAND, (ItemStack)playerWeapon, (IAttribute)SharedMonsterAttributes.field_111264_e)) > currentWeaponDmg)) continue;
                carriedWeapons.add(playerWeapon.func_77946_l());
            }
        }
        if (!carriedWeapons.isEmpty()) {
            equipmentCopies[0] = ((ItemStack)carriedWeapons.get(event.getWorld().field_73012_v.nextInt(carriedWeapons.size()))).func_77946_l();
            ++equipmentCount;
        }
        if (equipmentCount <= 0) {
            return;
        }
        event.setCanceled(true);
        ent.func_180482_a(ent.field_70170_p.func_175649_E(new BlockPos(event.getEntity())), null);
        ent.func_98053_h(false);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (equipmentCopies[slot.ordinal()] != null) {
                ent.func_184201_a(slot, equipmentCopies[slot.ordinal()]);
            }
            ent.func_184642_a(slot, 0.0f);
        }
    }

    private EntityPlayer pickNearPlayer(LivingSpawnEvent.SpecialSpawn event) {
        double maxDistanceSq = Math.pow(128.0, 2.0);
        EntityPlayer secretary = null;
        int interviews = 0;
        for (EntityPlayer player : event.getWorld().field_73010_i) {
            int M;
            if (player.field_71075_bZ.field_75098_d || event.getEntity().func_70068_e((Entity)player) > maxDistanceSq || (M = event.getWorld().field_73012_v.nextInt(++interviews) + 1) > 1) continue;
            secretary = player;
        }
        return secretary;
    }
}

