/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak.fix.playerdamageanimation;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.module.tweak.fix.playerdamageanimation.PacketSyncAttackValue;

@CharsetModule(name="tweak.fix.playerdamageanimation", description="Fixes player directional damage animation.", profile=ModuleProfile.FORCED)
public class CharsetTweakFixPlayerDamageAnimation {
    @CharsetModule.PacketRegistry(value="fixPlyrDmgAnim")
    private PacketRegistry registry;
    private final Queue<EntityLivingBase> players = new ArrayDeque<EntityLivingBase>();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registry.registerPacket(1, PacketSyncAttackValue.class);
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP && !event.getEntityLiving().func_130014_f_().field_72995_K) {
            this.players.add(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            while (this.players.size() > 0) {
                EntityLivingBase player = this.players.remove();
                this.registry.sendTo((Packet)new PacketSyncAttackValue((Entity)player), (EntityPlayer)player);
            }
        }
    }
}

