/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.genetics.TreeDatabaseTab;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.analyzer.DatabasePlugin;
import forestry.core.genetics.analyzer.MutationsTab;
import forestry.core.genetics.analyzer.ProductsTab;
import forestry.core.items.ItemFruit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TreePlugin
extends DatabasePlugin<ITree> {
    public static final TreePlugin INSTANCE = new TreePlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private TreePlugin() {
        super(new TreeDatabaseTab(true), new TreeDatabaseTab(false), new ProductsTab(() -> ItemFruit.EnumFruit.CHERRY.getStack()), new MutationsTab(() -> ModuleArboriculture.getItems().grafter.getItemStack()));
        NonNullList treeList = NonNullList.func_191196_a();
        ModuleArboriculture.getItems().sapling.addCreativeItems((NonNullList<ItemStack>)treeList, false);
        for (ItemStack treeStack : treeList) {
            IAlleleTreeSpecies species = TreeGenome.getSpecies(treeStack);
            this.iconStacks.put(species.getUID(), treeStack);
        }
    }

    @Override
    public Map<String, ItemStack> getIndividualStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"treealyzer");
    }
}

