/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.apiculture.ModuleApiculture;
import forestry.arboriculture.ModuleArboriculture;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.utils.ClimateUtil;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.NetworkUtil;
import java.io.IOException;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileLeaves
extends TileTreeContainer
implements IPollinatable,
IFruitBearer,
IButterflyNursery,
IRipeningPacketReceiver {
    private int colourFruits;
    @Nullable
    private ResourceLocation fruitSprite;
    @Nullable
    private IAlleleTreeSpecies species;
    @Nullable
    private IButterfly caterpillar;
    private boolean isFruitLeaf;
    private boolean isPollinatedState;
    private int ripeningTime;
    private short ripeningPeriod = (short)32766;
    private int maturationTime;
    private int damage;
    private IEffectData[] effectData = new IEffectData[2];
    private boolean checkedForConversionToDefaultLeaves;
    private static final short hasFruitFlag = 1;
    private static final short isPollinatedFlag = 2;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        ITree tree;
        super.func_145839_a(nbttagcompound);
        this.ripeningTime = nbttagcompound.func_74765_d("RT");
        this.damage = nbttagcompound.func_74762_e("ENC");
        if (nbttagcompound.func_74764_b("CATER")) {
            this.maturationTime = nbttagcompound.func_74762_e("CATMAT");
            this.caterpillar = ButterflyManager.butterflyRoot.getMember(nbttagcompound.func_74775_l("CATER"));
        }
        if ((tree = this.getTree()) != null) {
            this.setTree(tree);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("RT", this.getRipeningTime());
        nbtTagCompound.func_74768_a("ENC", this.damage);
        if (this.caterpillar != null) {
            nbtTagCompound.func_74768_a("CATMAT", this.maturationTime);
            NBTTagCompound caterpillarNbt = new NBTTagCompound();
            this.caterpillar.writeToNBT(caterpillarNbt);
            nbtTagCompound.func_74782_a("CATER", (NBTBase)caterpillarNbt);
        }
        return nbtTagCompound;
    }

    @Override
    public void onBlockTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        ITreeGenome genome = tree.getGenome();
        IAlleleTreeSpecies primary = genome.getPrimary();
        if (!this.checkedForConversionToDefaultLeaves) {
            if (this.shouldConvertToDefaultLeaves()) {
                IBlockState defaultLeaves = ModuleArboriculture.getBlocks().getDefaultLeaves(primary.getUID());
                worldIn.func_175656_a(this.func_174877_v(), defaultLeaves);
                return;
            }
            this.checkedForConversionToDefaultLeaves = true;
        }
        boolean isDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        for (ILeafTickHandler tickHandler : primary.getRoot().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(tree, this.field_145850_b, rand, this.func_174877_v(), isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.hasFruit() && this.getRipeningTime() < this.ripeningPeriod) {
            ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode(this.field_145850_b);
            float sappinessModifier = treekeepingMode.getSappinessModifier(genome, 1.0f);
            float sappiness = genome.getSappiness() * sappinessModifier;
            if (rand.nextFloat() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = tree.doEffect(this.effectData, this.field_145850_b, this.func_174877_v());
    }

    private boolean shouldConvertToDefaultLeaves() {
        ITree tree;
        return this.getOwnerHandler().getOwner() == null && (tree = this.getTree()) != null && tree.getGenome().matchesTemplateGenome();
    }

    @Override
    public void setTree(ITree tree) {
        super.setTree(tree);
        ITreeGenome genome = tree.getGenome();
        this.species = genome.getPrimary();
        if (tree.canBearFruit()) {
            IFruitProvider fruitProvider = genome.getFruitProvider();
            this.isFruitLeaf = fruitProvider.isFruitLeaf(genome, this.field_145850_b, this.func_174877_v());
            if (this.isFruitLeaf) {
                this.fruitSprite = this.species == TreeDefinition.Oak.getGenome().getPrimary() && fruitProvider == AlleleFruits.fruitApple.getProvider() ? null : fruitProvider.getSprite(genome, (IBlockAccess)this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
                this.ripeningPeriod = (short)tree.getGenome().getFruitProvider().getRipeningPeriod();
            }
        } else {
            this.isFruitLeaf = false;
            this.fruitSprite = null;
        }
        this.func_70296_d();
    }

    private static boolean isDestroyed(@Nullable ITree tree, int damage) {
        return tree != null && damage > tree.getResilience();
    }

    @Override
    public boolean isPollinated() {
        ITree tree = this.getTree();
        return tree != null && !TileLeaves.isDestroyed(tree, this.damage) && tree.getMate() != null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFoliageColour(EntityPlayer player) {
        boolean showPollinated = this.isPollinatedState && GeneticsUtil.hasNaturalistEye(player);
        int baseColor = this.getLeafSpriteProvider().getColor(showPollinated);
        ITree tree = this.getTree();
        if (TileLeaves.isDestroyed(tree, this.damage)) {
            return ColourUtil.addRGBComponents(baseColor, 92, 61, 0);
        }
        if (this.caterpillar != null) {
            return ColourUtil.multiplyRGBComponents(baseColor, 1.5f);
        }
        return baseColor;
    }

    public int getFruitColour() {
        if (this.colourFruits == 0 && this.hasFruit()) {
            this.colourFruits = this.determineFruitColour();
        }
        return this.colourFruits;
    }

    private int determineFruitColour() {
        ITree tree = this.getTree();
        if (tree == null) {
            tree = TreeDefinition.Cherry.getIndividual();
        }
        ITreeGenome genome = tree.getGenome();
        IFruitProvider fruit = genome.getFruitProvider();
        return fruit.getColour(genome, (IBlockAccess)this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLeaveSprite(boolean fancy) {
        ILeafSpriteProvider leafSpriteProvider = this.getLeafSpriteProvider();
        return leafSpriteProvider.getSprite(this.isPollinatedState, fancy);
    }

    @SideOnly(value=Side.CLIENT)
    private ILeafSpriteProvider getLeafSpriteProvider() {
        if (this.species != null) {
            return this.species.getLeafSpriteProvider();
        }
        IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.getIndividual().getGenome().getPrimary();
        return oakSpecies.getLeafSpriteProvider();
    }

    @Nullable
    public ResourceLocation getFruitSprite() {
        return this.fruitSprite;
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    @Override
    public EnumPlantType getPlantType() {
        ITree tree = this.getTree();
        if (tree == null) {
            return EnumPlantType.Plains;
        }
        return tree.getGenome().getPrimary().getPlantType();
    }

    @Override
    public boolean canMateWith(IIndividual individual) {
        if (individual instanceof ITree) {
            ITree tree = this.getTree();
            return tree != null && tree.getMate() == null && (ModuleApiculture.doSelfPollination || !tree.isGeneticEqual(individual));
        }
        return false;
    }

    @Override
    public void mateWith(IIndividual individual) {
        if (individual instanceof ITree) {
            ITree tree = this.getTree();
            if (tree == null || this.field_145850_b == null) {
                return;
            }
            tree.mate((ITree)individual);
            if (!this.field_145850_b.field_72995_K) {
                this.sendNetworkUpdate();
            }
        }
    }

    @Override
    public ITree getPollen() {
        return this.getTree();
    }

    public String getUnlocalizedName() {
        ITree tree = this.getTree();
        if (tree == null) {
            return "for.leaves.corrupted";
        }
        return tree.getGenome().getPrimary().getUnlocalizedName();
    }

    private void sendNetworkUpdate() {
        NetworkUtil.sendNetworkPacket(new PacketTileStream(this), this.field_174879_c, this.field_145850_b);
    }

    private void sendNetworkUpdateRipening() {
        int newColourFruits = this.determineFruitColour();
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        PacketRipeningUpdate ripeningUpdate = new PacketRipeningUpdate(this);
        NetworkUtil.sendNetworkPacket(ripeningUpdate, this.field_174879_c, this.field_145850_b);
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        int leafState = 0;
        boolean hasFruit = this.hasFruit();
        if (this.isPollinated()) {
            leafState = (byte)(leafState | 2);
        }
        if (hasFruit) {
            leafState = (byte)(leafState | 1);
        }
        data.writeByte(leafState);
        if (hasFruit) {
            String fruitAlleleUID = this.getTree().getGenome().getActiveAllele(EnumTreeChromosome.FRUITS).getUID();
            int colourFruits = this.getFruitColour();
            data.func_180714_a(fruitAlleleUID);
            data.writeInt(colourFruits);
        }
    }

    @Override
    public void readData(PacketBufferForestry data) throws IOException {
        IAllele[] treeTemplate;
        String speciesUID = data.readString();
        byte leafState = data.readByte();
        this.isFruitLeaf = (leafState & 1) > 0;
        this.isPollinatedState = (leafState & 2) > 0;
        String fruitAlleleUID = null;
        if (this.isFruitLeaf) {
            fruitAlleleUID = data.readString();
            this.colourFruits = data.readInt();
        }
        if ((treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID)) != null) {
            IAllele fruitAllele;
            if (fruitAlleleUID != null && (fruitAllele = AlleleManager.alleleRegistry.getAllele(fruitAlleleUID)) instanceof IAlleleFruit) {
                treeTemplate[EnumTreeChromosome.FRUITS.ordinal()] = fruitAllele;
            }
            ITree tree = TreeManager.treeRoot.templateAsIndividual(treeTemplate);
            if (this.isPollinatedState) {
                tree.mate(tree);
            }
            this.setTree(tree);
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public void fromRipeningPacket(int newColourFruits) {
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    @Override
    public NonNullList<ItemStack> pickFruit(ItemStack tool) {
        ITree tree = this.getTree();
        if (tree == null || !this.hasFruit()) {
            return NonNullList.func_191196_a();
        }
        NonNullList<ItemStack> produceStacks = tree.produceStacks(this.field_145850_b, this.func_174877_v(), this.getRipeningTime());
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return produceStacks;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        ITree tree = this.getTree();
        if (tree == null) {
            return EnumFruitFamily.NONE;
        }
        return tree.getGenome().getFruitProvider().getFamily();
    }

    @Override
    public float getRipeness() {
        if (this.ripeningPeriod == 0) {
            return 1.0f;
        }
        if (this.getTree() == null) {
            return 0.0f;
        }
        return (float)this.getRipeningTime() / (float)this.ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !TileLeaves.isDestroyed(this.getTree(), this.damage);
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || !this.isFruitLeaf || this.getRipeningTime() >= this.ripeningPeriod) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.ripeningPeriod * add);
        this.sendNetworkUpdateRipening();
    }

    @Nullable
    public String getSpeciesUID() {
        if (this.species == null) {
            return null;
        }
        return this.species.getUID();
    }

    private void matureCaterpillar() {
        if (this.caterpillar == null) {
            return;
        }
        ++this.maturationTime;
        ITree tree = this.getTree();
        boolean wasDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        this.damage += this.caterpillar.getGenome().getMetabolism();
        IButterflyGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getLifespan() / (float)(caterpillarGenome.getFertility() * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            ButterflyManager.butterflyRoot.plantCocoon(this.field_145850_b, this.field_174879_c.func_177977_b(), this.getCaterpillar(), this.getOwnerHandler().getOwner(), 0, false);
            this.setCaterpillar(null);
        } else if (!wasDestroyed && TileLeaves.isDestroyed(tree, this.damage)) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    @Override
    @Nullable
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(@Nullable IButterfly caterpillar) {
        this.maturationTime = 0;
        this.caterpillar = caterpillar;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly caterpillar) {
        ITree tree = this.getTree();
        return !TileLeaves.isDestroyed(tree, this.damage) && this.caterpillar == null;
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.field_174879_c);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.field_145850_b.func_180494_b(this.field_174879_c), this.field_145850_b, this.field_174879_c);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(ClimateUtil.getHumidity(this.field_145850_b, this.field_174879_c));
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }
}

