/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.core.utils.Translator;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.text.WordUtils;

public class LocalizedConfiguration
extends Configuration {
    public LocalizedConfiguration(File file, String configVersion) {
        super(file, configVersion);
    }

    public Configuration setCategoryLanguageKey(String categoryName) {
        String categoryKey = "for.config" + categoryName;
        return super.setCategoryLanguageKey(categoryName, categoryKey);
    }

    public boolean getBoolean(String category, String name, boolean defaultValue, String comment) {
        Property prop = this.get(category, name, defaultValue);
        prop.setComment(comment + " [default: " + defaultValue + "]");
        return prop.getBoolean(defaultValue);
    }

    public boolean getBooleanLocalized(String category, String name, boolean defaultValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return this.getBoolean(name, category, defaultValue, comment, langKey);
    }

    public String getStringLocalized(String category, String name, String defaultValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return this.getString(name, category, defaultValue, comment, langKey);
    }

    public String getStringLocalized(String category, String name, String defaultValue, String[] validValues) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        Property prop = this.get(category, name, defaultValue);
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [default: " + defaultValue + "] [valid: " + Arrays.toString(prop.getValidValues()) + "]");
        return prop.getString();
    }

    public <T extends Enum<T>> T getEnumLocalized(String category, String name, T defaultValue, T[] validEnumValues) {
        T enumValue;
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        Property prop = this.get(category, name, defaultValue.name());
        String[] validValues = new String[validEnumValues.length];
        for (int i = 0; i < validEnumValues.length; ++i) {
            enumValue = validEnumValues[i];
            validValues[i] = ((Enum)enumValue).name();
        }
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [default: " + defaultValue + "] [valid: " + Arrays.toString(prop.getValidValues()) + "]");
        String stringValue = prop.getString();
        enumValue = defaultValue;
        for (int i = 0; i < validValues.length; ++i) {
            if (!stringValue.equals(validValues[i])) continue;
            enumValue = validEnumValues[i];
        }
        return enumValue;
    }

    public String[] getStringListLocalized(String category, String name, String[] defaultValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return super.getStringList(name, category, defaultValue, comment);
    }

    public String[] getStringListLocalized(String category, String name, String[] defaultValue, String[] validValues) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.setValidValues(validValues);
        prop.setComment(comment + " [default: " + Arrays.toString(defaultValue) + "] [valid: " + Arrays.toString(prop.getValidValues()) + "]");
        return prop.getStringList();
    }

    public float getFloatLocalized(String category, String name, float defaultValue, float minValue, float maxValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return this.getFloat(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public int getIntLocalized(String category, String name, int defaultValue, int minValue, int maxValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return this.getInt(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public void addCategoryCommentLocalized(String category) {
        String langKey = "for.config." + category + '.' + "category_comment";
        this.setCategoryComment(category, WordUtils.wrap((String)Translator.translateToLocal(langKey), (int)100));
    }
}

