/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IDatabasePlugin;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesDisplayHelper;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class SpeciesDisplayHelper
implements ISpeciesDisplayHelper {
    private final Table<ISpeciesType, String, ItemStack> iconStacks = HashBasedTable.create();
    @Nullable
    private final IAlyzerPlugin alyzerPlugin;
    @Nullable
    private final IDatabasePlugin databasePlugin;
    private final ISpeciesRoot root;

    public SpeciesDisplayHelper(ISpeciesRoot root, @Nullable Function<ISpeciesDisplayHelper, IAlyzerPlugin> alyzerPlugin, @Nullable Function<ISpeciesDisplayHelper, IDatabasePlugin> databasePlugin) {
        this.root = root;
        for (IIndividual iIndividual : root.getIndividualTemplates()) {
            for (ISpeciesType type : root.getTypes()) {
                ItemStack itemStack = root.getMemberStack(iIndividual, type);
                this.iconStacks.put((Object)type, (Object)iIndividual.getGenome().getPrimary().getUID(), (Object)itemStack);
            }
        }
        this.alyzerPlugin = alyzerPlugin == null ? null : alyzerPlugin.apply(this);
        this.databasePlugin = databasePlugin == null ? null : databasePlugin.apply(this);
    }

    @Override
    public Optional<IDatabasePlugin> getDatabasePlugin() {
        return Optional.ofNullable(this.databasePlugin);
    }

    @Override
    public Optional<IAlyzerPlugin> getAlyzerPlugin() {
        return Optional.ofNullable(this.alyzerPlugin);
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species, ISpeciesType type) {
        return (ItemStack)this.iconStacks.get((Object)species.getUID(), (Object)type);
    }

    @Override
    public ItemStack getDisplayStack(IAlleleSpecies species) {
        return this.getDisplayStack(species, this.root.getIconType());
    }
}

